/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.apigateway.;
import software.amazon.awscdk.services.apigateway.IApiKey;
import software.amazon.awscdk.services.apigateway.QuotaSettings;
import software.amazon.awscdk.services.apigateway.ThrottleSettings;
import software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage;
import software.amazon.awscdk.services.apigateway.UsagePlanProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-apigateway.UsagePlan")
public class UsagePlan
extends Resource {
    protected UsagePlan(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UsagePlan(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public UsagePlan(@NotNull Construct scope, @NotNull String id, @Nullable UsagePlanProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public UsagePlan(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void addApiKey(@NotNull IApiKey apiKey) {
        Kernel.call((Object)((Object)this), (String)"addApiKey", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(apiKey, "apiKey is required")});
    }

    public void addApiStage(@NotNull UsagePlanPerApiStage apiStage) {
        Kernel.call((Object)((Object)this), (String)"addApiStage", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(apiStage, "apiStage is required")});
    }

    @NotNull
    public String getUsagePlanId() {
        return (String)Kernel.get((Object)((Object)this), (String)"usagePlanId", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<UsagePlan> {
        private final Construct scope;
        private final String id;
        private UsagePlanProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder apiKey(IApiKey apiKey) {
            this.props().apiKey(apiKey);
            return this;
        }

        public Builder apiStages(List<? extends UsagePlanPerApiStage> apiStages) {
            this.props().apiStages(apiStages);
            return this;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder name(String name) {
            this.props().name(name);
            return this;
        }

        public Builder quota(QuotaSettings quota) {
            this.props().quota(quota);
            return this;
        }

        public Builder throttle(ThrottleSettings throttle) {
            this.props().throttle(throttle);
            return this;
        }

        public UsagePlan build() {
            return new UsagePlan(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private UsagePlanProps.Builder props() {
            if (this.props == null) {
                this.props = new UsagePlanProps.Builder();
            }
            return this.props;
        }
    }
}

