package software.amazon.awscdk.services.apigateway;

/**
 * Supported types of gateway responses.
 * <p>
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2021-02-09T15:09:16.055Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.ResponseType")
public class ResponseType extends software.amazon.jsii.JsiiObject {

    protected ResponseType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ResponseType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ACCESS_DENIED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "ACCESS_DENIED", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        API_CONFIGURATION_ERROR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "API_CONFIGURATION_ERROR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        AUTHORIZER_CONFIGURATION_ERROR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "AUTHORIZER_CONFIGURATION_ERROR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        AUTHORIZER_FAILURE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "AUTHORIZER_FAILURE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        BAD_REQUEST_BODY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "BAD_REQUEST_BODY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        BAD_REQUEST_PARAMETERS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "BAD_REQUEST_PARAMETERS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        DEFAULT_4_XX = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "DEFAULT_4XX", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        DEFAULT_5_XX = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "DEFAULT_5XX", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        EXPIRED_TOKEN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "EXPIRED_TOKEN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        INTEGRATION_FAILURE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "INTEGRATION_FAILURE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        INTEGRATION_TIMEOUT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "INTEGRATION_TIMEOUT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        INVALID_API_KEY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "INVALID_API_KEY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        INVALID_SIGNATURE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "INVALID_SIGNATURE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        MISSING_AUTHENTICATION_TOKEN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "MISSING_AUTHENTICATION_TOKEN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        QUOTA_EXCEEDED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "QUOTA_EXCEEDED", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        REQUEST_TOO_LARGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "REQUEST_TOO_LARGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        RESOURCE_NOT_FOUND = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "RESOURCE_NOT_FOUND", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        THROTTLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "THROTTLED", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        UNAUTHORIZED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "UNAUTHORIZED", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        UNSUPPORTED_MEDIA_TYPE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "UNSUPPORTED_MEDIA_TYPE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
        WAF_FILTERED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.ResponseType.class, "WAF_FILTERED", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
    }

    /**
     * A custom response type to suppport future cases.
     * <p>
     * @param type This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.ResponseType of(final @org.jetbrains.annotations.NotNull java.lang.String type) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.ResponseType.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class), new Object[] { java.util.Objects.requireNonNull(type, "type is required") });
    }

    /**
     * The gateway response for authorization failure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType ACCESS_DENIED;

    /**
     * The gateway response for an invalid API configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType API_CONFIGURATION_ERROR;

    /**
     * The gateway response for failing to connect to a custom or Amazon Cognito authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType AUTHORIZER_CONFIGURATION_ERROR;

    /**
     * The gateway response when a custom or Amazon Cognito authorizer failed to authenticate the caller.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType AUTHORIZER_FAILURE;

    /**
     * The gateway response when the request body cannot be validated according to an enabled request validator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType BAD_REQUEST_BODY;

    /**
     * The gateway response when the request parameter cannot be validated according to an enabled request validator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType BAD_REQUEST_PARAMETERS;

    /**
     * The default gateway response for an unspecified response type with the status code of 4XX.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType DEFAULT_4_XX;

    /**
     * The default gateway response for an unspecified response type with a status code of 5XX.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType DEFAULT_5_XX;

    /**
     * The gateway response for an AWS authentication token expired error.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType EXPIRED_TOKEN;

    /**
     * The gateway response for an integration failed error.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType INTEGRATION_FAILURE;

    /**
     * The gateway response for an integration timed out error.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType INTEGRATION_TIMEOUT;

    /**
     * The gateway response for an invalid API key submitted for a method requiring an API key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType INVALID_API_KEY;

    /**
     * The gateway response for an invalid AWS signature error.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType INVALID_SIGNATURE;

    /**
     * The gateway response for a missing authentication token error, including the cases when the client attempts to invoke an unsupported API method or resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType MISSING_AUTHENTICATION_TOKEN;

    /**
     * The gateway response for the usage plan quota exceeded error.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType QUOTA_EXCEEDED;

    /**
     * The gateway response for the request too large error.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType REQUEST_TOO_LARGE;

    /**
     * The gateway response when API Gateway cannot find the specified resource after an API request passes authentication and authorization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType RESOURCE_NOT_FOUND;

    /**
     * The gateway response when usage plan, method, stage, or account level throttling limits exceeded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType THROTTLED;

    /**
     * The gateway response when the custom or Amazon Cognito authorizer failed to authenticate the caller.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType UNAUTHORIZED;

    /**
     * The gateway response when a payload is of an unsupported media type, if strict passthrough behavior is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType UNSUPPORTED_MEDIA_TYPE;

    /**
     * The gateway response when a request is blocked by AWS WAF.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigateway.ResponseType WAF_FILTERED;

    /**
     * Valid value of response type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResponseType() {
        return software.amazon.jsii.Kernel.get(this, "responseType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
