package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-17T00:04:38.971Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.MethodOptions")
@software.amazon.jsii.Jsii.Proxy(MethodOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MethodOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates whether the method requires clients to submit a valid API key.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getApiKeyRequired() {
        return null;
    }

    /**
     * A list of authorization scopes configured on the method.
     * <p>
     * The scopes are used with
     * a COGNITO_USER_POOLS authorizer to authorize the method invocation.
     * <p>
     * Default: - no authorization scopes
     * <p>
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAuthorizationScopes() {
        return null;
    }

    /**
     * Method authorization. If the value is set of `Custom`, an `authorizer` must also be specified.
     * <p>
     * If you're using one of the authorizers that are available via the {&#64;link Authorizer} class, such as {&#64;link Authorizer#token()},
     * it is recommended that this option not be specified. The authorizer will take care of setting the correct authorization type.
     * However, specifying an authorization type using this property that conflicts with what is expected by the {&#64;link Authorizer}
     * will result in an error.
     * <p>
     * Default: - open access unless `authorizer` is specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.AuthorizationType getAuthorizationType() {
        return null;
    }

    /**
     * If `authorizationType` is `Custom`, this specifies the ID of the method authorizer resource.
     * <p>
     * If specified, the value of <code>authorizationType</code> must be set to <code>Custom</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.IAuthorizer getAuthorizer() {
        return null;
    }

    /**
     * The responses that can be sent to the client who calls the method.
     * <p>
     * Default: None
     * This property is not required, but if these are not supplied for a Lambda
     * proxy integration, the Lambda function must return a value of the correct format,
     * for the integration response to be correctly mapped to a response to the client.
     * <p>
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-settings-method-response.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.apigateway.MethodResponse> getMethodResponses() {
        return null;
    }

    /**
     * A friendly operation name for the method.
     * <p>
     * For example, you can assign the
     * OperationName of ListPets for the GET /pets method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOperationName() {
        return null;
    }

    /**
     * The models which describe data structure of request payload.
     * <p>
     * When
     * combined with <code>requestValidator</code> or <code>requestValidatorOptions</code>, the service
     * will validate the API request payload before it reaches the API's Integration (including proxies).
     * Specify <code>requestModels</code> as key-value pairs, with a content type
     * (e.g. <code>'application/json'</code>) as the key and an API Gateway Model as the value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * Object userModel = api.addModel("UserModel", Map.of(
     *         "schema", Map.of(
     *                 "type", apigateway.JsonSchemaType.getOBJECT(),
     *                 "properties", Map.of(
     *                         "userId", Map.of(
     *                                 "type", apigateway.JsonSchema.getSTRING()),
     *                         "name", Map.of(
     *                                 "type", apigateway.JsonSchema.getSTRING())),
     *                 "required", asList("userId"))));
     * api.root.addResource('user').addMethod("POST",
     * new LambdaIntegration(userLambda), Map.of(
     *         "requestModels", Map.of(
     *                 "application/json", userModel)));}</pre></blockquote>
     * <p>
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-settings-method-request.html#setup-method-request-model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> getRequestModels() {
        return null;
    }

    /**
     * The request parameters that API Gateway accepts.
     * <p>
     * Specify request parameters
     * as key-value pairs (string-to-Boolean mapping), with a source as the key and
     * a Boolean as the value. The Boolean specifies whether a parameter is required.
     * A source must match the format method.request.location.name, where the location
     * is querystring, path, or header, and name is a valid, unique parameter name.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Boolean> getRequestParameters() {
        return null;
    }

    /**
     * The ID of the associated request validator.
     * <p>
     * Only one of <code>requestValidator</code> or <code>requestValidatorOptions</code> must be specified.
     * Works together with <code>requestModels</code> or <code>requestParameters</code> to validate
     * the request before it reaches integration like Lambda Proxy Integration.
     * <p>
     * Default: - No default validator
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.IRequestValidator getRequestValidator() {
        return null;
    }

    /**
     * Request validator options to create new validator Only one of `requestValidator` or `requestValidatorOptions` must be specified.
     * <p>
     * Works together with <code>requestModels</code> or <code>requestParameters</code> to validate
     * the request before it reaches integration like Lambda Proxy Integration.
     * <p>
     * Default: - No default validator
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.RequestValidatorOptions getRequestValidatorOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MethodOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MethodOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MethodOptions> {
        private java.lang.Boolean apiKeyRequired;
        private java.util.List<java.lang.String> authorizationScopes;
        private software.amazon.awscdk.services.apigateway.AuthorizationType authorizationType;
        private software.amazon.awscdk.services.apigateway.IAuthorizer authorizer;
        private java.util.List<software.amazon.awscdk.services.apigateway.MethodResponse> methodResponses;
        private java.lang.String operationName;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> requestModels;
        private java.util.Map<java.lang.String, java.lang.Boolean> requestParameters;
        private software.amazon.awscdk.services.apigateway.IRequestValidator requestValidator;
        private software.amazon.awscdk.services.apigateway.RequestValidatorOptions requestValidatorOptions;

        /**
         * Sets the value of {@link MethodOptions#getApiKeyRequired}
         * @param apiKeyRequired Indicates whether the method requires clients to submit a valid API key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyRequired(java.lang.Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        /**
         * Sets the value of {@link MethodOptions#getAuthorizationScopes}
         * @param authorizationScopes A list of authorization scopes configured on the method.
         *                            The scopes are used with
         *                            a COGNITO_USER_POOLS authorizer to authorize the method invocation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationScopes(java.util.List<java.lang.String> authorizationScopes) {
            this.authorizationScopes = authorizationScopes;
            return this;
        }

        /**
         * Sets the value of {@link MethodOptions#getAuthorizationType}
         * @param authorizationType Method authorization. If the value is set of `Custom`, an `authorizer` must also be specified.
         *                          If you're using one of the authorizers that are available via the {&#64;link Authorizer} class, such as {&#64;link Authorizer#token()},
         *                          it is recommended that this option not be specified. The authorizer will take care of setting the correct authorization type.
         *                          However, specifying an authorization type using this property that conflicts with what is expected by the {&#64;link Authorizer}
         *                          will result in an error.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationType(software.amazon.awscdk.services.apigateway.AuthorizationType authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        /**
         * Sets the value of {@link MethodOptions#getAuthorizer}
         * @param authorizer If `authorizationType` is `Custom`, this specifies the ID of the method authorizer resource.
         *                   If specified, the value of <code>authorizationType</code> must be set to <code>Custom</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizer(software.amazon.awscdk.services.apigateway.IAuthorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        /**
         * Sets the value of {@link MethodOptions#getMethodResponses}
         * @param methodResponses The responses that can be sent to the client who calls the method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder methodResponses(java.util.List<? extends software.amazon.awscdk.services.apigateway.MethodResponse> methodResponses) {
            this.methodResponses = (java.util.List<software.amazon.awscdk.services.apigateway.MethodResponse>)methodResponses;
            return this;
        }

        /**
         * Sets the value of {@link MethodOptions#getOperationName}
         * @param operationName A friendly operation name for the method.
         *                      For example, you can assign the
         *                      OperationName of ListPets for the GET /pets method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operationName(java.lang.String operationName) {
            this.operationName = operationName;
            return this;
        }

        /**
         * Sets the value of {@link MethodOptions#getRequestModels}
         * @param requestModels The models which describe data structure of request payload.
         *                      When
         *                      combined with <code>requestValidator</code> or <code>requestValidatorOptions</code>, the service
         *                      will validate the API request payload before it reaches the API's Integration (including proxies).
         *                      Specify <code>requestModels</code> as key-value pairs, with a content type
         *                      (e.g. <code>'application/json'</code>) as the key and an API Gateway Model as the value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder requestModels(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.apigateway.IModel> requestModels) {
            this.requestModels = (java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel>)requestModels;
            return this;
        }

        /**
         * Sets the value of {@link MethodOptions#getRequestParameters}
         * @param requestParameters The request parameters that API Gateway accepts.
         *                          Specify request parameters
         *                          as key-value pairs (string-to-Boolean mapping), with a source as the key and
         *                          a Boolean as the value. The Boolean specifies whether a parameter is required.
         *                          A source must match the format method.request.location.name, where the location
         *                          is querystring, path, or header, and name is a valid, unique parameter name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder requestParameters(java.util.Map<java.lang.String, ? extends java.lang.Boolean> requestParameters) {
            this.requestParameters = (java.util.Map<java.lang.String, java.lang.Boolean>)requestParameters;
            return this;
        }

        /**
         * Sets the value of {@link MethodOptions#getRequestValidator}
         * @param requestValidator The ID of the associated request validator.
         *                         Only one of <code>requestValidator</code> or <code>requestValidatorOptions</code> must be specified.
         *                         Works together with <code>requestModels</code> or <code>requestParameters</code> to validate
         *                         the request before it reaches integration like Lambda Proxy Integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestValidator(software.amazon.awscdk.services.apigateway.IRequestValidator requestValidator) {
            this.requestValidator = requestValidator;
            return this;
        }

        /**
         * Sets the value of {@link MethodOptions#getRequestValidatorOptions}
         * @param requestValidatorOptions Request validator options to create new validator Only one of `requestValidator` or `requestValidatorOptions` must be specified.
         *                                Works together with <code>requestModels</code> or <code>requestParameters</code> to validate
         *                                the request before it reaches integration like Lambda Proxy Integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestValidatorOptions(software.amazon.awscdk.services.apigateway.RequestValidatorOptions requestValidatorOptions) {
            this.requestValidatorOptions = requestValidatorOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MethodOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MethodOptions build() {
            return new Jsii$Proxy(apiKeyRequired, authorizationScopes, authorizationType, authorizer, methodResponses, operationName, requestModels, requestParameters, requestValidator, requestValidatorOptions);
        }
    }

    /**
     * An implementation for {@link MethodOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MethodOptions {
        private final java.lang.Boolean apiKeyRequired;
        private final java.util.List<java.lang.String> authorizationScopes;
        private final software.amazon.awscdk.services.apigateway.AuthorizationType authorizationType;
        private final software.amazon.awscdk.services.apigateway.IAuthorizer authorizer;
        private final java.util.List<software.amazon.awscdk.services.apigateway.MethodResponse> methodResponses;
        private final java.lang.String operationName;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> requestModels;
        private final java.util.Map<java.lang.String, java.lang.Boolean> requestParameters;
        private final software.amazon.awscdk.services.apigateway.IRequestValidator requestValidator;
        private final software.amazon.awscdk.services.apigateway.RequestValidatorOptions requestValidatorOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiKeyRequired = software.amazon.jsii.Kernel.get(this, "apiKeyRequired", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.authorizationScopes = software.amazon.jsii.Kernel.get(this, "authorizationScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.authorizationType = software.amazon.jsii.Kernel.get(this, "authorizationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.AuthorizationType.class));
            this.authorizer = software.amazon.jsii.Kernel.get(this, "authorizer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IAuthorizer.class));
            this.methodResponses = software.amazon.jsii.Kernel.get(this, "methodResponses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.MethodResponse.class)));
            this.operationName = software.amazon.jsii.Kernel.get(this, "operationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.requestModels = software.amazon.jsii.Kernel.get(this, "requestModels", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IModel.class)));
            this.requestParameters = software.amazon.jsii.Kernel.get(this, "requestParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class)));
            this.requestValidator = software.amazon.jsii.Kernel.get(this, "requestValidator", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IRequestValidator.class));
            this.requestValidatorOptions = software.amazon.jsii.Kernel.get(this, "requestValidatorOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.RequestValidatorOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.Boolean apiKeyRequired, final java.util.List<java.lang.String> authorizationScopes, final software.amazon.awscdk.services.apigateway.AuthorizationType authorizationType, final software.amazon.awscdk.services.apigateway.IAuthorizer authorizer, final java.util.List<? extends software.amazon.awscdk.services.apigateway.MethodResponse> methodResponses, final java.lang.String operationName, final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.apigateway.IModel> requestModels, final java.util.Map<java.lang.String, ? extends java.lang.Boolean> requestParameters, final software.amazon.awscdk.services.apigateway.IRequestValidator requestValidator, final software.amazon.awscdk.services.apigateway.RequestValidatorOptions requestValidatorOptions) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiKeyRequired = apiKeyRequired;
            this.authorizationScopes = authorizationScopes;
            this.authorizationType = authorizationType;
            this.authorizer = authorizer;
            this.methodResponses = (java.util.List<software.amazon.awscdk.services.apigateway.MethodResponse>)methodResponses;
            this.operationName = operationName;
            this.requestModels = (java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel>)requestModels;
            this.requestParameters = (java.util.Map<java.lang.String, java.lang.Boolean>)requestParameters;
            this.requestValidator = requestValidator;
            this.requestValidatorOptions = requestValidatorOptions;
        }

        @Override
        public final java.lang.Boolean getApiKeyRequired() {
            return this.apiKeyRequired;
        }

        @Override
        public final java.util.List<java.lang.String> getAuthorizationScopes() {
            return this.authorizationScopes;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.AuthorizationType getAuthorizationType() {
            return this.authorizationType;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IAuthorizer getAuthorizer() {
            return this.authorizer;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.apigateway.MethodResponse> getMethodResponses() {
            return this.methodResponses;
        }

        @Override
        public final java.lang.String getOperationName() {
            return this.operationName;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> getRequestModels() {
            return this.requestModels;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Boolean> getRequestParameters() {
            return this.requestParameters;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IRequestValidator getRequestValidator() {
            return this.requestValidator;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.RequestValidatorOptions getRequestValidatorOptions() {
            return this.requestValidatorOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApiKeyRequired() != null) {
                data.set("apiKeyRequired", om.valueToTree(this.getApiKeyRequired()));
            }
            if (this.getAuthorizationScopes() != null) {
                data.set("authorizationScopes", om.valueToTree(this.getAuthorizationScopes()));
            }
            if (this.getAuthorizationType() != null) {
                data.set("authorizationType", om.valueToTree(this.getAuthorizationType()));
            }
            if (this.getAuthorizer() != null) {
                data.set("authorizer", om.valueToTree(this.getAuthorizer()));
            }
            if (this.getMethodResponses() != null) {
                data.set("methodResponses", om.valueToTree(this.getMethodResponses()));
            }
            if (this.getOperationName() != null) {
                data.set("operationName", om.valueToTree(this.getOperationName()));
            }
            if (this.getRequestModels() != null) {
                data.set("requestModels", om.valueToTree(this.getRequestModels()));
            }
            if (this.getRequestParameters() != null) {
                data.set("requestParameters", om.valueToTree(this.getRequestParameters()));
            }
            if (this.getRequestValidator() != null) {
                data.set("requestValidator", om.valueToTree(this.getRequestValidator()));
            }
            if (this.getRequestValidatorOptions() != null) {
                data.set("requestValidatorOptions", om.valueToTree(this.getRequestValidatorOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.MethodOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MethodOptions.Jsii$Proxy that = (MethodOptions.Jsii$Proxy) o;

            if (this.apiKeyRequired != null ? !this.apiKeyRequired.equals(that.apiKeyRequired) : that.apiKeyRequired != null) return false;
            if (this.authorizationScopes != null ? !this.authorizationScopes.equals(that.authorizationScopes) : that.authorizationScopes != null) return false;
            if (this.authorizationType != null ? !this.authorizationType.equals(that.authorizationType) : that.authorizationType != null) return false;
            if (this.authorizer != null ? !this.authorizer.equals(that.authorizer) : that.authorizer != null) return false;
            if (this.methodResponses != null ? !this.methodResponses.equals(that.methodResponses) : that.methodResponses != null) return false;
            if (this.operationName != null ? !this.operationName.equals(that.operationName) : that.operationName != null) return false;
            if (this.requestModels != null ? !this.requestModels.equals(that.requestModels) : that.requestModels != null) return false;
            if (this.requestParameters != null ? !this.requestParameters.equals(that.requestParameters) : that.requestParameters != null) return false;
            if (this.requestValidator != null ? !this.requestValidator.equals(that.requestValidator) : that.requestValidator != null) return false;
            return this.requestValidatorOptions != null ? this.requestValidatorOptions.equals(that.requestValidatorOptions) : that.requestValidatorOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiKeyRequired != null ? this.apiKeyRequired.hashCode() : 0;
            result = 31 * result + (this.authorizationScopes != null ? this.authorizationScopes.hashCode() : 0);
            result = 31 * result + (this.authorizationType != null ? this.authorizationType.hashCode() : 0);
            result = 31 * result + (this.authorizer != null ? this.authorizer.hashCode() : 0);
            result = 31 * result + (this.methodResponses != null ? this.methodResponses.hashCode() : 0);
            result = 31 * result + (this.operationName != null ? this.operationName.hashCode() : 0);
            result = 31 * result + (this.requestModels != null ? this.requestModels.hashCode() : 0);
            result = 31 * result + (this.requestParameters != null ? this.requestParameters.hashCode() : 0);
            result = 31 * result + (this.requestValidator != null ? this.requestValidator.hashCode() : 0);
            result = 31 * result + (this.requestValidatorOptions != null ? this.requestValidatorOptions.hashCode() : 0);
            return result;
        }
    }
}
