package software.amazon.awscdk.services.apigateway;

/**
 * Represents a REST API in Amazon API Gateway.
 * <p>
 * Use <code>addResource</code> and <code>addMethod</code> to configure the API model.
 * <p>
 * By default, the API will automatically be deployed and accessible from a
 * public endpoint.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.26.0 (build 7d76e02)", date = "2021-04-01T03:13:26.311Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.RestApi")
public class RestApi extends software.amazon.awscdk.services.apigateway.RestApiBase {

    protected RestApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RestApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RestApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.RestApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RestApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Import an existing RestApi that can be configured with additional Methods and Resources.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IRestApi fromRestApiAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.RestApiAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.RestApi.class, "fromRestApiAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IRestApi.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Import an existing RestApi.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param restApiId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IRestApi fromRestApiId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String restApiId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.RestApi.class, "fromRestApiId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IRestApi.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(restApiId, "restApiId is required") });
    }

    /**
     * Adds a new model.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.Model addModel(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.ModelOptions props) {
        return software.amazon.jsii.Kernel.call(this, "addModel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.Model.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds a new request validator.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.RequestValidator addRequestValidator(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.RequestValidatorOptions props) {
        return software.amazon.jsii.Kernel.call(this, "addRequestValidator", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.RequestValidator.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Performs validation of the REST API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The list of methods bound to this RestApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.apigateway.Method> getMethods() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "methods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.Method.class))));
    }

    /**
     * The ID of this API Gateway RestApi.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestApiId() {
        return software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The resource ID of the root resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestApiRootResourceId() {
        return software.amazon.jsii.Kernel.get(this, "restApiRootResourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Represents the root resource of this API endpoint ('/').
     * <p>
     * Resources and Methods are added to this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IResource getRoot() {
        return software.amazon.jsii.Kernel.get(this, "root", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IResource.class));
    }

    /**
     * The deployed root URL of this REST API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUrl() {
        return software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.RestApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.RestApi> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.apigateway.RestApiProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Automatically configure an AWS CloudWatch role for API Gateway.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param cloudWatchRole Automatically configure an AWS CloudWatch role for API Gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchRole(final java.lang.Boolean cloudWatchRole) {
            this.props().cloudWatchRole(cloudWatchRole);
            return this;
        }

        /**
         * Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.
         * <p>
         * Since API Gateway deployments are immutable, When this option is enabled
         * (by default), an AWS::ApiGateway::Deployment resource will automatically
         * created with a logical ID that hashes the API model (methods, resources
         * and options). This means that when the model changes, the logical ID of
         * this CloudFormation resource will change, and a new deployment will be
         * created.
         * <p>
         * If this is set, <code>latestDeployment</code> will refer to the <code>Deployment</code> object
         * and <code>deploymentStage</code> will refer to a <code>Stage</code> that points to this
         * deployment. To customize the stage options, use the <code>deployOptions</code>
         * property.
         * <p>
         * A CloudFormation Output will also be defined with the root URL endpoint
         * of this REST API.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param deploy Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploy(final java.lang.Boolean deploy) {
            this.props().deploy(deploy);
            return this;
        }

        /**
         * Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled.
         * <p>
         * If <code>deploy</code> is disabled,
         * this value cannot be set.
         * <p>
         * Default: - Based on defaults of `StageOptions`.
         * <p>
         * @return {@code this}
         * @param deployOptions Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployOptions(final software.amazon.awscdk.services.apigateway.StageOptions deployOptions) {
            this.props().deployOptions(deployOptions);
            return this;
        }

        /**
         * Configure a custom domain name and map it to this API.
         * <p>
         * Default: - no domain name is defined, use `addDomainName` or directly define a `DomainName`.
         * <p>
         * @return {@code this}
         * @param domainName Configure a custom domain name and map it to this API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final software.amazon.awscdk.services.apigateway.DomainNameOptions domainName) {
            this.props().domainName(domainName);
            return this;
        }

        /**
         * Export name for the CfnOutput containing the API endpoint.
         * <p>
         * Default: - when no export name is given, output will be created without export
         * <p>
         * @return {@code this}
         * @param endpointExportName Export name for the CfnOutput containing the API endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointExportName(final java.lang.String endpointExportName) {
            this.props().endpointExportName(endpointExportName);
            return this;
        }

        /**
         * A list of the endpoint types of the API.
         * <p>
         * Use this property when creating
         * an API.
         * <p>
         * Default: EndpointType.EDGE
         * <p>
         * @return {@code this}
         * @param endpointTypes A list of the endpoint types of the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointTypes(final java.util.List<? extends software.amazon.awscdk.services.apigateway.EndpointType> endpointTypes) {
            this.props().endpointTypes(endpointTypes);
            return this;
        }

        /**
         * Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param failOnWarnings Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(final java.lang.Boolean failOnWarnings) {
            this.props().failOnWarnings(failOnWarnings);
            return this;
        }

        /**
         * Custom header parameters for the request.
         * <p>
         * Default: - No parameters.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html
         * @param parameters Custom header parameters for the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props().parameters(parameters);
            return this;
        }

        /**
         * A policy document that contains the permissions for this RestApi.
         * <p>
         * Default: - No policy.
         * <p>
         * @return {@code this}
         * @param policy A policy document that contains the permissions for this RestApi. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(final software.amazon.awscdk.services.iam.PolicyDocument policy) {
            this.props().policy(policy);
            return this;
        }

        /**
         * A name for the API Gateway RestApi resource.
         * <p>
         * Default: - ID of the RestApi construct.
         * <p>
         * @return {@code this}
         * @param restApiName A name for the API Gateway RestApi resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiName(final java.lang.String restApiName) {
            this.props().restApiName(restApiName);
            return this;
        }

        /**
         * Retains old deployment resources when the API changes.
         * <p>
         * This allows
         * manually reverting stages to point to old deployments via the AWS
         * Console.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param retainDeployments Retains old deployment resources when the API changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainDeployments(final java.lang.Boolean retainDeployments) {
            this.props().retainDeployments(retainDeployments);
            return this;
        }

        /**
         * Adds a CORS preflight OPTIONS method to this resource and all child resources.
         * <p>
         * You can add CORS at the resource-level using <code>addCorsPreflight</code>.
         * <p>
         * Default: - CORS is disabled
         * <p>
         * @return {@code this}
         * @param defaultCorsPreflightOptions Adds a CORS preflight OPTIONS method to this resource and all child resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCorsPreflightOptions(final software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions) {
            this.props().defaultCorsPreflightOptions(defaultCorsPreflightOptions);
            return this;
        }

        /**
         * An integration to use as a default for all methods created within this API unless an integration is specified.
         * <p>
         * Default: - Inherited from parent.
         * <p>
         * @return {@code this}
         * @param defaultIntegration An integration to use as a default for all methods created within this API unless an integration is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIntegration(final software.amazon.awscdk.services.apigateway.Integration defaultIntegration) {
            this.props().defaultIntegration(defaultIntegration);
            return this;
        }

        /**
         * Method options to use as a default for all methods created within this API unless custom options are specified.
         * <p>
         * Default: - Inherited from parent.
         * <p>
         * @return {@code this}
         * @param defaultMethodOptions Method options to use as a default for all methods created within this API unless custom options are specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultMethodOptions(final software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            this.props().defaultMethodOptions(defaultMethodOptions);
            return this;
        }

        /**
         * The source of the API key for metering requests according to a usage plan.
         * <p>
         * Default: - Metering is disabled.
         * <p>
         * @return {@code this}
         * @param apiKeySourceType The source of the API key for metering requests according to a usage plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeySourceType(final software.amazon.awscdk.services.apigateway.ApiKeySourceType apiKeySourceType) {
            this.props().apiKeySourceType(apiKeySourceType);
            return this;
        }

        /**
         * The list of binary media mime-types that are supported by the RestApi resource, such as "image/png" or "application/octet-stream".
         * <p>
         * Default: - RestApi supports only UTF-8-encoded text payloads.
         * <p>
         * @return {@code this}
         * @param binaryMediaTypes The list of binary media mime-types that are supported by the RestApi resource, such as "image/png" or "application/octet-stream". This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder binaryMediaTypes(final java.util.List<java.lang.String> binaryMediaTypes) {
            this.props().binaryMediaTypes(binaryMediaTypes);
            return this;
        }

        /**
         * The ID of the API Gateway RestApi resource that you want to clone.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param cloneFrom The ID of the API Gateway RestApi resource that you want to clone. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloneFrom(final software.amazon.awscdk.services.apigateway.IRestApi cloneFrom) {
            this.props().cloneFrom(cloneFrom);
            return this;
        }

        /**
         * A description of the purpose of this API Gateway RestApi resource.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the purpose of this API Gateway RestApi resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * The EndpointConfiguration property type specifies the endpoint types of a REST API.
         * <p>
         * Default: EndpointType.EDGE
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html
         * @param endpointConfiguration The EndpointConfiguration property type specifies the endpoint types of a REST API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfiguration(final software.amazon.awscdk.services.apigateway.EndpointConfiguration endpointConfiguration) {
            this.props().endpointConfiguration(endpointConfiguration);
            return this;
        }

        /**
         * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (when undefined) on an API.
         * <p>
         * When compression is enabled, compression or
         * decompression is not applied on the payload if the payload size is
         * smaller than this value. Setting it to zero allows compression for any
         * payload size.
         * <p>
         * Default: - Compression is disabled.
         * <p>
         * @return {@code this}
         * @param minimumCompressionSize A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (when undefined) on an API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumCompressionSize(final java.lang.Number minimumCompressionSize) {
            this.props().minimumCompressionSize(minimumCompressionSize);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.RestApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.RestApi build() {
            return new software.amazon.awscdk.services.apigateway.RestApi(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigateway.RestApiProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigateway.RestApiProps.Builder();
            }
            return this.props;
        }
    }
}
