package software.amazon.awscdk.services.apigatewayv2.alpha;

/**
 * (experimental) Create a new API mapping for API Gateway API endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.alpha.*;
 * IApi api;
 * DomainName domainName;
 * IStage stage;
 * ApiMapping apiMapping = ApiMapping.Builder.create(this, "MyApiMapping")
 *         .api(api)
 *         .domainName(domainName)
 *         // the properties below are optional
 *         .apiMappingKey("apiMappingKey")
 *         .stage(stage)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-14T20:14:31.193Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigatewayv2.alpha.$Module.class, fqn = "@aws-cdk/aws-apigatewayv2-alpha.ApiMapping")
public class ApiMapping extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.apigatewayv2.alpha.IApiMapping {

    protected ApiMapping(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApiMapping(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ApiMapping(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.ApiMappingProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) import from API ID.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.IApiMapping fromApiMappingAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.ApiMappingAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.alpha.ApiMapping.class, "fromApiMappingAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.IApiMapping.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) ID of the API Mapping.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiMappingId() {
        return software.amazon.jsii.Kernel.get(this, "apiMappingId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) API domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.IDomainName getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.IDomainName.class));
    }

    /**
     * (experimental) API Mapping key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getMappingKey() {
        return software.amazon.jsii.Kernel.get(this, "mappingKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.alpha.ApiMapping}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.alpha.ApiMapping> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigatewayv2.alpha.ApiMappingProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigatewayv2.alpha.ApiMappingProps.Builder();
        }

        /**
         * (experimental) The Api to which this mapping is applied.
         * <p>
         * @return {@code this}
         * @param api The Api to which this mapping is applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder api(final software.amazon.awscdk.services.apigatewayv2.alpha.IApi api) {
            this.props.api(api);
            return this;
        }

        /**
         * (experimental) custom domain name of the mapping target.
         * <p>
         * @return {@code this}
         * @param domainName custom domain name of the mapping target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainName(final software.amazon.awscdk.services.apigatewayv2.alpha.IDomainName domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * (experimental) Api mapping key.
         * <p>
         * The path where this stage should be mapped to on the domain
         * <p>
         * Default: - undefined for the root path mapping.
         * <p>
         * @return {@code this}
         * @param apiMappingKey Api mapping key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder apiMappingKey(final java.lang.String apiMappingKey) {
            this.props.apiMappingKey(apiMappingKey);
            return this;
        }

        /**
         * (experimental) stage for the ApiMapping resource required for WebSocket API defaults to default stage of an HTTP API.
         * <p>
         * Default: - Default stage of the passed API for HTTP API, required for WebSocket API
         * <p>
         * @return {@code this}
         * @param stage stage for the ApiMapping resource required for WebSocket API defaults to default stage of an HTTP API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stage(final software.amazon.awscdk.services.apigatewayv2.alpha.IStage stage) {
            this.props.stage(stage);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.alpha.ApiMapping}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.alpha.ApiMapping build() {
            return new software.amazon.awscdk.services.apigatewayv2.alpha.ApiMapping(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
