package software.amazon.awscdk.services.apigatewayv2.alpha;

/**
 * (experimental) Custom domain resource for the API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.certificatemanager.*;
 * import software.amazon.awscdk.services.apigatewayv2.integrations.alpha.HttpLambdaIntegration;
 * Function handler;
 * String certArn = "arn:aws:acm:us-east-1:111111111111:certificate";
 * String domainName = "example.com";
 * DomainName dn = DomainName.Builder.create(this, "DN")
 *         .domainName(domainName)
 *         .certificate(Certificate.fromCertificateArn(this, "cert", certArn))
 *         .build();
 * HttpApi api = HttpApi.Builder.create(this, "HttpProxyProdApi")
 *         .defaultIntegration(new HttpLambdaIntegration("DefaultIntegration", handler))
 *         // https://${dn.domainName}/foo goes to prodApi $default stage
 *         .defaultDomainMapping(DomainMappingOptions.builder()
 *                 .domainName(dn)
 *                 .mappingKey("foo")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-14T20:14:31.194Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigatewayv2.alpha.$Module.class, fqn = "@aws-cdk/aws-apigatewayv2-alpha.DomainName")
public class DomainName extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.apigatewayv2.alpha.IDomainName {

    protected DomainName(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DomainName(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DomainName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.DomainNameProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import from attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.IDomainName fromDomainNameAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.DomainNameAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.alpha.DomainName.class, "fromDomainNameAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.IDomainName.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) Adds an endpoint to a domain name.
     * <p>
     * @param options domain name endpoint properties to be set. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addEndpoint(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.EndpointOptions options) {
        software.amazon.jsii.Kernel.call(this, "addEndpoint", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) The custom domain name.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The domain name associated with the regional endpoint for this custom domain name.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRegionalDomainName() {
        return software.amazon.jsii.Kernel.get(this, "regionalDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRegionalHostedZoneId() {
        return software.amazon.jsii.Kernel.get(this, "regionalHostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.alpha.DomainName}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.alpha.DomainName> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigatewayv2.alpha.DomainNameProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigatewayv2.alpha.DomainNameProps.Builder();
        }

        /**
         * (experimental) The ACM certificate for this domain name.
         * <p>
         * Certificate can be both ACM issued or imported.
         * <p>
         * @return {@code this}
         * @param certificate The ACM certificate for this domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder certificate(final software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.props.certificate(certificate);
            return this;
        }

        /**
         * (experimental) The user-friendly name of the certificate that will be used by the endpoint for this domain name.
         * <p>
         * Default: - No friendly certificate name
         * <p>
         * @return {@code this}
         * @param certificateName The user-friendly name of the certificate that will be used by the endpoint for this domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder certificateName(final java.lang.String certificateName) {
            this.props.certificateName(certificateName);
            return this;
        }

        /**
         * (experimental) The type of endpoint for this DomainName.
         * <p>
         * Default: EndpointType.REGIONAL
         * <p>
         * @return {@code this}
         * @param endpointType The type of endpoint for this DomainName. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder endpointType(final software.amazon.awscdk.services.apigatewayv2.alpha.EndpointType endpointType) {
            this.props.endpointType(endpointType);
            return this;
        }

        /**
         * (experimental) A public certificate issued by ACM to validate that you own a custom domain.
         * <p>
         * This parameter is required
         * only when you configure mutual TLS authentication and you specify an ACM imported or private CA certificate
         * for <code>certificate</code>. The ownership certificate validates that you have permissions to use the domain name.
         * <p>
         * Default: - only required when configuring mTLS
         * <p>
         * @return {@code this}
         * @param ownershipCertificate A public certificate issued by ACM to validate that you own a custom domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ownershipCertificate(final software.amazon.awscdk.services.certificatemanager.ICertificate ownershipCertificate) {
            this.props.ownershipCertificate(ownershipCertificate);
            return this;
        }

        /**
         * (experimental) The Transport Layer Security (TLS) version + cipher suite for this domain name.
         * <p>
         * Default: SecurityPolicy.TLS_1_2
         * <p>
         * @return {@code this}
         * @param securityPolicy The Transport Layer Security (TLS) version + cipher suite for this domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityPolicy(final software.amazon.awscdk.services.apigatewayv2.alpha.SecurityPolicy securityPolicy) {
            this.props.securityPolicy(securityPolicy);
            return this;
        }

        /**
         * (experimental) The custom domain name.
         * <p>
         * @return {@code this}
         * @param domainName The custom domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * (experimental) The mutual TLS authentication configuration for a custom domain name.
         * <p>
         * Default: - mTLS is not configured.
         * <p>
         * @return {@code this}
         * @param mtls The mutual TLS authentication configuration for a custom domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mtls(final software.amazon.awscdk.services.apigatewayv2.alpha.MTLSConfig mtls) {
            this.props.mtls(mtls);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.alpha.DomainName}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.alpha.DomainName build() {
            return new software.amazon.awscdk.services.apigatewayv2.alpha.DomainName(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
