package software.amazon.awscdk.services.apigatewayv2.alpha;

/**
 * (experimental) Attributes for importing an HttpApi into the CDK.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.alpha.*;
 * HttpApiAttributes httpApiAttributes = HttpApiAttributes.builder()
 *         .httpApiId("httpApiId")
 *         // the properties below are optional
 *         .apiEndpoint("apiEndpoint")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-14T20:14:31.206Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigatewayv2.alpha.$Module.class, fqn = "@aws-cdk/aws-apigatewayv2-alpha.HttpApiAttributes")
@software.amazon.jsii.Jsii.Proxy(HttpApiAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface HttpApiAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The identifier of the HttpApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getHttpApiId();

    /**
     * (experimental) The endpoint URL of the HttpApi.
     * <p>
     * Default: - throws an error if apiEndpoint is accessed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getApiEndpoint() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpApiAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpApiAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<HttpApiAttributes> {
        java.lang.String httpApiId;
        java.lang.String apiEndpoint;

        /**
         * Sets the value of {@link HttpApiAttributes#getHttpApiId}
         * @param httpApiId The identifier of the HttpApi. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder httpApiId(java.lang.String httpApiId) {
            this.httpApiId = httpApiId;
            return this;
        }

        /**
         * Sets the value of {@link HttpApiAttributes#getApiEndpoint}
         * @param apiEndpoint The endpoint URL of the HttpApi.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder apiEndpoint(java.lang.String apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpApiAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public HttpApiAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpApiAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpApiAttributes {
        private final java.lang.String httpApiId;
        private final java.lang.String apiEndpoint;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.httpApiId = software.amazon.jsii.Kernel.get(this, "httpApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.apiEndpoint = software.amazon.jsii.Kernel.get(this, "apiEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.httpApiId = java.util.Objects.requireNonNull(builder.httpApiId, "httpApiId is required");
            this.apiEndpoint = builder.apiEndpoint;
        }

        @Override
        public final java.lang.String getHttpApiId() {
            return this.httpApiId;
        }

        @Override
        public final java.lang.String getApiEndpoint() {
            return this.apiEndpoint;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("httpApiId", om.valueToTree(this.getHttpApiId()));
            if (this.getApiEndpoint() != null) {
                data.set("apiEndpoint", om.valueToTree(this.getApiEndpoint()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigatewayv2-alpha.HttpApiAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpApiAttributes.Jsii$Proxy that = (HttpApiAttributes.Jsii$Proxy) o;

            if (!httpApiId.equals(that.httpApiId)) return false;
            return this.apiEndpoint != null ? this.apiEndpoint.equals(that.apiEndpoint) : that.apiEndpoint == null;
        }

        @Override
        public final int hashCode() {
            int result = this.httpApiId.hashCode();
            result = 31 * result + (this.apiEndpoint != null ? this.apiEndpoint.hashCode() : 0);
            return result;
        }
    }
}
