package software.amazon.awscdk.services.apigatewayv2.alpha;

/**
 * (experimental) An authorizer for Http Apis.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.alpha.*;
 * import software.amazon.awscdk.*;
 * HttpApi httpApi;
 * HttpAuthorizer httpAuthorizer = HttpAuthorizer.Builder.create(this, "MyHttpAuthorizer")
 *         .httpApi(httpApi)
 *         .identitySource(List.of("identitySource"))
 *         .type(HttpAuthorizerType.IAM)
 *         // the properties below are optional
 *         .authorizerName("authorizerName")
 *         .authorizerUri("authorizerUri")
 *         .enableSimpleResponses(false)
 *         .jwtAudience(List.of("jwtAudience"))
 *         .jwtIssuer("jwtIssuer")
 *         .payloadFormatVersion(AuthorizerPayloadVersion.VERSION_1_0)
 *         .resultsCacheTtl(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-14T20:14:31.207Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigatewayv2.alpha.$Module.class, fqn = "@aws-cdk/aws-apigatewayv2-alpha.HttpAuthorizer")
public class HttpAuthorizer extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.apigatewayv2.alpha.IHttpAuthorizer {

    protected HttpAuthorizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpAuthorizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public HttpAuthorizer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.HttpAuthorizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import an existing HTTP Authorizer into this CDK app.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.IHttpRouteAuthorizer fromHttpAuthorizerAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.HttpAuthorizerAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.alpha.HttpAuthorizer.class, "fromHttpAuthorizerAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.IHttpRouteAuthorizer.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) Id of the Authorizer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuthorizerId() {
        return software.amazon.jsii.Kernel.get(this, "authorizerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.alpha.HttpAuthorizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.alpha.HttpAuthorizer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigatewayv2.alpha.HttpAuthorizerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigatewayv2.alpha.HttpAuthorizerProps.Builder();
        }

        /**
         * (experimental) HTTP Api to attach the authorizer to.
         * <p>
         * @return {@code this}
         * @param httpApi HTTP Api to attach the authorizer to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder httpApi(final software.amazon.awscdk.services.apigatewayv2.alpha.IHttpApi httpApi) {
            this.props.httpApi(httpApi);
            return this;
        }

        /**
         * (experimental) The identity source for which authorization is requested.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identitysource">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identitysource</a>
         * @param identitySource The identity source for which authorization is requested. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder identitySource(final java.util.List<java.lang.String> identitySource) {
            this.props.identitySource(identitySource);
            return this;
        }

        /**
         * (experimental) The type of authorizer.
         * <p>
         * @return {@code this}
         * @param type The type of authorizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(final software.amazon.awscdk.services.apigatewayv2.alpha.HttpAuthorizerType type) {
            this.props.type(type);
            return this;
        }

        /**
         * (experimental) Name of the authorizer.
         * <p>
         * Default: - id of the HttpAuthorizer construct.
         * <p>
         * @return {@code this}
         * @param authorizerName Name of the authorizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorizerName(final java.lang.String authorizerName) {
            this.props.authorizerName(authorizerName);
            return this;
        }

        /**
         * (experimental) The authorizer's Uniform Resource Identifier (URI).
         * <p>
         * For REQUEST authorizers, this must be a well-formed Lambda function URI.
         * <p>
         * Default: - required for Request authorizer types
         * <p>
         * @return {@code this}
         * @param authorizerUri The authorizer's Uniform Resource Identifier (URI). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorizerUri(final java.lang.String authorizerUri) {
            this.props.authorizerUri(authorizerUri);
            return this;
        }

        /**
         * (experimental) Specifies whether a Lambda authorizer returns a response in a simple format.
         * <p>
         * If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy.
         * <p>
         * Default: - The lambda authorizer must return an IAM policy as its response
         * <p>
         * @return {@code this}
         * @param enableSimpleResponses Specifies whether a Lambda authorizer returns a response in a simple format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableSimpleResponses(final java.lang.Boolean enableSimpleResponses) {
            this.props.enableSimpleResponses(enableSimpleResponses);
            return this;
        }

        /**
         * (experimental) A list of the intended recipients of the JWT.
         * <p>
         * A valid JWT must provide an aud that matches at least one entry in this list.
         * <p>
         * Default: - required for JWT authorizer typess.
         * <p>
         * @return {@code this}
         * @param jwtAudience A list of the intended recipients of the JWT. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jwtAudience(final java.util.List<java.lang.String> jwtAudience) {
            this.props.jwtAudience(jwtAudience);
            return this;
        }

        /**
         * (experimental) The base domain of the identity provider that issues JWT.
         * <p>
         * Default: - required for JWT authorizer types.
         * <p>
         * @return {@code this}
         * @param jwtIssuer The base domain of the identity provider that issues JWT. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jwtIssuer(final java.lang.String jwtIssuer) {
            this.props.jwtIssuer(jwtIssuer);
            return this;
        }

        /**
         * (experimental) Specifies the format of the payload sent to an HTTP API Lambda authorizer.
         * <p>
         * Default: AuthorizerPayloadVersion.VERSION_2_0 if the authorizer type is HttpAuthorizerType.LAMBDA
         * <p>
         * @return {@code this}
         * @param payloadFormatVersion Specifies the format of the payload sent to an HTTP API Lambda authorizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder payloadFormatVersion(final software.amazon.awscdk.services.apigatewayv2.alpha.AuthorizerPayloadVersion payloadFormatVersion) {
            this.props.payloadFormatVersion(payloadFormatVersion);
            return this;
        }

        /**
         * (experimental) How long APIGateway should cache the results.
         * <p>
         * Max 1 hour.
         * <p>
         * Default: - API Gateway will not cache authorizer responses
         * <p>
         * @return {@code this}
         * @param resultsCacheTtl How long APIGateway should cache the results. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resultsCacheTtl(final software.amazon.awscdk.Duration resultsCacheTtl) {
            this.props.resultsCacheTtl(resultsCacheTtl);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.alpha.HttpAuthorizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.alpha.HttpAuthorizer build() {
            return new software.amazon.awscdk.services.apigatewayv2.alpha.HttpAuthorizer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
