package software.amazon.awscdk.services.apigatewayv2.alpha;

/**
 * (experimental) Supported HTTP methods.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.integrations.alpha.HttpUrlIntegration;
 * import software.amazon.awscdk.services.apigatewayv2.integrations.alpha.HttpLambdaIntegration;
 * Function booksDefaultFn;
 * HttpUrlIntegration getBooksIntegration = new HttpUrlIntegration("GetBooksIntegration", "https://get-books-proxy.myproxy.internal");
 * HttpLambdaIntegration booksDefaultIntegration = new HttpLambdaIntegration("BooksIntegration", booksDefaultFn);
 * HttpApi httpApi = new HttpApi(this, "HttpApi");
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/books")
 *         .methods(List.of(HttpMethod.GET))
 *         .integration(getBooksIntegration)
 *         .build());
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/books")
 *         .methods(List.of(HttpMethod.ANY))
 *         .integration(booksDefaultIntegration)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-14T20:14:31.210Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigatewayv2.alpha.$Module.class, fqn = "@aws-cdk/aws-apigatewayv2-alpha.HttpMethod")
public enum HttpMethod {
    /**
     * (experimental) HTTP ANY.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ANY,
    /**
     * (experimental) HTTP DELETE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DELETE,
    /**
     * (experimental) HTTP GET.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    GET,
    /**
     * (experimental) HTTP HEAD.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    HEAD,
    /**
     * (experimental) HTTP OPTIONS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    OPTIONS,
    /**
     * (experimental) HTTP PATCH.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    PATCH,
    /**
     * (experimental) HTTP POST.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    POST,
    /**
     * (experimental) HTTP PUT.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    PUT,
}
