package software.amazon.awscdk.services.apigatewayv2.alpha;

/**
 * (experimental) Represents the currently available API Key Selection Expressions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * WebSocketApi webSocketApi = WebSocketApi.Builder.create(this, "mywsapi")
 *         .apiKeySelectionExpression(WebSocketApiKeySelectionExpression.HEADER_X_API_KEY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-14T20:14:31.233Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigatewayv2.alpha.$Module.class, fqn = "@aws-cdk/aws-apigatewayv2-alpha.WebSocketApiKeySelectionExpression")
public class WebSocketApiKeySelectionExpression extends software.amazon.jsii.JsiiObject {

    protected WebSocketApiKeySelectionExpression(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WebSocketApiKeySelectionExpression(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AUTHORIZER_USAGE_IDENTIFIER_KEY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketApiKeySelectionExpression.class, "AUTHORIZER_USAGE_IDENTIFIER_KEY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketApiKeySelectionExpression.class));
        HEADER_X_API_KEY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketApiKeySelectionExpression.class, "HEADER_X_API_KEY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketApiKeySelectionExpression.class));
    }

    /**
     * @param customApiKeySelector The expression used by API Gateway. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public WebSocketApiKeySelectionExpression(final @org.jetbrains.annotations.NotNull java.lang.String customApiKeySelector) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(customApiKeySelector, "customApiKeySelector is required") });
    }

    /**
     * (experimental) The API will extract the key value from the `usageIdentifierKey` attribute in the `context` map, returned by the Lambda Authorizer.
     * <p>
     * See https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketApiKeySelectionExpression AUTHORIZER_USAGE_IDENTIFIER_KEY;

    /**
     * (experimental) The API will extract the key value from the `x-api-key` header in the user request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketApiKeySelectionExpression HEADER_X_API_KEY;

    /**
     * (experimental) The expression used by API Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getCustomApiKeySelector() {
        return software.amazon.jsii.Kernel.get(this, "customApiKeySelector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
