package software.amazon.awscdk.services.apigatewayv2.alpha;

/**
 * (experimental) Explicitly configure no authorizers on specific HTTP API routes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpJwtAuthorizer;
 * import software.amazon.awscdk.services.apigatewayv2.integrations.alpha.HttpUrlIntegration;
 * String issuer = "https://test.us.auth0.com";
 * HttpJwtAuthorizer authorizer = HttpJwtAuthorizer.Builder.create("DefaultAuthorizer", issuer)
 *         .jwtAudience(List.of("3131231"))
 *         .build();
 * HttpApi api = HttpApi.Builder.create(this, "HttpApi")
 *         .defaultAuthorizer(authorizer)
 *         .defaultAuthorizationScopes(List.of("read:books"))
 *         .build();
 * api.addRoutes(AddRoutesOptions.builder()
 *         .integration(new HttpUrlIntegration("BooksIntegration", "https://get-books-proxy.example.com"))
 *         .path("/books")
 *         .methods(List.of(HttpMethod.GET))
 *         .build());
 * api.addRoutes(AddRoutesOptions.builder()
 *         .integration(new HttpUrlIntegration("BooksIdIntegration", "https://get-books-proxy.example.com"))
 *         .path("/books/{id}")
 *         .methods(List.of(HttpMethod.GET))
 *         .build());
 * api.addRoutes(AddRoutesOptions.builder()
 *         .integration(new HttpUrlIntegration("BooksIntegration", "https://get-books-proxy.example.com"))
 *         .path("/books")
 *         .methods(List.of(HttpMethod.POST))
 *         .authorizationScopes(List.of("write:books"))
 *         .build());
 * api.addRoutes(AddRoutesOptions.builder()
 *         .integration(new HttpUrlIntegration("LoginIntegration", "https://get-books-proxy.example.com"))
 *         .path("/login")
 *         .methods(List.of(HttpMethod.POST))
 *         .authorizer(new HttpNoneAuthorizer())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-15T19:53:17.395Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigatewayv2.alpha.$Module.class, fqn = "@aws-cdk/aws-apigatewayv2-alpha.HttpNoneAuthorizer")
public class HttpNoneAuthorizer extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigatewayv2.alpha.IHttpRouteAuthorizer {

    protected HttpNoneAuthorizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpNoneAuthorizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public HttpNoneAuthorizer() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Bind this authorizer to a specified Http route.
     * <p>
     * @param _ This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.HttpRouteAuthorizerConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.HttpRouteAuthorizerBindOptions _) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.HttpRouteAuthorizerConfig.class), new Object[] { java.util.Objects.requireNonNull(_, "_ is required") });
    }
}
