package software.amazon.awscdk.services.apigatewayv2.alpha;

/**
 * (experimental) Route class that creates the Route for API Gateway HTTP API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.alpha.*;
 * HttpApi httpApi;
 * IHttpRouteAuthorizer httpRouteAuthorizer;
 * HttpRouteIntegration httpRouteIntegration;
 * HttpRouteKey httpRouteKey;
 * HttpRoute httpRoute = HttpRoute.Builder.create(this, "MyHttpRoute")
 *         .httpApi(httpApi)
 *         .integration(httpRouteIntegration)
 *         .routeKey(httpRouteKey)
 *         // the properties below are optional
 *         .authorizationScopes(List.of("authorizationScopes"))
 *         .authorizer(httpRouteAuthorizer)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-15T19:53:17.396Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigatewayv2.alpha.$Module.class, fqn = "@aws-cdk/aws-apigatewayv2-alpha.HttpRoute")
public class HttpRoute extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.apigatewayv2.alpha.IHttpRoute {

    protected HttpRoute(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpRoute(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public HttpRoute(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.HttpRouteProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Grant access to invoke the route.
     * <p>
     * This method requires that the authorizer of the route is undefined or is
     * an <code>HttpIamAuthorizer</code>.
     * <p>
     * @param grantee This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantInvoke(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.alpha.GrantInvokeOptions options) {
        return software.amazon.jsii.Kernel.call(this, "grantInvoke", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), options });
    }

    /**
     * (experimental) Grant access to invoke the route.
     * <p>
     * This method requires that the authorizer of the route is undefined or is
     * an <code>HttpIamAuthorizer</code>.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantInvoke(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantInvoke", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * (experimental) The HTTP API associated with this route.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.IHttpApi getHttpApi() {
        return software.amazon.jsii.Kernel.get(this, "httpApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.IHttpApi.class));
    }

    /**
     * (experimental) Returns the arn of the route.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRouteArn() {
        return software.amazon.jsii.Kernel.get(this, "routeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Id of the Route.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRouteId() {
        return software.amazon.jsii.Kernel.get(this, "routeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Returns the path component of this HTTP route, `undefined` if the path is the catch-all route.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.alpha.HttpRoute}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.alpha.HttpRoute> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigatewayv2.alpha.HttpRouteProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigatewayv2.alpha.HttpRouteProps.Builder();
        }

        /**
         * (experimental) The integration to be configured on this route.
         * <p>
         * @return {@code this}
         * @param integration The integration to be configured on this route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integration(final software.amazon.awscdk.services.apigatewayv2.alpha.HttpRouteIntegration integration) {
            this.props.integration(integration);
            return this;
        }

        /**
         * (experimental) the API the route is associated with.
         * <p>
         * @return {@code this}
         * @param httpApi the API the route is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder httpApi(final software.amazon.awscdk.services.apigatewayv2.alpha.IHttpApi httpApi) {
            this.props.httpApi(httpApi);
            return this;
        }

        /**
         * (experimental) The key to this route.
         * <p>
         * This is a combination of an HTTP method and an HTTP path.
         * <p>
         * @return {@code this}
         * @param routeKey The key to this route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder routeKey(final software.amazon.awscdk.services.apigatewayv2.alpha.HttpRouteKey routeKey) {
            this.props.routeKey(routeKey);
            return this;
        }

        /**
         * (experimental) The list of OIDC scopes to include in the authorization.
         * <p>
         * These scopes will be merged with the scopes from the attached authorizer
         * <p>
         * Default: - no additional authorization scopes
         * <p>
         * @return {@code this}
         * @param authorizationScopes The list of OIDC scopes to include in the authorization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorizationScopes(final java.util.List<java.lang.String> authorizationScopes) {
            this.props.authorizationScopes(authorizationScopes);
            return this;
        }

        /**
         * (experimental) Authorizer for a WebSocket API or an HTTP API.
         * <p>
         * Default: - No authorizer
         * <p>
         * @return {@code this}
         * @param authorizer Authorizer for a WebSocket API or an HTTP API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorizer(final software.amazon.awscdk.services.apigatewayv2.alpha.IHttpRouteAuthorizer authorizer) {
            this.props.authorizer(authorizer);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.alpha.HttpRoute}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.alpha.HttpRoute build() {
            return new software.amazon.awscdk.services.apigatewayv2.alpha.HttpRoute(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
