package software.amazon.awscdk.services.apigatewayv2.alpha;

/**
 * (experimental) Represents a Mapping Value.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.integrations.alpha.HttpAlbIntegration;
 * ApplicationLoadBalancer lb;
 * ApplicationListener listener = lb.addListener("listener", BaseApplicationListenerProps.builder().port(80).build());
 * listener.addTargets("target", AddApplicationTargetsProps.builder()
 *         .port(80)
 *         .build());
 * HttpApi httpEndpoint = HttpApi.Builder.create(this, "HttpProxyPrivateApi")
 *         .defaultIntegration(HttpAlbIntegration.Builder.create("DefaultIntegration", listener)
 *                 .parameterMapping(new ParameterMapping().appendHeader("header2", MappingValue.requestHeader("header1")).removeHeader("header1"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-15T19:53:17.424Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigatewayv2.alpha.$Module.class, fqn = "@aws-cdk/aws-apigatewayv2-alpha.MappingValue")
public class MappingValue extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigatewayv2.alpha.IMappingValue {

    protected MappingValue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MappingValue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        NONE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue.class, "NONE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue.class));
    }

    /**
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected MappingValue(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Creates a context variable mapping value.
     * <p>
     * @param variableName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue contextVariable(final @org.jetbrains.annotations.NotNull java.lang.String variableName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue.class, "contextVariable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue.class), new Object[] { java.util.Objects.requireNonNull(variableName, "variableName is required") });
    }

    /**
     * (experimental) Creates a custom mapping value.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue custom(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Creates a request body mapping value.
     * <p>
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue requestBody(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue.class, "requestBody", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) Creates a header mapping value.
     * <p>
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue requestHeader(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue.class, "requestHeader", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) Creates a request path mapping value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue requestPath() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue.class, "requestPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue.class));
    }

    /**
     * (experimental) Creates a request path parameter mapping value.
     * <p>
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue requestPathParam(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue.class, "requestPathParam", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) Creates a query string mapping value.
     * <p>
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue requestQueryString(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue.class, "requestQueryString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) Creates a stage variable mapping value.
     * <p>
     * @param variableName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue stageVariable(final @org.jetbrains.annotations.NotNull java.lang.String variableName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue.class, "stageVariable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue.class), new Object[] { java.util.Objects.requireNonNull(variableName, "variableName is required") });
    }

    /**
     * (experimental) Creates an empty mapping value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.apigatewayv2.alpha.MappingValue NONE;

    /**
     * (experimental) Represents a Mapping Value.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
