package software.amazon.awscdk.services.apigatewayv2.alpha;

/**
 * (experimental) Options required to create a new stage.
 * <p>
 * Options that are common between HTTP and Websocket APIs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.alpha.*;
 * DomainName domainName;
 * StageOptions stageOptions = StageOptions.builder()
 *         .autoDeploy(false)
 *         .domainMapping(DomainMappingOptions.builder()
 *                 .domainName(domainName)
 *                 // the properties below are optional
 *                 .mappingKey("mappingKey")
 *                 .build())
 *         .throttle(ThrottleSettings.builder()
 *                 .burstLimit(123)
 *                 .rateLimit(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-15T19:53:17.425Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigatewayv2.alpha.$Module.class, fqn = "@aws-cdk/aws-apigatewayv2-alpha.StageOptions")
@software.amazon.jsii.Jsii.Proxy(StageOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface StageOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Whether updates to an API automatically trigger a new deployment.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAutoDeploy() {
        return null;
    }

    /**
     * (experimental) The options for custom domain and api mapping.
     * <p>
     * Default: - no custom domain and api mapping configuration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.alpha.DomainMappingOptions getDomainMapping() {
        return null;
    }

    /**
     * (experimental) Throttle settings for the routes of this stage.
     * <p>
     * Default: - no throttling configuration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.alpha.ThrottleSettings getThrottle() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<StageOptions> {
        java.lang.Boolean autoDeploy;
        software.amazon.awscdk.services.apigatewayv2.alpha.DomainMappingOptions domainMapping;
        software.amazon.awscdk.services.apigatewayv2.alpha.ThrottleSettings throttle;

        /**
         * Sets the value of {@link StageOptions#getAutoDeploy}
         * @param autoDeploy Whether updates to an API automatically trigger a new deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoDeploy(java.lang.Boolean autoDeploy) {
            this.autoDeploy = autoDeploy;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getDomainMapping}
         * @param domainMapping The options for custom domain and api mapping.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainMapping(software.amazon.awscdk.services.apigatewayv2.alpha.DomainMappingOptions domainMapping) {
            this.domainMapping = domainMapping;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getThrottle}
         * @param throttle Throttle settings for the routes of this stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder throttle(software.amazon.awscdk.services.apigatewayv2.alpha.ThrottleSettings throttle) {
            this.throttle = throttle;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StageOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public StageOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StageOptions {
        private final java.lang.Boolean autoDeploy;
        private final software.amazon.awscdk.services.apigatewayv2.alpha.DomainMappingOptions domainMapping;
        private final software.amazon.awscdk.services.apigatewayv2.alpha.ThrottleSettings throttle;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoDeploy = software.amazon.jsii.Kernel.get(this, "autoDeploy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.domainMapping = software.amazon.jsii.Kernel.get(this, "domainMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.DomainMappingOptions.class));
            this.throttle = software.amazon.jsii.Kernel.get(this, "throttle", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.ThrottleSettings.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoDeploy = builder.autoDeploy;
            this.domainMapping = builder.domainMapping;
            this.throttle = builder.throttle;
        }

        @Override
        public final java.lang.Boolean getAutoDeploy() {
            return this.autoDeploy;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.alpha.DomainMappingOptions getDomainMapping() {
            return this.domainMapping;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.alpha.ThrottleSettings getThrottle() {
            return this.throttle;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAutoDeploy() != null) {
                data.set("autoDeploy", om.valueToTree(this.getAutoDeploy()));
            }
            if (this.getDomainMapping() != null) {
                data.set("domainMapping", om.valueToTree(this.getDomainMapping()));
            }
            if (this.getThrottle() != null) {
                data.set("throttle", om.valueToTree(this.getThrottle()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigatewayv2-alpha.StageOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StageOptions.Jsii$Proxy that = (StageOptions.Jsii$Proxy) o;

            if (this.autoDeploy != null ? !this.autoDeploy.equals(that.autoDeploy) : that.autoDeploy != null) return false;
            if (this.domainMapping != null ? !this.domainMapping.equals(that.domainMapping) : that.domainMapping != null) return false;
            return this.throttle != null ? this.throttle.equals(that.throttle) : that.throttle == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoDeploy != null ? this.autoDeploy.hashCode() : 0;
            result = 31 * result + (this.domainMapping != null ? this.domainMapping.hashCode() : 0);
            result = 31 * result + (this.throttle != null ? this.throttle.hashCode() : 0);
            return result;
        }
    }
}
