package software.amazon.awscdk.services.apigatewayv2.alpha;

/**
 * (experimental) Create a new API Gateway WebSocket API endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.integrations.alpha.WebSocketLambdaIntegration;
 * Function messageHandler;
 * WebSocketApi webSocketApi = new WebSocketApi(this, "mywsapi");
 * WebSocketStage.Builder.create(this, "mystage")
 *         .webSocketApi(webSocketApi)
 *         .stageName("dev")
 *         .autoDeploy(true)
 *         .build();
 * webSocketApi.addRoute("sendmessage", WebSocketRouteOptions.builder()
 *         .integration(new WebSocketLambdaIntegration("SendMessageIntegration", messageHandler))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-15T19:53:17.426Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigatewayv2.alpha.$Module.class, fqn = "@aws-cdk/aws-apigatewayv2-alpha.WebSocketApi")
public class WebSocketApi extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.apigatewayv2.alpha.IWebSocketApi, software.amazon.awscdk.services.apigatewayv2.alpha.IApi {

    protected WebSocketApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WebSocketApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public WebSocketApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public WebSocketApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Import an existing WebSocket API into this CDK app.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.IWebSocketApi fromWebSocketApiAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketApiAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketApi.class, "fromWebSocketApiAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.IWebSocketApi.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) Add a new route.
     * <p>
     * @param routeKey This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketRoute addRoute(final @org.jetbrains.annotations.NotNull java.lang.String routeKey, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketRouteOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addRoute", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketRoute.class), new Object[] { java.util.Objects.requireNonNull(routeKey, "routeKey is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Grant access to the API Gateway management API for this WebSocket API to an IAM principal (Role/Group/User).
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantManageConnections(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "grantManageConnections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * (experimental) Return the given named metric for this Api Gateway.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * (experimental) Return the given named metric for this Api Gateway.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * (experimental) The default endpoint for an API.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "apiEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The identifier of this API Gateway API.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiId() {
        return software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A human friendly name for this WebSocket API.
     * <p>
     * Note that this is different from <code>webSocketApiId</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getWebSocketApiName() {
        return software.amazon.jsii.Kernel.get(this, "webSocketApiName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketApi> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketApiProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) An API key selection expression.
         * <p>
         * Providing this option will require an API Key be provided to access the API.
         * <p>
         * Default: - Key is not required to access these APIs
         * <p>
         * @return {@code this}
         * @param apiKeySelectionExpression An API key selection expression. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder apiKeySelectionExpression(final software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketApiKeySelectionExpression apiKeySelectionExpression) {
            this.props().apiKeySelectionExpression(apiKeySelectionExpression);
            return this;
        }

        /**
         * (experimental) Name for the WebSocket API resource.
         * <p>
         * Default: - id of the WebSocketApi construct.
         * <p>
         * @return {@code this}
         * @param apiName Name for the WebSocket API resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder apiName(final java.lang.String apiName) {
            this.props().apiName(apiName);
            return this;
        }

        /**
         * (experimental) Options to configure a '$connect' route.
         * <p>
         * Default: - no '$connect' route configured
         * <p>
         * @return {@code this}
         * @param connectRouteOptions Options to configure a '$connect' route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connectRouteOptions(final software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketRouteOptions connectRouteOptions) {
            this.props().connectRouteOptions(connectRouteOptions);
            return this;
        }

        /**
         * (experimental) Options to configure a '$default' route.
         * <p>
         * Default: - no '$default' route configured
         * <p>
         * @return {@code this}
         * @param defaultRouteOptions Options to configure a '$default' route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultRouteOptions(final software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketRouteOptions defaultRouteOptions) {
            this.props().defaultRouteOptions(defaultRouteOptions);
            return this;
        }

        /**
         * (experimental) The description of the API.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param description The description of the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * (experimental) Options to configure a '$disconnect' route.
         * <p>
         * Default: - no '$disconnect' route configured
         * <p>
         * @return {@code this}
         * @param disconnectRouteOptions Options to configure a '$disconnect' route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder disconnectRouteOptions(final software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketRouteOptions disconnectRouteOptions) {
            this.props().disconnectRouteOptions(disconnectRouteOptions);
            return this;
        }

        /**
         * (experimental) The route selection expression for the API.
         * <p>
         * Default: '$request.body.action'
         * <p>
         * @return {@code this}
         * @param routeSelectionExpression The route selection expression for the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder routeSelectionExpression(final java.lang.String routeSelectionExpression) {
            this.props().routeSelectionExpression(routeSelectionExpression);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketApi build() {
            return new software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketApi(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketApiProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketApiProps.Builder();
            }
            return this.props;
        }
    }
}
