package software.amazon.awscdk.services.apigatewayv2.alpha;

/**
 * (experimental) Properties to initialize a new Route.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.alpha.*;
 * WebSocketApi webSocketApi;
 * IWebSocketRouteAuthorizer webSocketRouteAuthorizer;
 * WebSocketRouteIntegration webSocketRouteIntegration;
 * WebSocketRouteProps webSocketRouteProps = WebSocketRouteProps.builder()
 *         .integration(webSocketRouteIntegration)
 *         .routeKey("routeKey")
 *         .webSocketApi(webSocketApi)
 *         // the properties below are optional
 *         .apiKeyRequired(false)
 *         .authorizer(webSocketRouteAuthorizer)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-15T19:53:17.431Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigatewayv2.alpha.$Module.class, fqn = "@aws-cdk/aws-apigatewayv2-alpha.WebSocketRouteProps")
@software.amazon.jsii.Jsii.Proxy(WebSocketRouteProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface WebSocketRouteProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketRouteOptions {

    /**
     * (experimental) The key to this route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getRouteKey();

    /**
     * (experimental) The API the route is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.IWebSocketApi getWebSocketApi();

    /**
     * (experimental) Whether the route requires an API Key to be provided.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getApiKeyRequired() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link WebSocketRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WebSocketRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<WebSocketRouteProps> {
        java.lang.String routeKey;
        software.amazon.awscdk.services.apigatewayv2.alpha.IWebSocketApi webSocketApi;
        java.lang.Boolean apiKeyRequired;
        software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketRouteIntegration integration;
        software.amazon.awscdk.services.apigatewayv2.alpha.IWebSocketRouteAuthorizer authorizer;

        /**
         * Sets the value of {@link WebSocketRouteProps#getRouteKey}
         * @param routeKey The key to this route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder routeKey(java.lang.String routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteProps#getWebSocketApi}
         * @param webSocketApi The API the route is associated with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder webSocketApi(software.amazon.awscdk.services.apigatewayv2.alpha.IWebSocketApi webSocketApi) {
            this.webSocketApi = webSocketApi;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteProps#getApiKeyRequired}
         * @param apiKeyRequired Whether the route requires an API Key to be provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder apiKeyRequired(java.lang.Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteProps#getIntegration}
         * @param integration The integration to be configured on this route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integration(software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketRouteIntegration integration) {
            this.integration = integration;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteProps#getAuthorizer}
         * @param authorizer The authorize to this route.
         *                   You can only set authorizer to a $connect route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorizer(software.amazon.awscdk.services.apigatewayv2.alpha.IWebSocketRouteAuthorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WebSocketRouteProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public WebSocketRouteProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WebSocketRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebSocketRouteProps {
        private final java.lang.String routeKey;
        private final software.amazon.awscdk.services.apigatewayv2.alpha.IWebSocketApi webSocketApi;
        private final java.lang.Boolean apiKeyRequired;
        private final software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketRouteIntegration integration;
        private final software.amazon.awscdk.services.apigatewayv2.alpha.IWebSocketRouteAuthorizer authorizer;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.routeKey = software.amazon.jsii.Kernel.get(this, "routeKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.webSocketApi = software.amazon.jsii.Kernel.get(this, "webSocketApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.IWebSocketApi.class));
            this.apiKeyRequired = software.amazon.jsii.Kernel.get(this, "apiKeyRequired", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.integration = software.amazon.jsii.Kernel.get(this, "integration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketRouteIntegration.class));
            this.authorizer = software.amazon.jsii.Kernel.get(this, "authorizer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.IWebSocketRouteAuthorizer.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.routeKey = java.util.Objects.requireNonNull(builder.routeKey, "routeKey is required");
            this.webSocketApi = java.util.Objects.requireNonNull(builder.webSocketApi, "webSocketApi is required");
            this.apiKeyRequired = builder.apiKeyRequired;
            this.integration = java.util.Objects.requireNonNull(builder.integration, "integration is required");
            this.authorizer = builder.authorizer;
        }

        @Override
        public final java.lang.String getRouteKey() {
            return this.routeKey;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.alpha.IWebSocketApi getWebSocketApi() {
            return this.webSocketApi;
        }

        @Override
        public final java.lang.Boolean getApiKeyRequired() {
            return this.apiKeyRequired;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketRouteIntegration getIntegration() {
            return this.integration;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.alpha.IWebSocketRouteAuthorizer getAuthorizer() {
            return this.authorizer;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("routeKey", om.valueToTree(this.getRouteKey()));
            data.set("webSocketApi", om.valueToTree(this.getWebSocketApi()));
            if (this.getApiKeyRequired() != null) {
                data.set("apiKeyRequired", om.valueToTree(this.getApiKeyRequired()));
            }
            data.set("integration", om.valueToTree(this.getIntegration()));
            if (this.getAuthorizer() != null) {
                data.set("authorizer", om.valueToTree(this.getAuthorizer()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigatewayv2-alpha.WebSocketRouteProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WebSocketRouteProps.Jsii$Proxy that = (WebSocketRouteProps.Jsii$Proxy) o;

            if (!routeKey.equals(that.routeKey)) return false;
            if (!webSocketApi.equals(that.webSocketApi)) return false;
            if (this.apiKeyRequired != null ? !this.apiKeyRequired.equals(that.apiKeyRequired) : that.apiKeyRequired != null) return false;
            if (!integration.equals(that.integration)) return false;
            return this.authorizer != null ? this.authorizer.equals(that.authorizer) : that.authorizer == null;
        }

        @Override
        public final int hashCode() {
            int result = this.routeKey.hashCode();
            result = 31 * result + (this.webSocketApi.hashCode());
            result = 31 * result + (this.apiKeyRequired != null ? this.apiKeyRequired.hashCode() : 0);
            result = 31 * result + (this.integration.hashCode());
            result = 31 * result + (this.authorizer != null ? this.authorizer.hashCode() : 0);
            return result;
        }
    }
}
