/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigatewayv2.alpha;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.apigatewayv2.alpha.$Module;
import software.amazon.awscdk.services.apigatewayv2.alpha.AuthorizerPayloadVersion;
import software.amazon.awscdk.services.apigatewayv2.alpha.HttpAuthorizerAttributes;
import software.amazon.awscdk.services.apigatewayv2.alpha.HttpAuthorizerProps;
import software.amazon.awscdk.services.apigatewayv2.alpha.HttpAuthorizerType;
import software.amazon.awscdk.services.apigatewayv2.alpha.IHttpApi;
import software.amazon.awscdk.services.apigatewayv2.alpha.IHttpAuthorizer;
import software.amazon.awscdk.services.apigatewayv2.alpha.IHttpRouteAuthorizer;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-apigatewayv2-alpha.HttpAuthorizer")
public class HttpAuthorizer
extends Resource
implements IHttpAuthorizer {
    protected HttpAuthorizer(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpAuthorizer(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public HttpAuthorizer(@NotNull Construct scope, @NotNull String id, @NotNull HttpAuthorizerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IHttpRouteAuthorizer fromHttpAuthorizerAttributes(@NotNull Construct scope, @NotNull String id, @NotNull HttpAuthorizerAttributes attrs) {
        return (IHttpRouteAuthorizer)JsiiObject.jsiiStaticCall(HttpAuthorizer.class, (String)"fromHttpAuthorizerAttributes", (NativeType)NativeType.forClass(IHttpRouteAuthorizer.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public String getAuthorizerId() {
        return (String)Kernel.get((Object)this, (String)"authorizerId", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<HttpAuthorizer> {
        private final Construct scope;
        private final String id;
        private final HttpAuthorizerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new HttpAuthorizerProps.Builder();
        }

        public Builder httpApi(IHttpApi httpApi) {
            this.props.httpApi(httpApi);
            return this;
        }

        public Builder identitySource(List<String> identitySource) {
            this.props.identitySource(identitySource);
            return this;
        }

        public Builder type(HttpAuthorizerType type) {
            this.props.type(type);
            return this;
        }

        public Builder authorizerName(String authorizerName) {
            this.props.authorizerName(authorizerName);
            return this;
        }

        public Builder authorizerUri(String authorizerUri) {
            this.props.authorizerUri(authorizerUri);
            return this;
        }

        public Builder enableSimpleResponses(Boolean enableSimpleResponses) {
            this.props.enableSimpleResponses(enableSimpleResponses);
            return this;
        }

        public Builder jwtAudience(List<String> jwtAudience) {
            this.props.jwtAudience(jwtAudience);
            return this;
        }

        public Builder jwtIssuer(String jwtIssuer) {
            this.props.jwtIssuer(jwtIssuer);
            return this;
        }

        public Builder payloadFormatVersion(AuthorizerPayloadVersion payloadFormatVersion) {
            this.props.payloadFormatVersion(payloadFormatVersion);
            return this;
        }

        public Builder resultsCacheTtl(Duration resultsCacheTtl) {
            this.props.resultsCacheTtl(resultsCacheTtl);
            return this;
        }

        public HttpAuthorizer build() {
            return new HttpAuthorizer(this.scope, this.id, this.props.build());
        }
    }
}

