/**
 * <h1>AWS APIGatewayv2 Integrations</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="End-of-Support" src="https://img.shields.io/badge/End--of--Support-critical.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * AWS CDK v1 has reached End-of-Support on 2023-06-01.
 * This package is no longer being updated, and users should migrate to AWS CDK v2.
 * <p>
 * For more information on how to migrate, see the <a href="https://docs.aws.amazon.com/cdk/v2/guide/migrating-v2.html"><em>Migrating to AWS CDK v2</em> guide</a>.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * <h2>Table of Contents</h2>
 * <p>
 * <ul>
 * <li><a href="#http-apis">HTTP APIs</a>
 * <p>
 * <ul>
 * <li><a href="#lambda">Lambda Integration</a></li>
 * <li><a href="#http-proxy">HTTP Proxy Integration</a></li>
 * <li><a href="#private-integration">Private Integration</a></li>
 * <li><a href="#request-parameters">Request Parameters</a></li>
 * </ul></li>
 * <li><a href="#websocket-apis">WebSocket APIs</a>
 * <p>
 * <ul>
 * <li><a href="#lambda-websocket-integration">Lambda WebSocket Integration</a></li>
 * </ul></li>
 * </ul>
 * <p>
 * <h2>HTTP APIs</h2>
 * <p>
 * Integrations connect a route to backend resources. HTTP APIs support Lambda proxy, AWS service, and HTTP proxy integrations. HTTP proxy integrations are also known as private integrations.
 * <p>
 * <h3>Lambda</h3>
 * <p>
 * Lambda integrations enable integrating an HTTP API route with a Lambda function. When a client invokes the route, the
 * API Gateway service forwards the request to the Lambda function and returns the function's response to the client.
 * <p>
 * The API Gateway service will invoke the lambda function with an event payload of a specific format. The service expects
 * the function to respond in a specific format. The details on this format is available at <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html">Working with AWS Lambda
 * proxy integrations</a>.
 * <p>
 * The following code configures a route <code>GET /books</code> with a Lambda proxy integration.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.integrations.HttpLambdaIntegration;
 * 
 * Function booksDefaultFn;
 * 
 * HttpLambdaIntegration booksIntegration = new HttpLambdaIntegration("BooksIntegration", booksDefaultFn);
 * 
 * HttpApi httpApi = new HttpApi(this, "HttpApi");
 * 
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/books")
 *         .methods(List.of(HttpMethod.GET))
 *         .integration(booksIntegration)
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h3>HTTP Proxy</h3>
 * <p>
 * HTTP Proxy integrations enables connecting an HTTP API route to a publicly routable HTTP endpoint. When a client
 * invokes the route, the API Gateway service forwards the entire request and response between the API Gateway endpoint
 * and the integrating HTTP endpoint. More information can be found at <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-http.html">Working with HTTP proxy
 * integrations</a>.
 * <p>
 * The following code configures a route <code>GET /books</code> with an HTTP proxy integration to an HTTP endpoint
 * <code>get-books-proxy.myproxy.internal</code>.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.integrations.HttpUrlIntegration;
 * 
 * 
 * HttpUrlIntegration booksIntegration = new HttpUrlIntegration("BooksIntegration", "https://get-books-proxy.myproxy.internal");
 * 
 * HttpApi httpApi = new HttpApi(this, "HttpApi");
 * 
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/books")
 *         .methods(List.of(HttpMethod.GET))
 *         .integration(booksIntegration)
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h3>Private Integration</h3>
 * <p>
 * Private integrations enable integrating an HTTP API route with private resources in a VPC, such as Application Load Balancers or
 * Amazon ECS container-based applications.  Using private integrations, resources in a VPC can be exposed for access by
 * clients outside of the VPC.
 * <p>
 * The following integrations are supported for private resources in a VPC.
 * <p>
 * <h4>Application Load Balancer</h4>
 * <p>
 * The following code is a basic application load balancer private integration of HTTP API:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.integrations.HttpAlbIntegration;
 * 
 * 
 * Vpc vpc = new Vpc(this, "VPC");
 * ApplicationLoadBalancer lb = ApplicationLoadBalancer.Builder.create(this, "lb").vpc(vpc).build();
 * ApplicationListener listener = lb.addListener("listener", BaseApplicationListenerProps.builder().port(80).build());
 * listener.addTargets("target", AddApplicationTargetsProps.builder()
 *         .port(80)
 *         .build());
 * 
 * HttpApi httpEndpoint = HttpApi.Builder.create(this, "HttpProxyPrivateApi")
 *         .defaultIntegration(new HttpAlbIntegration("DefaultIntegration", listener))
 *         .build();
 * </pre></blockquote>
 * <p>
 * When an imported load balancer is used, the <code>vpc</code> option must be specified for <code>HttpAlbIntegration</code>.
 * <p>
 * <h4>Network Load Balancer</h4>
 * <p>
 * The following code is a basic network load balancer private integration of HTTP API:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.integrations.HttpNlbIntegration;
 * 
 * 
 * Vpc vpc = new Vpc(this, "VPC");
 * NetworkLoadBalancer lb = NetworkLoadBalancer.Builder.create(this, "lb").vpc(vpc).build();
 * NetworkListener listener = lb.addListener("listener", BaseNetworkListenerProps.builder().port(80).build());
 * listener.addTargets("target", AddNetworkTargetsProps.builder()
 *         .port(80)
 *         .build());
 * 
 * HttpApi httpEndpoint = HttpApi.Builder.create(this, "HttpProxyPrivateApi")
 *         .defaultIntegration(new HttpNlbIntegration("DefaultIntegration", listener))
 *         .build();
 * </pre></blockquote>
 * <p>
 * When an imported load balancer is used, the <code>vpc</code> option must be specified for <code>HttpNlbIntegration</code>.
 * <p>
 * <h4>Cloud Map Service Discovery</h4>
 * <p>
 * The following code is a basic discovery service private integration of HTTP API:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.servicediscovery.*;
 * import software.amazon.awscdk.services.apigatewayv2.integrations.HttpServiceDiscoveryIntegration;
 * 
 * 
 * Vpc vpc = new Vpc(this, "VPC");
 * VpcLink vpcLink = VpcLink.Builder.create(this, "VpcLink").vpc(vpc).build();
 * PrivateDnsNamespace namespace = PrivateDnsNamespace.Builder.create(this, "Namespace")
 *         .name("boobar.com")
 *         .vpc(vpc)
 *         .build();
 * Service service = namespace.createService("Service");
 * 
 * HttpApi httpEndpoint = HttpApi.Builder.create(this, "HttpProxyPrivateApi")
 *         .defaultIntegration(HttpServiceDiscoveryIntegration.Builder.create("DefaultIntegration", service)
 *                 .vpcLink(vpcLink)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Request Parameters</h3>
 * <p>
 * Request parameter mapping allows API requests from clients to be modified before they reach backend integrations.
 * Parameter mapping can be used to specify modifications to request parameters. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and
 * responses</a>.
 * <p>
 * The following example creates a new header - <code>header2</code> - as a copy of <code>header1</code> and removes <code>header1</code>.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.integrations.HttpAlbIntegration;
 * 
 * ApplicationLoadBalancer lb;
 * 
 * ApplicationListener listener = lb.addListener("listener", BaseApplicationListenerProps.builder().port(80).build());
 * listener.addTargets("target", AddApplicationTargetsProps.builder()
 *         .port(80)
 *         .build());
 * 
 * HttpApi httpEndpoint = HttpApi.Builder.create(this, "HttpProxyPrivateApi")
 *         .defaultIntegration(HttpAlbIntegration.Builder.create("DefaultIntegration", listener)
 *                 .parameterMapping(new ParameterMapping().appendHeader("header2", MappingValue.requestHeader("header1")).removeHeader("header1"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * To add mapping keys and values not yet supported by the CDK, use the <code>custom()</code> method:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.integrations.HttpAlbIntegration;
 * 
 * ApplicationLoadBalancer lb;
 * 
 * ApplicationListener listener = lb.addListener("listener", BaseApplicationListenerProps.builder().port(80).build());
 * listener.addTargets("target", AddApplicationTargetsProps.builder()
 *         .port(80)
 *         .build());
 * 
 * HttpApi httpEndpoint = HttpApi.Builder.create(this, "HttpProxyPrivateApi")
 *         .defaultIntegration(HttpAlbIntegration.Builder.create("DefaultIntegration", listener)
 *                 .parameterMapping(new ParameterMapping().custom("myKey", "myValue"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>WebSocket APIs</h2>
 * <p>
 * WebSocket integrations connect a route to backend resources. The following integrations are supported in the CDK.
 * <p>
 * <h3>Lambda WebSocket Integration</h3>
 * <p>
 * Lambda integrations enable integrating a WebSocket API route with a Lambda function. When a client connects/disconnects
 * or sends message specific to a route, the API Gateway service forwards the request to the Lambda function
 * <p>
 * The API Gateway service will invoke the lambda function with an event payload of a specific format.
 * <p>
 * The following code configures a <code>sendmessage</code> route with a Lambda integration
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.integrations.WebSocketLambdaIntegration;
 * 
 * Function messageHandler;
 * 
 * 
 * WebSocketApi webSocketApi = new WebSocketApi(this, "mywsapi");
 * WebSocketStage.Builder.create(this, "mystage")
 *         .webSocketApi(webSocketApi)
 *         .stageName("dev")
 *         .autoDeploy(true)
 *         .build();
 * webSocketApi.addRoute("sendmessage", WebSocketRouteOptions.builder()
 *         .integration(new WebSocketLambdaIntegration("SendMessageIntegration", messageHandler))
 *         .build());
 * </pre></blockquote>
 *
 * Deprecated: AWS CDK v1 has reached End-of-Support on 2023-06-01.
This package is no longer being updated, and users should migrate to AWS CDK v2.

For more information on how to migrate, see https://docs.aws.amazon.com/cdk/v2/guide/migrating-v2.html
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@Deprecated
package software.amazon.awscdk.services.apigatewayv2.integrations;
