/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.applicationautoscaling;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.applicationautoscaling.EnableScalingProps;
import software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface BaseScalableAttributeProps
extends JsiiSerializable,
EnableScalingProps {
    public String getDimension();

    public String getResourceId();

    public IRole getRole();

    public ServiceNamespace getServiceNamespace();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _dimension;
        private String _resourceId;
        private IRole _role;
        private ServiceNamespace _serviceNamespace;
        private Number _maxCapacity;
        @Nullable
        private Number _minCapacity;

        public Builder withDimension(String value) {
            this._dimension = Objects.requireNonNull(value, "dimension is required");
            return this;
        }

        public Builder withResourceId(String value) {
            this._resourceId = Objects.requireNonNull(value, "resourceId is required");
            return this;
        }

        public Builder withRole(IRole value) {
            this._role = Objects.requireNonNull(value, "role is required");
            return this;
        }

        public Builder withServiceNamespace(ServiceNamespace value) {
            this._serviceNamespace = Objects.requireNonNull(value, "serviceNamespace is required");
            return this;
        }

        public Builder withMaxCapacity(Number value) {
            this._maxCapacity = Objects.requireNonNull(value, "maxCapacity is required");
            return this;
        }

        public Builder withMinCapacity(@Nullable Number value) {
            this._minCapacity = value;
            return this;
        }

        public BaseScalableAttributeProps build() {
            return new BaseScalableAttributeProps(){
                private final String $dimension;
                private final String $resourceId;
                private final IRole $role;
                private final ServiceNamespace $serviceNamespace;
                private final Number $maxCapacity;
                @Nullable
                private final Number $minCapacity;
                {
                    this.$dimension = Objects.requireNonNull(_dimension, "dimension is required");
                    this.$resourceId = Objects.requireNonNull(_resourceId, "resourceId is required");
                    this.$role = Objects.requireNonNull(_role, "role is required");
                    this.$serviceNamespace = Objects.requireNonNull(_serviceNamespace, "serviceNamespace is required");
                    this.$maxCapacity = Objects.requireNonNull(_maxCapacity, "maxCapacity is required");
                    this.$minCapacity = _minCapacity;
                }

                @Override
                public String getDimension() {
                    return this.$dimension;
                }

                @Override
                public String getResourceId() {
                    return this.$resourceId;
                }

                @Override
                public IRole getRole() {
                    return this.$role;
                }

                @Override
                public ServiceNamespace getServiceNamespace() {
                    return this.$serviceNamespace;
                }

                @Override
                public Number getMaxCapacity() {
                    return this.$maxCapacity;
                }

                @Override
                public Number getMinCapacity() {
                    return this.$minCapacity;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("dimension", om.valueToTree((Object)this.getDimension()));
                    obj.set("resourceId", om.valueToTree((Object)this.getResourceId()));
                    obj.set("role", om.valueToTree((Object)this.getRole()));
                    obj.set("serviceNamespace", om.valueToTree((Object)this.getServiceNamespace()));
                    obj.set("maxCapacity", om.valueToTree((Object)this.getMaxCapacity()));
                    if (this.getMinCapacity() != null) {
                        obj.set("minCapacity", om.valueToTree((Object)this.getMinCapacity()));
                    }
                    return obj;
                }
            };
        }
    }
}

