/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.applicationautoscaling;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.applicationautoscaling.AdjustmentType;
import software.amazon.awscdk.services.applicationautoscaling.ScalingInterval;
import software.amazon.awscdk.services.cloudwatch.IMetric;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface BasicStepScalingPolicyProps
extends JsiiSerializable {
    public IMetric getMetric();

    public List<ScalingInterval> getScalingSteps();

    public AdjustmentType getAdjustmentType();

    public Duration getCooldown();

    public Number getMinAdjustmentMagnitude();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IMetric _metric;
        private List<ScalingInterval> _scalingSteps;
        @Nullable
        private AdjustmentType _adjustmentType;
        @Nullable
        private Duration _cooldown;
        @Nullable
        private Number _minAdjustmentMagnitude;

        public Builder withMetric(IMetric value) {
            this._metric = Objects.requireNonNull(value, "metric is required");
            return this;
        }

        public Builder withScalingSteps(List<ScalingInterval> value) {
            this._scalingSteps = Objects.requireNonNull(value, "scalingSteps is required");
            return this;
        }

        public Builder withAdjustmentType(@Nullable AdjustmentType value) {
            this._adjustmentType = value;
            return this;
        }

        public Builder withCooldown(@Nullable Duration value) {
            this._cooldown = value;
            return this;
        }

        public Builder withMinAdjustmentMagnitude(@Nullable Number value) {
            this._minAdjustmentMagnitude = value;
            return this;
        }

        public BasicStepScalingPolicyProps build() {
            return new BasicStepScalingPolicyProps(){
                private final IMetric $metric;
                private final List<ScalingInterval> $scalingSteps;
                @Nullable
                private final AdjustmentType $adjustmentType;
                @Nullable
                private final Duration $cooldown;
                @Nullable
                private final Number $minAdjustmentMagnitude;
                {
                    this.$metric = Objects.requireNonNull(_metric, "metric is required");
                    this.$scalingSteps = Objects.requireNonNull(_scalingSteps, "scalingSteps is required");
                    this.$adjustmentType = _adjustmentType;
                    this.$cooldown = _cooldown;
                    this.$minAdjustmentMagnitude = _minAdjustmentMagnitude;
                }

                @Override
                public IMetric getMetric() {
                    return this.$metric;
                }

                @Override
                public List<ScalingInterval> getScalingSteps() {
                    return this.$scalingSteps;
                }

                @Override
                public AdjustmentType getAdjustmentType() {
                    return this.$adjustmentType;
                }

                @Override
                public Duration getCooldown() {
                    return this.$cooldown;
                }

                @Override
                public Number getMinAdjustmentMagnitude() {
                    return this.$minAdjustmentMagnitude;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("metric", om.valueToTree((Object)this.getMetric()));
                    obj.set("scalingSteps", om.valueToTree(this.getScalingSteps()));
                    if (this.getAdjustmentType() != null) {
                        obj.set("adjustmentType", om.valueToTree((Object)this.getAdjustmentType()));
                    }
                    if (this.getCooldown() != null) {
                        obj.set("cooldown", om.valueToTree((Object)this.getCooldown()));
                    }
                    if (this.getMinAdjustmentMagnitude() != null) {
                        obj.set("minAdjustmentMagnitude", om.valueToTree((Object)this.getMinAdjustmentMagnitude()));
                    }
                    return obj;
                }
            };
        }
    }
}

