/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.applicationautoscaling;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.applicationautoscaling.BaseTargetTrackingProps;
import software.amazon.awscdk.services.applicationautoscaling.PredefinedMetric;
import software.amazon.awscdk.services.cloudwatch.IMetric;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface BasicTargetTrackingScalingPolicyProps
extends JsiiSerializable,
BaseTargetTrackingProps {
    public Number getTargetValue();

    public IMetric getCustomMetric();

    public PredefinedMetric getPredefinedMetric();

    public String getResourceLabel();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Number _targetValue;
        @Nullable
        private IMetric _customMetric;
        @Nullable
        private PredefinedMetric _predefinedMetric;
        @Nullable
        private String _resourceLabel;
        @Nullable
        private Boolean _disableScaleIn;
        @Nullable
        private String _policyName;
        @Nullable
        private Duration _scaleInCooldown;
        @Nullable
        private Duration _scaleOutCooldown;

        public Builder withTargetValue(Number value) {
            this._targetValue = Objects.requireNonNull(value, "targetValue is required");
            return this;
        }

        public Builder withCustomMetric(@Nullable IMetric value) {
            this._customMetric = value;
            return this;
        }

        public Builder withPredefinedMetric(@Nullable PredefinedMetric value) {
            this._predefinedMetric = value;
            return this;
        }

        public Builder withResourceLabel(@Nullable String value) {
            this._resourceLabel = value;
            return this;
        }

        public Builder withDisableScaleIn(@Nullable Boolean value) {
            this._disableScaleIn = value;
            return this;
        }

        public Builder withPolicyName(@Nullable String value) {
            this._policyName = value;
            return this;
        }

        public Builder withScaleInCooldown(@Nullable Duration value) {
            this._scaleInCooldown = value;
            return this;
        }

        public Builder withScaleOutCooldown(@Nullable Duration value) {
            this._scaleOutCooldown = value;
            return this;
        }

        public BasicTargetTrackingScalingPolicyProps build() {
            return new BasicTargetTrackingScalingPolicyProps(){
                private final Number $targetValue;
                @Nullable
                private final IMetric $customMetric;
                @Nullable
                private final PredefinedMetric $predefinedMetric;
                @Nullable
                private final String $resourceLabel;
                @Nullable
                private final Boolean $disableScaleIn;
                @Nullable
                private final String $policyName;
                @Nullable
                private final Duration $scaleInCooldown;
                @Nullable
                private final Duration $scaleOutCooldown;
                {
                    this.$targetValue = Objects.requireNonNull(_targetValue, "targetValue is required");
                    this.$customMetric = _customMetric;
                    this.$predefinedMetric = _predefinedMetric;
                    this.$resourceLabel = _resourceLabel;
                    this.$disableScaleIn = _disableScaleIn;
                    this.$policyName = _policyName;
                    this.$scaleInCooldown = _scaleInCooldown;
                    this.$scaleOutCooldown = _scaleOutCooldown;
                }

                @Override
                public Number getTargetValue() {
                    return this.$targetValue;
                }

                @Override
                public IMetric getCustomMetric() {
                    return this.$customMetric;
                }

                @Override
                public PredefinedMetric getPredefinedMetric() {
                    return this.$predefinedMetric;
                }

                @Override
                public String getResourceLabel() {
                    return this.$resourceLabel;
                }

                @Override
                public Boolean getDisableScaleIn() {
                    return this.$disableScaleIn;
                }

                @Override
                public String getPolicyName() {
                    return this.$policyName;
                }

                @Override
                public Duration getScaleInCooldown() {
                    return this.$scaleInCooldown;
                }

                @Override
                public Duration getScaleOutCooldown() {
                    return this.$scaleOutCooldown;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("targetValue", om.valueToTree((Object)this.getTargetValue()));
                    if (this.getCustomMetric() != null) {
                        obj.set("customMetric", om.valueToTree((Object)this.getCustomMetric()));
                    }
                    if (this.getPredefinedMetric() != null) {
                        obj.set("predefinedMetric", om.valueToTree((Object)this.getPredefinedMetric()));
                    }
                    if (this.getResourceLabel() != null) {
                        obj.set("resourceLabel", om.valueToTree((Object)this.getResourceLabel()));
                    }
                    if (this.getDisableScaleIn() != null) {
                        obj.set("disableScaleIn", om.valueToTree((Object)this.getDisableScaleIn()));
                    }
                    if (this.getPolicyName() != null) {
                        obj.set("policyName", om.valueToTree((Object)this.getPolicyName()));
                    }
                    if (this.getScaleInCooldown() != null) {
                        obj.set("scaleInCooldown", om.valueToTree((Object)this.getScaleInCooldown()));
                    }
                    if (this.getScaleOutCooldown() != null) {
                        obj.set("scaleOutCooldown", om.valueToTree((Object)this.getScaleOutCooldown()));
                    }
                    return obj;
                }
            };
        }
    }
}

