/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.applicationautoscaling;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnScalableTargetProps
extends JsiiSerializable {
    public Number getMaxCapacity();

    public Number getMinCapacity();

    public String getResourceId();

    public String getRoleArn();

    public String getScalableDimension();

    public String getServiceNamespace();

    public Object getScheduledActions();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Number _maxCapacity;
        private Number _minCapacity;
        private String _resourceId;
        private String _roleArn;
        private String _scalableDimension;
        private String _serviceNamespace;
        @Nullable
        private Object _scheduledActions;

        public Builder withMaxCapacity(Number value) {
            this._maxCapacity = Objects.requireNonNull(value, "maxCapacity is required");
            return this;
        }

        public Builder withMinCapacity(Number value) {
            this._minCapacity = Objects.requireNonNull(value, "minCapacity is required");
            return this;
        }

        public Builder withResourceId(String value) {
            this._resourceId = Objects.requireNonNull(value, "resourceId is required");
            return this;
        }

        public Builder withRoleArn(String value) {
            this._roleArn = Objects.requireNonNull(value, "roleArn is required");
            return this;
        }

        public Builder withScalableDimension(String value) {
            this._scalableDimension = Objects.requireNonNull(value, "scalableDimension is required");
            return this;
        }

        public Builder withServiceNamespace(String value) {
            this._serviceNamespace = Objects.requireNonNull(value, "serviceNamespace is required");
            return this;
        }

        public Builder withScheduledActions(@Nullable IResolvable value) {
            this._scheduledActions = value;
            return this;
        }

        public Builder withScheduledActions(@Nullable List<Object> value) {
            this._scheduledActions = value;
            return this;
        }

        public CfnScalableTargetProps build() {
            return new CfnScalableTargetProps(){
                private final Number $maxCapacity;
                private final Number $minCapacity;
                private final String $resourceId;
                private final String $roleArn;
                private final String $scalableDimension;
                private final String $serviceNamespace;
                @Nullable
                private final Object $scheduledActions;
                {
                    this.$maxCapacity = Objects.requireNonNull(_maxCapacity, "maxCapacity is required");
                    this.$minCapacity = Objects.requireNonNull(_minCapacity, "minCapacity is required");
                    this.$resourceId = Objects.requireNonNull(_resourceId, "resourceId is required");
                    this.$roleArn = Objects.requireNonNull(_roleArn, "roleArn is required");
                    this.$scalableDimension = Objects.requireNonNull(_scalableDimension, "scalableDimension is required");
                    this.$serviceNamespace = Objects.requireNonNull(_serviceNamespace, "serviceNamespace is required");
                    this.$scheduledActions = _scheduledActions;
                }

                @Override
                public Number getMaxCapacity() {
                    return this.$maxCapacity;
                }

                @Override
                public Number getMinCapacity() {
                    return this.$minCapacity;
                }

                @Override
                public String getResourceId() {
                    return this.$resourceId;
                }

                @Override
                public String getRoleArn() {
                    return this.$roleArn;
                }

                @Override
                public String getScalableDimension() {
                    return this.$scalableDimension;
                }

                @Override
                public String getServiceNamespace() {
                    return this.$serviceNamespace;
                }

                @Override
                public Object getScheduledActions() {
                    return this.$scheduledActions;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("maxCapacity", om.valueToTree((Object)this.getMaxCapacity()));
                    obj.set("minCapacity", om.valueToTree((Object)this.getMinCapacity()));
                    obj.set("resourceId", om.valueToTree((Object)this.getResourceId()));
                    obj.set("roleArn", om.valueToTree((Object)this.getRoleArn()));
                    obj.set("scalableDimension", om.valueToTree((Object)this.getScalableDimension()));
                    obj.set("serviceNamespace", om.valueToTree((Object)this.getServiceNamespace()));
                    if (this.getScheduledActions() != null) {
                        obj.set("scheduledActions", om.valueToTree(this.getScheduledActions()));
                    }
                    return obj;
                }
            };
        }
    }
}

