/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.applicationautoscaling;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface ScalableTargetProps
extends JsiiSerializable {
    public Number getMaxCapacity();

    public Number getMinCapacity();

    public String getResourceId();

    public String getScalableDimension();

    public ServiceNamespace getServiceNamespace();

    public IRole getRole();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Number _maxCapacity;
        private Number _minCapacity;
        private String _resourceId;
        private String _scalableDimension;
        private ServiceNamespace _serviceNamespace;
        @Nullable
        private IRole _role;

        public Builder withMaxCapacity(Number value) {
            this._maxCapacity = Objects.requireNonNull(value, "maxCapacity is required");
            return this;
        }

        public Builder withMinCapacity(Number value) {
            this._minCapacity = Objects.requireNonNull(value, "minCapacity is required");
            return this;
        }

        public Builder withResourceId(String value) {
            this._resourceId = Objects.requireNonNull(value, "resourceId is required");
            return this;
        }

        public Builder withScalableDimension(String value) {
            this._scalableDimension = Objects.requireNonNull(value, "scalableDimension is required");
            return this;
        }

        public Builder withServiceNamespace(ServiceNamespace value) {
            this._serviceNamespace = Objects.requireNonNull(value, "serviceNamespace is required");
            return this;
        }

        public Builder withRole(@Nullable IRole value) {
            this._role = value;
            return this;
        }

        public ScalableTargetProps build() {
            return new ScalableTargetProps(){
                private final Number $maxCapacity;
                private final Number $minCapacity;
                private final String $resourceId;
                private final String $scalableDimension;
                private final ServiceNamespace $serviceNamespace;
                @Nullable
                private final IRole $role;
                {
                    this.$maxCapacity = Objects.requireNonNull(_maxCapacity, "maxCapacity is required");
                    this.$minCapacity = Objects.requireNonNull(_minCapacity, "minCapacity is required");
                    this.$resourceId = Objects.requireNonNull(_resourceId, "resourceId is required");
                    this.$scalableDimension = Objects.requireNonNull(_scalableDimension, "scalableDimension is required");
                    this.$serviceNamespace = Objects.requireNonNull(_serviceNamespace, "serviceNamespace is required");
                    this.$role = _role;
                }

                @Override
                public Number getMaxCapacity() {
                    return this.$maxCapacity;
                }

                @Override
                public Number getMinCapacity() {
                    return this.$minCapacity;
                }

                @Override
                public String getResourceId() {
                    return this.$resourceId;
                }

                @Override
                public String getScalableDimension() {
                    return this.$scalableDimension;
                }

                @Override
                public ServiceNamespace getServiceNamespace() {
                    return this.$serviceNamespace;
                }

                @Override
                public IRole getRole() {
                    return this.$role;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("maxCapacity", om.valueToTree((Object)this.getMaxCapacity()));
                    obj.set("minCapacity", om.valueToTree((Object)this.getMinCapacity()));
                    obj.set("resourceId", om.valueToTree((Object)this.getResourceId()));
                    obj.set("scalableDimension", om.valueToTree((Object)this.getScalableDimension()));
                    obj.set("serviceNamespace", om.valueToTree((Object)this.getServiceNamespace()));
                    if (this.getRole() != null) {
                        obj.set("role", om.valueToTree((Object)this.getRole()));
                    }
                    return obj;
                }
            };
        }
    }
}

