/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.applicationautoscaling;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.applicationautoscaling.Schedule;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface ScalingSchedule
extends JsiiSerializable {
    public Schedule getSchedule();

    public Instant getEndTime();

    public Number getMaxCapacity();

    public Number getMinCapacity();

    public Instant getStartTime();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Schedule _schedule;
        @Nullable
        private Instant _endTime;
        @Nullable
        private Number _maxCapacity;
        @Nullable
        private Number _minCapacity;
        @Nullable
        private Instant _startTime;

        public Builder withSchedule(Schedule value) {
            this._schedule = Objects.requireNonNull(value, "schedule is required");
            return this;
        }

        public Builder withEndTime(@Nullable Instant value) {
            this._endTime = value;
            return this;
        }

        public Builder withMaxCapacity(@Nullable Number value) {
            this._maxCapacity = value;
            return this;
        }

        public Builder withMinCapacity(@Nullable Number value) {
            this._minCapacity = value;
            return this;
        }

        public Builder withStartTime(@Nullable Instant value) {
            this._startTime = value;
            return this;
        }

        public ScalingSchedule build() {
            return new ScalingSchedule(){
                private final Schedule $schedule;
                @Nullable
                private final Instant $endTime;
                @Nullable
                private final Number $maxCapacity;
                @Nullable
                private final Number $minCapacity;
                @Nullable
                private final Instant $startTime;
                {
                    this.$schedule = Objects.requireNonNull(_schedule, "schedule is required");
                    this.$endTime = _endTime;
                    this.$maxCapacity = _maxCapacity;
                    this.$minCapacity = _minCapacity;
                    this.$startTime = _startTime;
                }

                @Override
                public Schedule getSchedule() {
                    return this.$schedule;
                }

                @Override
                public Instant getEndTime() {
                    return this.$endTime;
                }

                @Override
                public Number getMaxCapacity() {
                    return this.$maxCapacity;
                }

                @Override
                public Number getMinCapacity() {
                    return this.$minCapacity;
                }

                @Override
                public Instant getStartTime() {
                    return this.$startTime;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("schedule", om.valueToTree((Object)this.getSchedule()));
                    if (this.getEndTime() != null) {
                        obj.set("endTime", om.valueToTree((Object)this.getEndTime()));
                    }
                    if (this.getMaxCapacity() != null) {
                        obj.set("maxCapacity", om.valueToTree((Object)this.getMaxCapacity()));
                    }
                    if (this.getMinCapacity() != null) {
                        obj.set("minCapacity", om.valueToTree((Object)this.getMinCapacity()));
                    }
                    if (this.getStartTime() != null) {
                        obj.set("startTime", om.valueToTree((Object)this.getStartTime()));
                    }
                    return obj;
                }
            };
        }
    }
}

