/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.applicationautoscaling;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.applicationautoscaling.AdjustmentType;
import software.amazon.awscdk.services.applicationautoscaling.IScalableTarget;
import software.amazon.awscdk.services.applicationautoscaling.MetricAggregationType;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface StepScalingActionProps
extends JsiiSerializable {
    public IScalableTarget getScalingTarget();

    public AdjustmentType getAdjustmentType();

    public Duration getCooldown();

    public MetricAggregationType getMetricAggregationType();

    public Number getMinAdjustmentMagnitude();

    public String getPolicyName();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IScalableTarget _scalingTarget;
        @Nullable
        private AdjustmentType _adjustmentType;
        @Nullable
        private Duration _cooldown;
        @Nullable
        private MetricAggregationType _metricAggregationType;
        @Nullable
        private Number _minAdjustmentMagnitude;
        @Nullable
        private String _policyName;

        public Builder withScalingTarget(IScalableTarget value) {
            this._scalingTarget = Objects.requireNonNull(value, "scalingTarget is required");
            return this;
        }

        public Builder withAdjustmentType(@Nullable AdjustmentType value) {
            this._adjustmentType = value;
            return this;
        }

        public Builder withCooldown(@Nullable Duration value) {
            this._cooldown = value;
            return this;
        }

        public Builder withMetricAggregationType(@Nullable MetricAggregationType value) {
            this._metricAggregationType = value;
            return this;
        }

        public Builder withMinAdjustmentMagnitude(@Nullable Number value) {
            this._minAdjustmentMagnitude = value;
            return this;
        }

        public Builder withPolicyName(@Nullable String value) {
            this._policyName = value;
            return this;
        }

        public StepScalingActionProps build() {
            return new StepScalingActionProps(){
                private final IScalableTarget $scalingTarget;
                @Nullable
                private final AdjustmentType $adjustmentType;
                @Nullable
                private final Duration $cooldown;
                @Nullable
                private final MetricAggregationType $metricAggregationType;
                @Nullable
                private final Number $minAdjustmentMagnitude;
                @Nullable
                private final String $policyName;
                {
                    this.$scalingTarget = Objects.requireNonNull(_scalingTarget, "scalingTarget is required");
                    this.$adjustmentType = _adjustmentType;
                    this.$cooldown = _cooldown;
                    this.$metricAggregationType = _metricAggregationType;
                    this.$minAdjustmentMagnitude = _minAdjustmentMagnitude;
                    this.$policyName = _policyName;
                }

                @Override
                public IScalableTarget getScalingTarget() {
                    return this.$scalingTarget;
                }

                @Override
                public AdjustmentType getAdjustmentType() {
                    return this.$adjustmentType;
                }

                @Override
                public Duration getCooldown() {
                    return this.$cooldown;
                }

                @Override
                public MetricAggregationType getMetricAggregationType() {
                    return this.$metricAggregationType;
                }

                @Override
                public Number getMinAdjustmentMagnitude() {
                    return this.$minAdjustmentMagnitude;
                }

                @Override
                public String getPolicyName() {
                    return this.$policyName;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("scalingTarget", om.valueToTree((Object)this.getScalingTarget()));
                    if (this.getAdjustmentType() != null) {
                        obj.set("adjustmentType", om.valueToTree((Object)this.getAdjustmentType()));
                    }
                    if (this.getCooldown() != null) {
                        obj.set("cooldown", om.valueToTree((Object)this.getCooldown()));
                    }
                    if (this.getMetricAggregationType() != null) {
                        obj.set("metricAggregationType", om.valueToTree((Object)this.getMetricAggregationType()));
                    }
                    if (this.getMinAdjustmentMagnitude() != null) {
                        obj.set("minAdjustmentMagnitude", om.valueToTree((Object)this.getMinAdjustmentMagnitude()));
                    }
                    if (this.getPolicyName() != null) {
                        obj.set("policyName", om.valueToTree((Object)this.getPolicyName()));
                    }
                    return obj;
                }
            };
        }
    }
}

