package software.amazon.awscdk.services.appmesh;

/**
 * Configuration for Envoy Access logs for mesh endpoints.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh;
 * Vpc vpc = new Vpc(this, "vpc");
 * PrivateDnsNamespace namespace = PrivateDnsNamespace.Builder.create(this, "test-namespace")
 *         .vpc(vpc)
 *         .name("domain.local")
 *         .build();
 * Service service = namespace.createService("Svc");
 * VirtualNode node = mesh.addVirtualNode("virtual-node", VirtualNodeBaseProps.builder()
 *         .serviceDiscovery(ServiceDiscovery.cloudMap(service))
 *         .listeners(List.of(VirtualNodeListener.http(HttpVirtualNodeListenerOptions.builder()
 *                 .port(8081)
 *                 .healthCheck(HealthCheck.http(HttpHealthCheckOptions.builder()
 *                         .healthyThreshold(3)
 *                         .interval(Duration.seconds(5)) // minimum
 *                         .path("/health-check-path")
 *                         .timeout(Duration.seconds(2)) // minimum
 *                         .unhealthyThreshold(2)
 *                         .build()))
 *                 .build())))
 *         .accessLog(AccessLog.fromFilePath("/dev/stdout"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:45.997Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.appmesh.$Module.class, fqn = "@aws-cdk/aws-appmesh.AccessLog")
public abstract class AccessLog extends software.amazon.jsii.JsiiObject {

    protected AccessLog(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AccessLog(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected AccessLog() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Path to a file to write access logs to.
     * <p>
     * Default: - no file based access logging
     * <p>
     * @param filePath This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.AccessLog fromFilePath(final @org.jetbrains.annotations.NotNull java.lang.String filePath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.AccessLog.class, "fromFilePath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.AccessLog.class), new Object[] { java.util.Objects.requireNonNull(filePath, "filePath is required") });
    }

    /**
     * Called when the AccessLog type is initialized.
     * <p>
     * Can be used to enforce
     * mutual exclusivity with future properties
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.AccessLogConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.AccessLog {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Called when the AccessLog type is initialized.
         * <p>
         * Can be used to enforce
         * mutual exclusivity with future properties
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.AccessLogConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.AccessLogConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
