package software.amazon.awscdk.services.appmesh;

/**
 * Properties for a backend.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * BackendConfig backendConfig = BackendConfig.builder()
 *         .virtualServiceBackend(BackendProperty.builder()
 *                 .virtualService(VirtualServiceBackendProperty.builder()
 *                         .virtualServiceName("virtualServiceName")
 *                         // the properties below are optional
 *                         .clientPolicy(ClientPolicyProperty.builder()
 *                                 .tls(ClientPolicyTlsProperty.builder()
 *                                         .validation(TlsValidationContextProperty.builder()
 *                                                 .trust(TlsValidationContextTrustProperty.builder()
 *                                                         .acm(TlsValidationContextAcmTrustProperty.builder()
 *                                                                 .certificateAuthorityArns(List.of("certificateAuthorityArns"))
 *                                                                 .build())
 *                                                         .file(TlsValidationContextFileTrustProperty.builder()
 *                                                                 .certificateChain("certificateChain")
 *                                                                 .build())
 *                                                         .sds(TlsValidationContextSdsTrustProperty.builder()
 *                                                                 .secretName("secretName")
 *                                                                 .build())
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
 *                                                         .match(SubjectAlternativeNameMatchersProperty.builder()
 *                                                                 .exact(List.of("exact"))
 *                                                                 .build())
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .certificate(ClientTlsCertificateProperty.builder()
 *                                                 .file(ListenerTlsFileCertificateProperty.builder()
 *                                                         .certificateChain("certificateChain")
 *                                                         .privateKey("privateKey")
 *                                                         .build())
 *                                                 .sds(ListenerTlsSdsCertificateProperty.builder()
 *                                                         .secretName("secretName")
 *                                                         .build())
 *                                                 .build())
 *                                         .enforce(false)
 *                                         .ports(List.of(123))
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:46.017Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.appmesh.$Module.class, fqn = "@aws-cdk/aws-appmesh.BackendConfig")
@software.amazon.jsii.Jsii.Proxy(BackendConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BackendConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Config for a Virtual Service backend.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.CfnVirtualNode.BackendProperty getVirtualServiceBackend();

    /**
     * @return a {@link Builder} of {@link BackendConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BackendConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BackendConfig> {
        software.amazon.awscdk.services.appmesh.CfnVirtualNode.BackendProperty virtualServiceBackend;

        /**
         * Sets the value of {@link BackendConfig#getVirtualServiceBackend}
         * @param virtualServiceBackend Config for a Virtual Service backend. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualServiceBackend(software.amazon.awscdk.services.appmesh.CfnVirtualNode.BackendProperty virtualServiceBackend) {
            this.virtualServiceBackend = virtualServiceBackend;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BackendConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BackendConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BackendConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BackendConfig {
        private final software.amazon.awscdk.services.appmesh.CfnVirtualNode.BackendProperty virtualServiceBackend;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.virtualServiceBackend = software.amazon.jsii.Kernel.get(this, "virtualServiceBackend", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnVirtualNode.BackendProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.virtualServiceBackend = java.util.Objects.requireNonNull(builder.virtualServiceBackend, "virtualServiceBackend is required");
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnVirtualNode.BackendProperty getVirtualServiceBackend() {
            return this.virtualServiceBackend;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("virtualServiceBackend", om.valueToTree(this.getVirtualServiceBackend()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-appmesh.BackendConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BackendConfig.Jsii$Proxy that = (BackendConfig.Jsii$Proxy) o;

            return this.virtualServiceBackend.equals(that.virtualServiceBackend);
        }

        @Override
        public final int hashCode() {
            int result = this.virtualServiceBackend.hashCode();
            return result;
        }
    }
}
