package software.amazon.awscdk.services.appmesh;

/**
 * Represents the properties needed to define listeners for a VirtualGateway.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh;
 * String certificateAuthorityArn = "arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/12345678-1234-1234-1234-123456789012";
 * VirtualGateway gateway = VirtualGateway.Builder.create(this, "gateway")
 *         .mesh(mesh)
 *         .listeners(List.of(VirtualGatewayListener.http(HttpGatewayListenerOptions.builder()
 *                 .port(443)
 *                 .healthCheck(HealthCheck.http(HttpHealthCheckOptions.builder()
 *                         .interval(Duration.seconds(10))
 *                         .build()))
 *                 .build())))
 *         .backendDefaults(BackendDefaults.builder()
 *                 .tlsClientPolicy(TlsClientPolicy.builder()
 *                         .ports(List.of(8080, 8081))
 *                         .validation(TlsValidation.builder()
 *                                 .trust(TlsValidationTrust.acm(List.of(CertificateAuthority.fromCertificateAuthorityArn(this, "certificate", certificateAuthorityArn))))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .accessLog(AccessLog.fromFilePath("/dev/stdout"))
 *         .virtualGatewayName("virtualGateway")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:46.353Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.appmesh.$Module.class, fqn = "@aws-cdk/aws-appmesh.VirtualGatewayListener")
public abstract class VirtualGatewayListener extends software.amazon.jsii.JsiiObject {

    protected VirtualGatewayListener(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VirtualGatewayListener(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected VirtualGatewayListener() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Returns a GRPC Listener for a VirtualGateway.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualGatewayListener grpc(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.GrpcGatewayListenerOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualGatewayListener.class, "grpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualGatewayListener.class), new Object[] { options });
    }

    /**
     * Returns a GRPC Listener for a VirtualGateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualGatewayListener grpc() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualGatewayListener.class, "grpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualGatewayListener.class));
    }

    /**
     * Returns an HTTP Listener for a VirtualGateway.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualGatewayListener http(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.HttpGatewayListenerOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualGatewayListener.class, "http", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualGatewayListener.class), new Object[] { options });
    }

    /**
     * Returns an HTTP Listener for a VirtualGateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualGatewayListener http() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualGatewayListener.class, "http", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualGatewayListener.class));
    }

    /**
     * Returns an HTTP2 Listener for a VirtualGateway.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualGatewayListener http2(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.Http2GatewayListenerOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualGatewayListener.class, "http2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualGatewayListener.class), new Object[] { options });
    }

    /**
     * Returns an HTTP2 Listener for a VirtualGateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualGatewayListener http2() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualGatewayListener.class, "http2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualGatewayListener.class));
    }

    /**
     * Called when the GatewayListener type is initialized.
     * <p>
     * Can be used to enforce
     * mutual exclusivity
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualGatewayListenerConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.VirtualGatewayListener {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Called when the GatewayListener type is initialized.
         * <p>
         * Can be used to enforce
         * mutual exclusivity
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualGatewayListenerConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualGatewayListenerConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
