package software.amazon.awscdk.services.appmesh;

/**
 * (experimental) VirtualGateway represents a newly defined App Mesh Virtual Gateway.
 * <p>
 * A virtual gateway allows resources that are outside of your mesh to communicate to resources that
 * are inside of your mesh.
 * <p>
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:47:05.107Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.appmesh.$Module.class, fqn = "@aws-cdk/aws-appmesh.VirtualGateway")
public class VirtualGateway extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.appmesh.IVirtualGateway {

    protected VirtualGateway(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VirtualGateway(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public VirtualGateway(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualGatewayProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import an existing VirtualGateway given an ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param virtualGatewayArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualGateway fromVirtualGatewayArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String virtualGatewayArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualGateway.class, "fromVirtualGatewayArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualGateway.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(virtualGatewayArn, "virtualGatewayArn is required") });
    }

    /**
     * (experimental) Import an existing VirtualGateway given its attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualGateway fromVirtualGatewayAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualGatewayAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualGateway.class, "fromVirtualGatewayAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualGateway.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) Utility method to add a new GatewayRoute to the VirtualGateway.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GatewayRoute addGatewayRoute(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GatewayRouteBaseProps props) {
        return software.amazon.jsii.Kernel.call(this, "addGatewayRoute", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.GatewayRoute.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appmesh.VirtualGatewayListenerConfig> getListeners() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "listeners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualGatewayListenerConfig.class))));
    }

    /**
     * (experimental) The Mesh that the VirtualGateway belongs to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IMesh getMesh() {
        return software.amazon.jsii.Kernel.get(this, "mesh", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IMesh.class));
    }

    /**
     * (experimental) The Amazon Resource Name (ARN) for the VirtualGateway.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getVirtualGatewayArn() {
        return software.amazon.jsii.Kernel.get(this, "virtualGatewayArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the VirtualGateway.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getVirtualGatewayName() {
        return software.amazon.jsii.Kernel.get(this, "virtualGatewayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.appmesh.VirtualGateway}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appmesh.VirtualGateway> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appmesh.VirtualGatewayProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appmesh.VirtualGatewayProps.Builder();
        }

        /**
         * (experimental) Access Logging Configuration for the VirtualGateway.
         * <p>
         * Default: - no access logging
         * <p>
         * @return {@code this}
         * @param accessLog Access Logging Configuration for the VirtualGateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accessLog(final software.amazon.awscdk.services.appmesh.AccessLog accessLog) {
            this.props.accessLog(accessLog);
            return this;
        }

        /**
         * (experimental) Default Configuration Virtual Node uses to communicate with Virtual Service.
         * <p>
         * Default: - No Config
         * <p>
         * @return {@code this}
         * @param backendsDefaultClientPolicy Default Configuration Virtual Node uses to communicate with Virtual Service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder backendsDefaultClientPolicy(final software.amazon.awscdk.services.appmesh.ClientPolicy backendsDefaultClientPolicy) {
            this.props.backendsDefaultClientPolicy(backendsDefaultClientPolicy);
            return this;
        }

        /**
         * (experimental) Listeners for the VirtualGateway.
         * <p>
         * Only one is supported.
         * <p>
         * Default: - Single HTTP listener on port 8080
         * <p>
         * @return {@code this}
         * @param listeners Listeners for the VirtualGateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder listeners(final java.util.List<? extends software.amazon.awscdk.services.appmesh.VirtualGatewayListener> listeners) {
            this.props.listeners(listeners);
            return this;
        }

        /**
         * (experimental) Name of the VirtualGateway.
         * <p>
         * Default: - A name is automatically determined
         * <p>
         * @return {@code this}
         * @param virtualGatewayName Name of the VirtualGateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder virtualGatewayName(final java.lang.String virtualGatewayName) {
            this.props.virtualGatewayName(virtualGatewayName);
            return this;
        }

        /**
         * (experimental) The Mesh which the VirtualGateway belongs to.
         * <p>
         * @return {@code this}
         * @param mesh The Mesh which the VirtualGateway belongs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mesh(final software.amazon.awscdk.services.appmesh.IMesh mesh) {
            this.props.mesh(mesh);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appmesh.VirtualGateway}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.appmesh.VirtualGateway build() {
            return new software.amazon.awscdk.services.appmesh.VirtualGateway(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
