package software.amazon.awscdk.services.appmesh;

/**
 * (experimental) VirtualNode represents a newly defined AppMesh VirtualNode.
 * <p>
 * Any inbound traffic that your virtual node expects should be specified as a
 * listener. Any outbound traffic that your virtual node expects to reach
 * should be specified as a backend.
 * <p>
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:47:05.108Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.appmesh.$Module.class, fqn = "@aws-cdk/aws-appmesh.VirtualNode")
public class VirtualNode extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.appmesh.IVirtualNode {

    protected VirtualNode(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VirtualNode(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public VirtualNode(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import an existing VirtualNode given an ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param virtualNodeArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualNode fromVirtualNodeArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String virtualNodeArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNode.class, "fromVirtualNodeArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualNode.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(virtualNodeArn, "virtualNodeArn is required") });
    }

    /**
     * (experimental) Import an existing VirtualNode given its name.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualNode fromVirtualNodeAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNode.class, "fromVirtualNodeAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualNode.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) Add a Virtual Services that this node is expected to send outbound traffic to.
     * <p>
     * @param virtualService This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addBackend(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualService virtualService) {
        software.amazon.jsii.Kernel.call(this, "addBackend", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(virtualService, "virtualService is required") });
    }

    /**
     * (experimental) Utility method to add an inbound listener for this VirtualNode.
     * <p>
     * @param listener This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addListener(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListener listener) {
        software.amazon.jsii.Kernel.call(this, "addListener", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(listener, "listener is required") });
    }

    /**
     * (experimental) The Mesh which the VirtualNode belongs to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IMesh getMesh() {
        return software.amazon.jsii.Kernel.get(this, "mesh", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IMesh.class));
    }

    /**
     * (experimental) The Amazon Resource Name belonging to the VirtualNode.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getVirtualNodeArn() {
        return software.amazon.jsii.Kernel.get(this, "virtualNodeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the VirtualNode.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getVirtualNodeName() {
        return software.amazon.jsii.Kernel.get(this, "virtualNodeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.appmesh.VirtualNode}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appmesh.VirtualNode> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appmesh.VirtualNodeProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appmesh.VirtualNodeProps.Builder();
        }

        /**
         * (experimental) Access Logging Configuration for the virtual node.
         * <p>
         * Default: - No access logging
         * <p>
         * @return {@code this}
         * @param accessLog Access Logging Configuration for the virtual node. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accessLog(final software.amazon.awscdk.services.appmesh.AccessLog accessLog) {
            this.props.accessLog(accessLog);
            return this;
        }

        /**
         * (experimental) Virtual Services that this is node expected to send outbound traffic to.
         * <p>
         * Default: - No backends
         * <p>
         * @return {@code this}
         * @param backends Virtual Services that this is node expected to send outbound traffic to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder backends(final java.util.List<? extends software.amazon.awscdk.services.appmesh.IVirtualService> backends) {
            this.props.backends(backends);
            return this;
        }

        /**
         * (experimental) Default Configuration Virtual Node uses to communicate with Virtual Service.
         * <p>
         * Default: - No Config
         * <p>
         * @return {@code this}
         * @param backendsDefaultClientPolicy Default Configuration Virtual Node uses to communicate with Virtual Service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder backendsDefaultClientPolicy(final software.amazon.awscdk.services.appmesh.ClientPolicy backendsDefaultClientPolicy) {
            this.props.backendsDefaultClientPolicy(backendsDefaultClientPolicy);
            return this;
        }

        /**
         * (experimental) Initial listener for the virtual node.
         * <p>
         * Default: - No listeners
         * <p>
         * @return {@code this}
         * @param listeners Initial listener for the virtual node. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder listeners(final java.util.List<? extends software.amazon.awscdk.services.appmesh.VirtualNodeListener> listeners) {
            this.props.listeners(listeners);
            return this;
        }

        /**
         * (experimental) Defines how upstream clients will discover this VirtualNode.
         * <p>
         * Default: - No Service Discovery
         * <p>
         * @return {@code this}
         * @param serviceDiscovery Defines how upstream clients will discover this VirtualNode. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceDiscovery(final software.amazon.awscdk.services.appmesh.ServiceDiscovery serviceDiscovery) {
            this.props.serviceDiscovery(serviceDiscovery);
            return this;
        }

        /**
         * (experimental) The name of the VirtualNode.
         * <p>
         * Default: - A name is automatically determined
         * <p>
         * @return {@code this}
         * @param virtualNodeName The name of the VirtualNode. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder virtualNodeName(final java.lang.String virtualNodeName) {
            this.props.virtualNodeName(virtualNodeName);
            return this;
        }

        /**
         * (experimental) The Mesh which the VirtualNode belongs to.
         * <p>
         * @return {@code this}
         * @param mesh The Mesh which the VirtualNode belongs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mesh(final software.amazon.awscdk.services.appmesh.IMesh mesh) {
            this.props.mesh(mesh);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appmesh.VirtualNode}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.appmesh.VirtualNode build() {
            return new software.amazon.awscdk.services.appmesh.VirtualNode(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
