/**
 * <h1>AWS App Mesh Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * All classes with the <code>Cfn</code> prefix in this module (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">CFN Resources</a>) are always stable and safe to use.
 * <p>
 * </blockquote>
 * <p>
 * <img alt="cdk-constructs: Developer Preview" src="https://img.shields.io/badge/cdk--constructs-developer--preview-informational.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are in <strong>developer preview</strong> before they
 * become stable. We will only make breaking changes to address unforeseen API issues. Therefore,
 * these APIs are not subject to <a href="https://semver.org/">Semantic Versioning</a>, and breaking changes
 * will be announced in release notes. This means that while you may use them, you may need to
 * update your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * AWS App Mesh is a service mesh based on the <a href="https://www.envoyproxy.io/">Envoy</a> proxy that makes it easy to monitor and control microservices. App Mesh standardizes how your microservices communicate, giving you end-to-end visibility and helping to ensure high-availability for your applications.
 * <p>
 * App Mesh gives you consistent visibility and network traffic controls for every microservice in an application.
 * <p>
 * App Mesh supports microservice applications that use service discovery naming for their components. To use App Mesh, you must have an existing application running on AWS Fargate, Amazon ECS, Amazon EKS, Kubernetes on AWS, or Amazon EC2.
 * <p>
 * For futher information on <strong>AWS AppMesh</strong> visit the <a href="https://docs.aws.amazon.com/app-mesh/index.html">AWS Docs for AppMesh</a>.
 * <p>
 * <h2>Create the App and Stack</h2>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object app = new App();
 * Object stack = new Stack(app, "stack");
 * </pre></blockquote>
 * <p>
 * <h2>Creating the Mesh</h2>
 * <p>
 * A service mesh is a logical boundary for network traffic between the services that reside within it.
 * <p>
 * After you create your service mesh, you can create virtual services, virtual nodes, virtual routers, and routes to distribute traffic between the applications in your mesh.
 * <p>
 * The following example creates the <code>AppMesh</code> service mesh with the default filter of <code>DROP_ALL</code>, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-mesh-egressfilter.html">docs</a> here for more info on egress filters.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object mesh = Mesh.Builder.create(stack, "AppMesh")
 *         .meshName("myAwsmMesh")
 *         .build();
 * </pre></blockquote>
 * <p>
 * The mesh can also be created with the "ALLOW_ALL" egress filter by overwritting the property.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object mesh = Mesh.Builder.create(stack, "AppMesh")
 *         .meshName("myAwsmMesh")
 *         .egressFilter(MeshFilterType.getALLOW_ALL())
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Adding VirtualRouters</h2>
 * <p>
 * The <em>Mesh</em> needs <em>VirtualRouters</em> as logical units to route requests to <em>VirtualNodes</em>.
 * <p>
 * Virtual routers handle traffic for one or more virtual services within your mesh.
 * After you create a virtual router, you can create and associate routes to your virtual router that direct incoming requests to different virtual nodes.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object router = mesh.addVirtualRouter("router", Map.of(
 *         "listeners", asList(appmesh.VirtualRouterListener.http(8080))));
 * </pre></blockquote>
 * <p>
 * The router can also be created using the constructor and passing in the mesh instead of calling the <code>addVirtualRouter()</code> method for the mesh.
 * The same pattern applies to all constructs within the appmesh library, for any mesh.addXZY method, a new constuctor can also be used.
 * This is particularly useful for cross stack resources are required.
 * Where creating the <code>mesh</code> as part of an infrastructure stack and creating the <code>resources</code> such as <code>nodes</code> is more useful to keep in the application stack.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object mesh = Mesh.Builder.create(stack, "AppMesh")
 *         .meshName("myAwsmMesh")
 *         .egressFilter(MeshFilterType.getAllow_All())
 *         .build();
 * 
 * Object router = VirtualRouter.Builder.create(stack, "router")
 *         .mesh(mesh)// notice that mesh is a required property when creating a router with a new statement
 *         .listeners(asList(appmesh.VirtualRouterListener.http(8081)))
 *         .build();
 * </pre></blockquote>
 * <p>
 * The <em>VirtualRouterListener</em> class provides an easy interface for defining new protocol specific listeners.
 * The <code>http()</code>, <code>http2()</code>, <code>grpc()</code> and <code>tcp()</code> methods are available for use.
 * They accept a single port parameter, that is used to define what port to match requests on.
 * The port parameter can be omitted, and it will default to port 8080.
 * <p>
 * <h2>Adding VirtualService</h2>
 * <p>
 * A virtual service is an abstraction of a real service that is provided by a virtual node directly or indirectly by means of a virtual router. Dependent services call your virtual service by its virtualServiceName, and those requests are routed to the virtual node or virtual router that is specified as the provider for the virtual service.
 * <p>
 * We recommend that you use the service discovery name of the real service that you're targeting (such as <code>my-service.default.svc.cluster.local</code>).
 * <p>
 * When creating a virtual service:
 * <p>
 * <ul>
 * <li>If you want the virtual service to spread traffic across multiple virtual nodes, specify a Virtual router.</li>
 * <li>If you want the virtual service to reach a virtual node directly, without a virtual router, specify a Virtual node.</li>
 * </ul>
 * <p>
 * Adding a virtual router as the provider:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * VirtualService.Builder.create("virtual-service")
 *         .virtualServiceName("my-service.default.svc.cluster.local")// optional
 *         .virtualServiceProvider(appmesh.VirtualServiceProvider.virtualRouter(router))
 *         .build();
 * </pre></blockquote>
 * <p>
 * Adding a virtual node as the provider:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * VirtualService.Builder.create("virtual-service")
 *         .virtualServiceName("my-service.default.svc.cluster.local")// optional
 *         .virtualServiceProvider(appmesh.VirtualServiceProvider.virtualNode(node))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Adding a VirtualNode</h2>
 * <p>
 * A <code>virtual node</code> acts as a logical pointer to a particular task group, such as an Amazon ECS service or a Kubernetes deployment.
 * <p>
 * When you create a <code>virtual node</code>, any inbound traffic that your <code>virtual node</code> expects should be specified as a listener. Any outbound traffic that your <code>virtual node</code> expects to reach should be specified as a backend.
 * <p>
 * The response metadata for your new <code>virtual node</code> contains the Amazon Resource Name (ARN) that is associated with the <code>virtual node</code>. Set this value (either the full ARN or the truncated resource name) as the APPMESH_VIRTUAL_NODE_NAME environment variable for your task group's Envoy proxy container in your task definition or pod spec. For example, the value could be mesh/default/virtualNode/simpleapp. This is then mapped to the node.id and node.cluster Envoy parameters.
 * <p>
 * <blockquote>
 * <p>
 * Note
 * If you require your Envoy stats or tracing to use a different name, you can override the node.cluster value that is set by APPMESH_VIRTUAL_NODE_NAME with the APPMESH_VIRTUAL_NODE_CLUSTER environment variable.
 * <p>
 * </blockquote>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object vpc = new Vpc(stack, "vpc");
 * Object namespace = PrivateDnsNamespace.Builder.create(this, "test-namespace")
 *         .vpc(vpc)
 *         .name("domain.local")
 *         .build();
 * Object service = namespace.createService("Svc");
 * 
 * Object node = mesh.addVirtualNode("virtual-node", Map.of(
 *         "serviceDiscovery", appmesh.ServiceDiscovery.cloudMap(Map.of(
 *                 "service", service)),
 *         "listeners", asList(appmesh.VirtualNodeListener.httpNodeListener(Map.of(
 *                 "port", 8081,
 *                 "healthCheck", Map.of(
 *                         "healthyThreshold", 3,
 *                         "interval", Duration.seconds(5), // minimum
 *                         "path", "/health-check-path",
 *                         "port", 8080,
 *                         "protocol", Protocol.getHTTP(),
 *                         "timeout", Duration.seconds(2), // minimum
 *                         "unhealthyThreshold", 2)))),
 *         "accessLog", appmesh.AccessLog.fromFilePath("/dev/stdout")));
 * </pre></blockquote>
 * <p>
 * Create a <code>VirtualNode</code> with the constructor and add tags.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object node = VirtualNode.Builder.create(this, "node")
 *         .mesh(mesh)
 *         .serviceDiscovery(appmesh.ServiceDiscovery.cloudMap(Map.of(
 *                 "service", service)))
 *         .listeners(asList(appmesh.VirtualNodeListener.httpNodeListener(Map.of(
 *                 "port", 8080,
 *                 "healthCheck", Map.of(
 *                         "healthyThreshold", 3,
 *                         "interval", Duration.seconds(5), // min
 *                         "path", "/ping",
 *                         "port", 8080,
 *                         "protocol", Protocol.getHTTP(),
 *                         "timeout", Duration.seconds(2), // min
 *                         "unhealthyThreshold", 2),
 *                 "timeout", Map.of(
 *                         "idle", cdk.Duration.seconds(5))))))
 *         .backendsDefaultClientPolicy(appmesh.ClientPolicy.fileTrust(Map.of(
 *                 "certificateChain", "/keys/local_cert_chain.pem")))
 *         .accessLog(appmesh.AccessLog.fromFilePath("/dev/stdout"))
 *         .build();
 * 
 * cdk.Tag.add(node, "Environment", "Dev");
 * </pre></blockquote>
 * <p>
 * Create a <code>VirtualNode</code> with the constructor and add backend virtual service.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object node = VirtualNode.Builder.create(this, "node")
 *         .mesh(mesh)
 *         .serviceDiscovery(appmesh.ServiceDiscovery.cloudMap(Map.of(
 *                 "service", service)))
 *         .listeners(asList(appmesh.VirtualNodeListener.httpNodeListener(Map.of(
 *                 "port", 8080,
 *                 "healthCheck", Map.of(
 *                         "healthyThreshold", 3,
 *                         "interval", Duration.seconds(5), // min
 *                         "path", "/ping",
 *                         "port", 8080,
 *                         "protocol", Protocol.getHTTP(),
 *                         "timeout", Duration.seconds(2), // min
 *                         "unhealthyThreshold", 2),
 *                 "timeout", Map.of(
 *                         "idle", cdk.Duration.seconds(5))))))
 *         .accessLog(appmesh.AccessLog.fromFilePath("/dev/stdout"))
 *         .build();
 * 
 * Object virtualService = VirtualService.Builder.create(stack, "service-1")
 *         .serviceDiscovery(appmesh.ServiceDiscovery.dns("service1.domain.local"))
 *         .mesh(mesh)
 *         .clientPolicy(appmesh.ClientPolicy.fileTrust(Map.of(
 *                 "certificateChain", "/keys/local_cert_chain.pem",
 *                 "ports", asList(8080, 8081))))
 *         .build();
 * 
 * node.addBackend(virtualService);
 * </pre></blockquote>
 * <p>
 * The <code>listeners</code> property can be left blank and added later with the <code>node.addListener()</code> method. The <code>healthcheck</code> and <code>timeout</code> properties are optional but if specifying a listener, the <code>port</code> must be added.
 * <p>
 * The <code>backends</code> property can be added with <code>node.addBackend()</code>. We define a virtual service and add it to the virtual node to allow egress traffic to other node.
 * <p>
 * The <code>backendsDefaultClientPolicy</code> property are added to the node while creating the virtual node. These are virtual node's service backends client policy defaults.
 * <p>
 * <h2>Adding TLS to a listener</h2>
 * <p>
 * The <code>tlsCertificate</code> property can be added to a Virtual Node listener or Virtual Gateway listener to add TLS configuration.
 * A certificate from AWS Certificate Manager can be incorporated or a customer provided certificate can be specified with a <code>certificateChain</code> path file and a <code>privateKey</code> file path.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.certificatemanager.*;
 * 
 * // A Virtual Node with listener TLS from an ACM provided certificate
 * Certificate cert = new Certificate(this, "cert", new CertificateProps()...);
 * 
 * Object node = VirtualNode.Builder.create(stack, "node")
 *         .mesh(mesh)
 *         .dnsHostName("node")
 *         .listeners(asList(appmesh.VirtualNodeListener.grpc(Map.of(
 *                 "port", 80,
 *                 "tlsCertificate", appmesh.TlsCertificate.acm(Map.of(
 *                         "certificate", cert,
 *                         "tlsMode", TlsMode.getSTRICT()))))))
 *         .build();
 * 
 * // A Virtual Gateway with listener TLS from a customer provided file certificate
 * Object gateway = VirtualGateway.Builder.create(this, "gateway")
 *         .mesh(mesh)
 *         .listeners(asList(appmesh.VirtualGatewayListener.grpc(Map.of(
 *                 "port", 8080,
 *                 "tlsCertificate", appmesh.TlsCertificate.file(Map.of(
 *                         "certificateChain", "path/to/certChain",
 *                         "privateKey", "path/to/privateKey",
 *                         "tlsMode", TlsMode.getSTRICT()))))))
 *         .virtualGatewayName("gateway")
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Adding a Route</h2>
 * <p>
 * A <code>route</code> is associated with a virtual router, and it's used to match requests for a virtual router and distribute traffic accordingly to its associated virtual nodes.
 * <p>
 * If your <code>route</code> matches a request, you can distribute traffic to one or more target virtual nodes with relative weighting.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * router.addRoute("route-http", Map.of(
 *         "routeSpec", appmesh.RouteSpec.http(Map.of(
 *                 "weightedTargets", asList(Map.of(
 *                         "virtualNode", node)),
 *                 "match", Map.of(
 *                         "prefixPath", "/path-to-app")))));
 * </pre></blockquote>
 * <p>
 * Add a single route with multiple targets and split traffic 50/50
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * router.addRoute("route-http", Map.of(
 *         "routeSpec", appmesh.RouteSpec.http(Map.of(
 *                 "weightedTargets", asList(Map.of(
 *                         "virtualNode", node,
 *                         "weight", 50), Map.of(
 *                         "virtualNode", node,
 *                         "weight", 50)),
 *                 "match", Map.of(
 *                         "prefixPath", "/path-to-app")))));
 * </pre></blockquote>
 * <p>
 * Add an http2 route with retries:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * router.addRoute("route-http2-retry", Map.of(
 *         "routeSpec", appmesh.RouteSpec.http2(Map.of(
 *                 "weightedTargets", asList(Map.of("virtualNode", node)),
 *                 "retryPolicy", Map.of(
 *                         // Retry if the connection failed
 *                         "tcpRetryEvents", asList(appmesh.TcpRetryEvent.getCONNECTION_ERROR()),
 *                         // Retry if HTTP responds with a gateway error (502, 503, 504)
 *                         "httpRetryEvents", asList(appmesh.HttpRetryEvent.getGATEWAY_ERROR()),
 *                         // Retry five times
 *                         "retryAttempts", 5,
 *                         // Use a 1 second timeout per retry
 *                         "retryTimeout", cdk.Duration.seconds(1))))));
 * </pre></blockquote>
 * <p>
 * Add a gRPC route with retries:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * router.addRoute("route-grpc-retry", Map.of(
 *         "routeSpec", appmesh.RouteSpec.grpc(Map.of(
 *                 "weightedTargets", asList(Map.of("virtualNode", node)),
 *                 "match", Map.of("serviceName", "servicename"),
 *                 "retryPolicy", Map.of(
 *                         "tcpRetryEvents", asList(appmesh.TcpRetryEvent.getCONNECTION_ERROR()),
 *                         "httpRetryEvents", asList(appmesh.HttpRetryEvent.getGATEWAY_ERROR()),
 *                         // Retry if gRPC responds that the request was cancelled, a resource
 *                         // was exhausted, or if the service is unavailable
 *                         "grpcRetryEvents", asList(appmesh.GrpcRetryEvent.getCANCELLED(), appmesh.GrpcRetryEvent.getRESOURCE_EXHAUSTED(), appmesh.GrpcRetryEvent.getUNAVAILABLE()),
 *                         "retryAttempts", 5,
 *                         "retryTimeout", cdk.Duration.seconds(1))))));
 * </pre></blockquote>
 * <p>
 * The <em>RouteSpec</em> class provides an easy interface for defining new protocol specific route specs.
 * The <code>tcp()</code>, <code>http()</code> and <code>http2()</code> methods provide the spec necessary to define a protocol specific spec.
 * <p>
 * For HTTP based routes, the match field can be used to match on a route prefix.
 * By default, an HTTP based route will match on <code>/</code>. All matches must start with a leading <code>/</code>.
 * The timeout field can also be specified for <code>idle</code> and <code>perRequest</code> timeouts.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * router.addRoute("route-http", Map.of(
 *         "routeSpec", appmesh.RouteSpec.grpc(Map.of(
 *                 "weightedTargets", asList(Map.of(
 *                         "virtualNode", node)),
 *                 "match", Map.of(
 *                         "serviceName", "my-service.default.svc.cluster.local"),
 *                 "timeout", Map.of(
 *                         "idle", Duration.seconds(2),
 *                         "perRequest", Duration.seconds(1))))));
 * </pre></blockquote>
 * <p>
 * <h2>Adding a Virtual Gateway</h2>
 * <p>
 * A <em>virtual gateway</em> allows resources outside your mesh to communicate to resources that are inside your mesh.
 * The virtual gateway represents an Envoy proxy running in an Amazon ECS task, in a Kubernetes service, or on an Amazon EC2 instance.
 * Unlike a virtual node, which represents an Envoy running with an application, a virtual gateway represents Envoy deployed by itself.
 * <p>
 * A virtual gateway is similar to a virtual node in that it has a listener that accepts traffic for a particular port and protocol (HTTP, HTTP2, GRPC).
 * The traffic that the virtual gateway receives, is directed to other services in your mesh,
 * using rules defined in gateway routes which can be added to your virtual gateway.
 * <p>
 * Create a virtual gateway with the constructor:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * String certificateAuthorityArn = "arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/12345678-1234-1234-1234-123456789012";
 * 
 * Object gateway = VirtualGateway.Builder.create(stack, "gateway")
 *         .mesh(mesh)
 *         .listeners(asList(appmesh.VirtualGatewayListener.http(Map.of(
 *                 "port", 443,
 *                 "healthCheck", Map.of(
 *                         "interval", cdk.Duration.seconds(10))))))
 *         .backendsDefaultClientPolicy(appmesh.ClientPolicy.acmTrust(Map.of(
 *                 "certificateAuthorities", asList(acmpca.CertificateAuthority.fromCertificateAuthorityArn(stack, "certificate", certificateAuthorityArn)),
 *                 "ports", asList(8080, 8081))))
 *         .accessLog(appmesh.AccessLog.fromFilePath("/dev/stdout"))
 *         .virtualGatewayName("virtualGateway")
 *         .build();
 * </pre></blockquote>
 * <p>
 * Add a virtual gateway directly to the mesh:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object gateway = mesh.addVirtualGateway("gateway", Map.of(
 *         "accessLog", appmesh.AccessLog.fromFilePath("/dev/stdout"),
 *         "virtualGatewayName", "virtualGateway",
 *         "listeners", asList(appmesh.VirtualGatewayListener.http(Map.of(
 *                 "port", 443,
 *                 "healthCheck", Map.of(
 *                         "interval", cdk.Duration.seconds(10)))))));
 * </pre></blockquote>
 * <p>
 * The listeners field can be omitted which will default to an HTTP Listener on port 8080.
 * A gateway route can be added using the <code>gateway.addGatewayRoute()</code> method.
 * <p>
 * The <code>backendsDefaultClientPolicy</code> property are added to the node while creating the virtual gateway. These are virtual gateway's service backends client policy defaults.
 * <p>
 * <h2>Adding a Gateway Route</h2>
 * <p>
 * A <em>gateway route</em> is attached to a virtual gateway and routes traffic to an existing virtual service.
 * If a route matches a request, it can distribute traffic to a target virtual service.
 * <p>
 * For HTTP based routes, the match field can be used to match on a route prefix.
 * By default, an HTTP based route will match on <code>/</code>. All matches must start with a leading <code>/</code>.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * gateway.addGatewayRoute("gateway-route-http", Map.of(
 *         "routeSpec", appmesh.GatewayRouteSpec.http(Map.of(
 *                 "routeTarget", virtualService,
 *                 "match", Map.of(
 *                         "prefixMatch", "/")))));
 * </pre></blockquote>
 * <p>
 * For GRPC based routes, the match field can be used to match on service names.
 * You cannot omit the field, and must specify a match for these routes.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * gateway.addGatewayRoute("gateway-route-grpc", Map.of(
 *         "routeSpec", appmesh.GatewayRouteSpec.grpc(Map.of(
 *                 "routeTarget", virtualService,
 *                 "match", Map.of(
 *                         "serviceName", "my-service.default.svc.cluster.local")))));
 * </pre></blockquote>
 * <p>
 * <h2>Importing Resources</h2>
 * <p>
 * Each mesh resource comes with two static methods for importing a reference to an existing App Mesh resource.
 * These imported resources can be used as references for other resources in your mesh.
 * There are two static methods, <code>from&lt;Resource&gt;Arn</code> and <code>from&lt;Resource&gt;Attributes</code> where the <code>&lt;Resource&gt;</code> is replaced with the resource name.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * String arn = "arn:aws:appmesh:us-east-1:123456789012:mesh/testMesh/virtualNode/testNode";
 * appmesh.VirtualNode.fromVirtualNodeArn(stack, "importedVirtualNode", arn);
 * </pre></blockquote>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * appmesh.VirtualNode.fromVirtualNodeAttributes(stack, "imported-virtual-node", Map.of(
 *         "mesh", appmesh.Mesh.fromMeshName(stack, "Mesh", "testMesh"),
 *         "virtualNodeName", virtualNodeName));
 * </pre></blockquote>
 * <p>
 * To import a mesh, there are two static methods, <code>fromMeshArn</code> and <code>fromMeshName</code>.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * String arn = "arn:aws:appmesh:us-east-1:123456789012:mesh/testMesh";
 * appmesh.Mesh.fromMeshArn(stack, "imported-mesh", arn);
 * </pre></blockquote>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * appmesh.Mesh.fromMeshName(stack, "imported-mesh", "abc");
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.appmesh;
