/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apprunner.alpha;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.apprunner.alpha.;
import software.amazon.awscdk.services.apprunner.alpha.Cpu;
import software.amazon.awscdk.services.apprunner.alpha.HealthCheck;
import software.amazon.awscdk.services.apprunner.alpha.IAutoScalingConfiguration;
import software.amazon.awscdk.services.apprunner.alpha.IObservabilityConfiguration;
import software.amazon.awscdk.services.apprunner.alpha.IService;
import software.amazon.awscdk.services.apprunner.alpha.IVpcConnector;
import software.amazon.awscdk.services.apprunner.alpha.IpAddressType;
import software.amazon.awscdk.services.apprunner.alpha.Memory;
import software.amazon.awscdk.services.apprunner.alpha.Secret;
import software.amazon.awscdk.services.apprunner.alpha.ServiceAttributes;
import software.amazon.awscdk.services.apprunner.alpha.ServiceProps;
import software.amazon.awscdk.services.apprunner.alpha.Source;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-apprunner-alpha.Service")
public class Service
extends Resource
implements IGrantable {
    protected Service(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Service(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Service(@NotNull Construct scope, @NotNull String id, @NotNull ServiceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IService fromServiceAttributes(@NotNull Construct scope, @NotNull String id, @NotNull ServiceAttributes attrs) {
        return (IService)JsiiObject.jsiiStaticCall(Service.class, (String)"fromServiceAttributes", (NativeType)NativeType.forClass(IService.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IService fromServiceName(@NotNull Construct scope, @NotNull String id, @NotNull String serviceName) {
        return (IService)JsiiObject.jsiiStaticCall(Service.class, (String)"fromServiceName", (NativeType)NativeType.forClass(IService.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(serviceName, "serviceName is required")});
    }

    public void addEnvironmentVariable(@NotNull String name, @NotNull String value) {
        Kernel.call((Object)((Object)this), (String)"addEnvironmentVariable", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), Objects.requireNonNull(value, "value is required")});
    }

    public void addSecret(@NotNull String name, @NotNull Secret secret) {
        Kernel.call((Object)((Object)this), (String)"addSecret", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), Objects.requireNonNull(secret, "secret is required")});
    }

    public void addToRolePolicy(@NotNull PolicyStatement statement) {
        Kernel.call((Object)((Object)this), (String)"addToRolePolicy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Deprecated
    @NotNull
    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"environment", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)Kernel.get((Object)((Object)this), (String)"grantPrincipal", (NativeType)NativeType.forClass(IPrincipal.class));
    }

    @NotNull
    public String getServiceArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"serviceArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getServiceId() {
        return (String)Kernel.get((Object)((Object)this), (String)"serviceId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getServiceName() {
        return (String)Kernel.get((Object)((Object)this), (String)"serviceName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getServiceStatus() {
        return (String)Kernel.get((Object)((Object)this), (String)"serviceStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getServiceUrl() {
        return (String)Kernel.get((Object)((Object)this), (String)"serviceUrl", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Service> {
        private final Construct scope;
        private final String id;
        private final ServiceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ServiceProps.Builder();
        }

        public Builder source(Source source) {
            this.props.source(source);
            return this;
        }

        public Builder accessRole(IRole accessRole) {
            this.props.accessRole(accessRole);
            return this;
        }

        public Builder autoDeploymentsEnabled(Boolean autoDeploymentsEnabled) {
            this.props.autoDeploymentsEnabled(autoDeploymentsEnabled);
            return this;
        }

        public Builder autoScalingConfiguration(IAutoScalingConfiguration autoScalingConfiguration) {
            this.props.autoScalingConfiguration(autoScalingConfiguration);
            return this;
        }

        public Builder cpu(Cpu cpu) {
            this.props.cpu(cpu);
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        public Builder instanceRole(IRole instanceRole) {
            this.props.instanceRole(instanceRole);
            return this;
        }

        public Builder ipAddressType(IpAddressType ipAddressType) {
            this.props.ipAddressType(ipAddressType);
            return this;
        }

        public Builder isPubliclyAccessible(Boolean isPubliclyAccessible) {
            this.props.isPubliclyAccessible(isPubliclyAccessible);
            return this;
        }

        public Builder kmsKey(IKey kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        public Builder memory(Memory memory) {
            this.props.memory(memory);
            return this;
        }

        public Builder observabilityConfiguration(IObservabilityConfiguration observabilityConfiguration) {
            this.props.observabilityConfiguration(observabilityConfiguration);
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.props.serviceName(serviceName);
            return this;
        }

        public Builder vpcConnector(IVpcConnector vpcConnector) {
            this.props.vpcConnector(vpcConnector);
            return this;
        }

        public Service build() {
            return new Service(this.scope, this.id, this.props.build());
        }
    }
}

