package software.amazon.awscdk.services.autoscaling.common;

/**
 * A range of metric values in which to apply a certain scaling operation.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-24T10:14:42.568Z")
public interface ScalingInterval extends software.amazon.jsii.JsiiSerializable {
    /**
     * The capacity adjustment to apply in this interval.
     * 
     * The number is interpreted differently based on AdjustmentType:
     * 
     * - ChangeInCapacity: add the adjustment to the current capacity.
     *   The number can be positive or negative.
     * - PercentChangeInCapacity: add or remove the given percentage of the current
     *    capacity to itself. The number can be in the range [-100..100].
     * - ExactCapacity: set the capacity to this number. The number must
     *    be positive.
     */
    java.lang.Number getChange();
    /**
     * The lower bound of the interval.
     * 
     * The scaling adjustment will be applied if the metric is higher than this value.
     * 
     * Default: Threshold automatically derived from neighbouring intervals
     */
    java.lang.Number getLower();
    /**
     * The upper bound of the interval.
     * 
     * The scaling adjustment will be applied if the metric is lower than this value.
     * 
     * Default: Threshold automatically derived from neighbouring intervals
     */
    java.lang.Number getUpper();

    /**
     * @return a {@link Builder} of {@link ScalingInterval}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ScalingInterval}
     */
    final class Builder {
        private java.lang.Number _change;
        @javax.annotation.Nullable
        private java.lang.Number _lower;
        @javax.annotation.Nullable
        private java.lang.Number _upper;

        /**
         * Sets the value of Change
         * @param value The capacity adjustment to apply in this interval.
         * @return {@code this}
         */
        public Builder withChange(final java.lang.Number value) {
            this._change = java.util.Objects.requireNonNull(value, "change is required");
            return this;
        }
        /**
         * Sets the value of Lower
         * @param value The lower bound of the interval.
         * @return {@code this}
         */
        public Builder withLower(@javax.annotation.Nullable final java.lang.Number value) {
            this._lower = value;
            return this;
        }
        /**
         * Sets the value of Upper
         * @param value The upper bound of the interval.
         * @return {@code this}
         */
        public Builder withUpper(@javax.annotation.Nullable final java.lang.Number value) {
            this._upper = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScalingInterval}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ScalingInterval build() {
            return new ScalingInterval() {
                private final java.lang.Number $change = java.util.Objects.requireNonNull(_change, "change is required");
                @javax.annotation.Nullable
                private final java.lang.Number $lower = _lower;
                @javax.annotation.Nullable
                private final java.lang.Number $upper = _upper;

                @Override
                public java.lang.Number getChange() {
                    return this.$change;
                }

                @Override
                public java.lang.Number getLower() {
                    return this.$lower;
                }

                @Override
                public java.lang.Number getUpper() {
                    return this.$upper;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("change", om.valueToTree(this.getChange()));
                    obj.set("lower", om.valueToTree(this.getLower()));
                    obj.set("upper", om.valueToTree(this.getUpper()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.autoscaling.common.ScalingInterval {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The capacity adjustment to apply in this interval.
         * 
         * The number is interpreted differently based on AdjustmentType:
         * 
         * - ChangeInCapacity: add the adjustment to the current capacity.
         *   The number can be positive or negative.
         * - PercentChangeInCapacity: add or remove the given percentage of the current
         *    capacity to itself. The number can be in the range [-100..100].
         * - ExactCapacity: set the capacity to this number. The number must
         *    be positive.
         */
        @Override
        public java.lang.Number getChange() {
            return this.jsiiGet("change", java.lang.Number.class);
        }

        /**
         * The lower bound of the interval.
         * 
         * The scaling adjustment will be applied if the metric is higher than this value.
         * 
         * Default: Threshold automatically derived from neighbouring intervals
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getLower() {
            return this.jsiiGet("lower", java.lang.Number.class);
        }

        /**
         * The upper bound of the interval.
         * 
         * The scaling adjustment will be applied if the metric is lower than this value.
         * 
         * Default: Threshold automatically derived from neighbouring intervals
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getUpper() {
            return this.jsiiGet("upper", java.lang.Number.class);
        }
    }
}
