package software.amazon.awscdk.services.autoscaling.common;

/**
 * A range of metric values in which to apply a certain scaling operation.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-27T17:26:48.606Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ScalingInterval extends software.amazon.jsii.JsiiSerializable {
    /**
     * The capacity adjustment to apply in this interval.
     * 
     * The number is interpreted differently based on AdjustmentType:
     * 
     * - ChangeInCapacity: add the adjustment to the current capacity.
     *   The number can be positive or negative.
     * - PercentChangeInCapacity: add or remove the given percentage of the current
     *    capacity to itself. The number can be in the range [-100..100].
     * - ExactCapacity: set the capacity to this number. The number must
     *    be positive.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getChange();

    /**
     * The lower bound of the interval.
     * 
     * The scaling adjustment will be applied if the metric is higher than this value.
     * 
     * Default: Threshold automatically derived from neighbouring intervals
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getLower();

    /**
     * The upper bound of the interval.
     * 
     * The scaling adjustment will be applied if the metric is lower than this value.
     * 
     * Default: Threshold automatically derived from neighbouring intervals
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getUpper();

    /**
     * @return a {@link Builder} of {@link ScalingInterval}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ScalingInterval}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private java.lang.Number change;
        private java.lang.Number lower;
        private java.lang.Number upper;

        /**
         * Sets the value of Change
         * @param change The capacity adjustment to apply in this interval.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder change(java.lang.Number change) {
            this.change = change;
            return this;
        }

        /**
         * Sets the value of Lower
         * @param lower The lower bound of the interval.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lower(java.lang.Number lower) {
            this.lower = lower;
            return this;
        }

        /**
         * Sets the value of Upper
         * @param upper The upper bound of the interval.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder upper(java.lang.Number upper) {
            this.upper = upper;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScalingInterval}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public ScalingInterval build() {
            return new Jsii$Proxy(change, lower, upper);
        }

    }

    /**
     * An implementation for {@link ScalingInterval}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingInterval {
        private final java.lang.Number change;
        private final java.lang.Number lower;
        private final java.lang.Number upper;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.change = this.jsiiGet("change", java.lang.Number.class);
            this.lower = this.jsiiGet("lower", java.lang.Number.class);
            this.upper = this.jsiiGet("upper", java.lang.Number.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Number change, java.lang.Number lower, java.lang.Number upper) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.change = java.util.Objects.requireNonNull(change, "change is required");
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public java.lang.Number getChange() {
            return this.change;
        }

        @Override
        public java.lang.Number getLower() {
            return this.lower;
        }

        @Override
        public java.lang.Number getUpper() {
            return this.upper;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("change", om.valueToTree(this.getChange()));
            if (this.getLower() != null) {
                obj.set("lower", om.valueToTree(this.getLower()));
            }
            if (this.getUpper() != null) {
                obj.set("upper", om.valueToTree(this.getUpper()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScalingInterval.Jsii$Proxy that = (ScalingInterval.Jsii$Proxy) o;

            if (!change.equals(that.change)) return false;
            if (this.lower != null ? !this.lower.equals(that.lower) : that.lower != null) return false;
            return this.upper != null ? this.upper.equals(that.upper) : that.upper == null;
        }

        @Override
        public int hashCode() {
            int result = this.change.hashCode();
            result = 31 * result + (this.lower != null ? this.lower.hashCode() : 0);
            result = 31 * result + (this.upper != null ? this.upper.hashCode() : 0);
            return result;
        }

    }
}
