package software.amazon.awscdk.services.autoscaling.common;

/**
 * (experimental) A range of metric values in which to apply a certain scaling operation.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-17T00:03:55.564Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscaling.common.$Module.class, fqn = "@aws-cdk/aws-autoscaling-common.ScalingInterval")
@software.amazon.jsii.Jsii.Proxy(ScalingInterval.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ScalingInterval extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The capacity adjustment to apply in this interval.
     * <p>
     * The number is interpreted differently based on AdjustmentType:
     * <p>
     * <ul>
     * <li>ChangeInCapacity: add the adjustment to the current capacity.
     * The number can be positive or negative.</li>
     * <li>PercentChangeInCapacity: add or remove the given percentage of the current
     * capacity to itself. The number can be in the range [-100..100].</li>
     * <li>ExactCapacity: set the capacity to this number. The number must
     * be positive.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Number getChange();

    /**
     * (experimental) The lower bound of the interval.
     * <p>
     * The scaling adjustment will be applied if the metric is higher than this value.
     * <p>
     * Default: Threshold automatically derived from neighbouring intervals
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getLower() {
        return null;
    }

    /**
     * (experimental) The upper bound of the interval.
     * <p>
     * The scaling adjustment will be applied if the metric is lower than this value.
     * <p>
     * Default: Threshold automatically derived from neighbouring intervals
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getUpper() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ScalingInterval}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScalingInterval}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ScalingInterval> {
        private java.lang.Number change;
        private java.lang.Number lower;
        private java.lang.Number upper;

        /**
         * Sets the value of {@link ScalingInterval#getChange}
         * @param change The capacity adjustment to apply in this interval. This parameter is required.
         *               The number is interpreted differently based on AdjustmentType:
         *               <p>
         *               <ul>
         *               <li>ChangeInCapacity: add the adjustment to the current capacity.
         *               The number can be positive or negative.</li>
         *               <li>PercentChangeInCapacity: add or remove the given percentage of the current
         *               capacity to itself. The number can be in the range [-100..100].</li>
         *               <li>ExactCapacity: set the capacity to this number. The number must
         *               be positive.</li>
         *               </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder change(java.lang.Number change) {
            this.change = change;
            return this;
        }

        /**
         * Sets the value of {@link ScalingInterval#getLower}
         * @param lower The lower bound of the interval.
         *              The scaling adjustment will be applied if the metric is higher than this value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lower(java.lang.Number lower) {
            this.lower = lower;
            return this;
        }

        /**
         * Sets the value of {@link ScalingInterval#getUpper}
         * @param upper The upper bound of the interval.
         *              The scaling adjustment will be applied if the metric is lower than this value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder upper(java.lang.Number upper) {
            this.upper = upper;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScalingInterval}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ScalingInterval build() {
            return new Jsii$Proxy(change, lower, upper);
        }
    }

    /**
     * An implementation for {@link ScalingInterval}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingInterval {
        private final java.lang.Number change;
        private final java.lang.Number lower;
        private final java.lang.Number upper;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.change = software.amazon.jsii.Kernel.get(this, "change", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.lower = software.amazon.jsii.Kernel.get(this, "lower", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.upper = software.amazon.jsii.Kernel.get(this, "upper", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Number change, final java.lang.Number lower, final java.lang.Number upper) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.change = java.util.Objects.requireNonNull(change, "change is required");
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public final java.lang.Number getChange() {
            return this.change;
        }

        @Override
        public final java.lang.Number getLower() {
            return this.lower;
        }

        @Override
        public final java.lang.Number getUpper() {
            return this.upper;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("change", om.valueToTree(this.getChange()));
            if (this.getLower() != null) {
                data.set("lower", om.valueToTree(this.getLower()));
            }
            if (this.getUpper() != null) {
                data.set("upper", om.valueToTree(this.getUpper()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-autoscaling-common.ScalingInterval"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScalingInterval.Jsii$Proxy that = (ScalingInterval.Jsii$Proxy) o;

            if (!change.equals(that.change)) return false;
            if (this.lower != null ? !this.lower.equals(that.lower) : that.lower != null) return false;
            return this.upper != null ? this.upper.equals(that.upper) : that.upper == null;
        }

        @Override
        public final int hashCode() {
            int result = this.change.hashCode();
            result = 31 * result + (this.lower != null ? this.lower.hashCode() : 0);
            result = 31 * result + (this.upper != null ? this.upper.hashCode() : 0);
            return result;
        }
    }
}
