package software.amazon.awscdk.services.autoscaling;

/**
 * (deprecated) Additional settings when a rolling update is selected.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * import software.amazon.awscdk.core.*;
 * RollingUpdateConfiguration rollingUpdateConfiguration = RollingUpdateConfiguration.builder()
 *         .maxBatchSize(123)
 *         .minInstancesInService(123)
 *         .minSuccessfulInstancesPercent(123)
 *         .pauseTime(Duration.minutes(30))
 *         .suspendProcesses(List.of(ScalingProcess.LAUNCH))
 *         .waitOnResourceSignals(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @deprecated use `UpdatePolicy.rollingUpdate()`
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:45.710Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscaling.$Module.class, fqn = "@aws-cdk/aws-autoscaling.RollingUpdateConfiguration")
@software.amazon.jsii.Jsii.Proxy(RollingUpdateConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
@Deprecated
public interface RollingUpdateConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * (deprecated) The maximum number of instances that AWS CloudFormation updates at once.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxBatchSize() {
        return null;
    }

    /**
     * (deprecated) The minimum number of instances that must be in service before more instances are replaced.
     * <p>
     * This number affects the speed of the replacement.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinInstancesInService() {
        return null;
    }

    /**
     * (deprecated) The percentage of instances that must signal success for an update to succeed.
     * <p>
     * If an instance doesn't send a signal within the time specified in the
     * pauseTime property, AWS CloudFormation assumes that the instance wasn't
     * updated.
     * <p>
     * This number affects the success of the replacement.
     * <p>
     * If you specify this property, you must also enable the
     * waitOnResourceSignals and pauseTime properties.
     * <p>
     * Default: 100
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinSuccessfulInstancesPercent() {
        return null;
    }

    /**
     * (deprecated) The pause time after making a change to a batch of instances.
     * <p>
     * This is intended to give those instances time to start software applications.
     * <p>
     * Specify PauseTime in the ISO8601 duration format (in the format
     * PT#H#M#S, where each # is the number of hours, minutes, and seconds,
     * respectively). The maximum PauseTime is one hour (PT1H).
     * <p>
     * Default: Duration.minutes(5) if the waitOnResourceSignals property is true, otherwise 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getPauseTime() {
        return null;
    }

    /**
     * (deprecated) Specifies the Auto Scaling processes to suspend during a stack update.
     * <p>
     * Suspending processes prevents Auto Scaling from interfering with a stack
     * update.
     * <p>
     * Default: HealthCheck, ReplaceUnhealthy, AZRebalance, AlarmNotification, ScheduledActions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.autoscaling.ScalingProcess> getSuspendProcesses() {
        return null;
    }

    /**
     * (deprecated) Specifies whether the Auto Scaling group waits on signals from new instances during an update.
     * <p>
     * AWS CloudFormation must receive a signal from each new instance within
     * the specified PauseTime before continuing the update.
     * <p>
     * To have instances wait for an Elastic Load Balancing health check before
     * they signal success, add a health-check verification by using the
     * cfn-init helper script. For an example, see the verify_instance_health
     * command in the Auto Scaling rolling updates sample template.
     * <p>
     * Default: true if you specified the minSuccessfulInstancesPercent property, false otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getWaitOnResourceSignals() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RollingUpdateConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RollingUpdateConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static final class Builder implements software.amazon.jsii.Builder<RollingUpdateConfiguration> {
        java.lang.Number maxBatchSize;
        java.lang.Number minInstancesInService;
        java.lang.Number minSuccessfulInstancesPercent;
        software.amazon.awscdk.core.Duration pauseTime;
        java.util.List<software.amazon.awscdk.services.autoscaling.ScalingProcess> suspendProcesses;
        java.lang.Boolean waitOnResourceSignals;

        /**
         * Sets the value of {@link RollingUpdateConfiguration#getMaxBatchSize}
         * @param maxBatchSize The maximum number of instances that AWS CloudFormation updates at once.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder maxBatchSize(java.lang.Number maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        /**
         * Sets the value of {@link RollingUpdateConfiguration#getMinInstancesInService}
         * @param minInstancesInService The minimum number of instances that must be in service before more instances are replaced.
         *                              This number affects the speed of the replacement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder minInstancesInService(java.lang.Number minInstancesInService) {
            this.minInstancesInService = minInstancesInService;
            return this;
        }

        /**
         * Sets the value of {@link RollingUpdateConfiguration#getMinSuccessfulInstancesPercent}
         * @param minSuccessfulInstancesPercent The percentage of instances that must signal success for an update to succeed.
         *                                      If an instance doesn't send a signal within the time specified in the
         *                                      pauseTime property, AWS CloudFormation assumes that the instance wasn't
         *                                      updated.
         *                                      <p>
         *                                      This number affects the success of the replacement.
         *                                      <p>
         *                                      If you specify this property, you must also enable the
         *                                      waitOnResourceSignals and pauseTime properties.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder minSuccessfulInstancesPercent(java.lang.Number minSuccessfulInstancesPercent) {
            this.minSuccessfulInstancesPercent = minSuccessfulInstancesPercent;
            return this;
        }

        /**
         * Sets the value of {@link RollingUpdateConfiguration#getPauseTime}
         * @param pauseTime The pause time after making a change to a batch of instances.
         *                  This is intended to give those instances time to start software applications.
         *                  <p>
         *                  Specify PauseTime in the ISO8601 duration format (in the format
         *                  PT#H#M#S, where each # is the number of hours, minutes, and seconds,
         *                  respectively). The maximum PauseTime is one hour (PT1H).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pauseTime(software.amazon.awscdk.core.Duration pauseTime) {
            this.pauseTime = pauseTime;
            return this;
        }

        /**
         * Sets the value of {@link RollingUpdateConfiguration#getSuspendProcesses}
         * @param suspendProcesses Specifies the Auto Scaling processes to suspend during a stack update.
         *                         Suspending processes prevents Auto Scaling from interfering with a stack
         *                         update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        @SuppressWarnings("unchecked")
        public Builder suspendProcesses(java.util.List<? extends software.amazon.awscdk.services.autoscaling.ScalingProcess> suspendProcesses) {
            this.suspendProcesses = (java.util.List<software.amazon.awscdk.services.autoscaling.ScalingProcess>)suspendProcesses;
            return this;
        }

        /**
         * Sets the value of {@link RollingUpdateConfiguration#getWaitOnResourceSignals}
         * @param waitOnResourceSignals Specifies whether the Auto Scaling group waits on signals from new instances during an update.
         *                              AWS CloudFormation must receive a signal from each new instance within
         *                              the specified PauseTime before continuing the update.
         *                              <p>
         *                              To have instances wait for an Elastic Load Balancing health check before
         *                              they signal success, add a health-check verification by using the
         *                              cfn-init helper script. For an example, see the verify_instance_health
         *                              command in the Auto Scaling rolling updates sample template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder waitOnResourceSignals(java.lang.Boolean waitOnResourceSignals) {
            this.waitOnResourceSignals = waitOnResourceSignals;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RollingUpdateConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        @Override
        public RollingUpdateConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RollingUpdateConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RollingUpdateConfiguration {
        private final java.lang.Number maxBatchSize;
        private final java.lang.Number minInstancesInService;
        private final java.lang.Number minSuccessfulInstancesPercent;
        private final software.amazon.awscdk.core.Duration pauseTime;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.ScalingProcess> suspendProcesses;
        private final java.lang.Boolean waitOnResourceSignals;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxBatchSize = software.amazon.jsii.Kernel.get(this, "maxBatchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minInstancesInService = software.amazon.jsii.Kernel.get(this, "minInstancesInService", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minSuccessfulInstancesPercent = software.amazon.jsii.Kernel.get(this, "minSuccessfulInstancesPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.pauseTime = software.amazon.jsii.Kernel.get(this, "pauseTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.suspendProcesses = software.amazon.jsii.Kernel.get(this, "suspendProcesses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.ScalingProcess.class)));
            this.waitOnResourceSignals = software.amazon.jsii.Kernel.get(this, "waitOnResourceSignals", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxBatchSize = builder.maxBatchSize;
            this.minInstancesInService = builder.minInstancesInService;
            this.minSuccessfulInstancesPercent = builder.minSuccessfulInstancesPercent;
            this.pauseTime = builder.pauseTime;
            this.suspendProcesses = (java.util.List<software.amazon.awscdk.services.autoscaling.ScalingProcess>)builder.suspendProcesses;
            this.waitOnResourceSignals = builder.waitOnResourceSignals;
        }

        @Override
        public final java.lang.Number getMaxBatchSize() {
            return this.maxBatchSize;
        }

        @Override
        public final java.lang.Number getMinInstancesInService() {
            return this.minInstancesInService;
        }

        @Override
        public final java.lang.Number getMinSuccessfulInstancesPercent() {
            return this.minSuccessfulInstancesPercent;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getPauseTime() {
            return this.pauseTime;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.ScalingProcess> getSuspendProcesses() {
            return this.suspendProcesses;
        }

        @Override
        public final java.lang.Boolean getWaitOnResourceSignals() {
            return this.waitOnResourceSignals;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMaxBatchSize() != null) {
                data.set("maxBatchSize", om.valueToTree(this.getMaxBatchSize()));
            }
            if (this.getMinInstancesInService() != null) {
                data.set("minInstancesInService", om.valueToTree(this.getMinInstancesInService()));
            }
            if (this.getMinSuccessfulInstancesPercent() != null) {
                data.set("minSuccessfulInstancesPercent", om.valueToTree(this.getMinSuccessfulInstancesPercent()));
            }
            if (this.getPauseTime() != null) {
                data.set("pauseTime", om.valueToTree(this.getPauseTime()));
            }
            if (this.getSuspendProcesses() != null) {
                data.set("suspendProcesses", om.valueToTree(this.getSuspendProcesses()));
            }
            if (this.getWaitOnResourceSignals() != null) {
                data.set("waitOnResourceSignals", om.valueToTree(this.getWaitOnResourceSignals()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-autoscaling.RollingUpdateConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RollingUpdateConfiguration.Jsii$Proxy that = (RollingUpdateConfiguration.Jsii$Proxy) o;

            if (this.maxBatchSize != null ? !this.maxBatchSize.equals(that.maxBatchSize) : that.maxBatchSize != null) return false;
            if (this.minInstancesInService != null ? !this.minInstancesInService.equals(that.minInstancesInService) : that.minInstancesInService != null) return false;
            if (this.minSuccessfulInstancesPercent != null ? !this.minSuccessfulInstancesPercent.equals(that.minSuccessfulInstancesPercent) : that.minSuccessfulInstancesPercent != null) return false;
            if (this.pauseTime != null ? !this.pauseTime.equals(that.pauseTime) : that.pauseTime != null) return false;
            if (this.suspendProcesses != null ? !this.suspendProcesses.equals(that.suspendProcesses) : that.suspendProcesses != null) return false;
            return this.waitOnResourceSignals != null ? this.waitOnResourceSignals.equals(that.waitOnResourceSignals) : that.waitOnResourceSignals == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxBatchSize != null ? this.maxBatchSize.hashCode() : 0;
            result = 31 * result + (this.minInstancesInService != null ? this.minInstancesInService.hashCode() : 0);
            result = 31 * result + (this.minSuccessfulInstancesPercent != null ? this.minSuccessfulInstancesPercent.hashCode() : 0);
            result = 31 * result + (this.pauseTime != null ? this.pauseTime.hashCode() : 0);
            result = 31 * result + (this.suspendProcesses != null ? this.suspendProcesses.hashCode() : 0);
            result = 31 * result + (this.waitOnResourceSignals != null ? this.waitOnResourceSignals.hashCode() : 0);
            return result;
        }
    }
}
