package software.amazon.awscdk.services.autoscaling;

/**
 * Define a acaling strategy which scales depending on absolute values of some metric.
 * <p>
 * You can specify the scaling behavior for various values of the metric.
 * <p>
 * Implemented using one or more CloudWatch alarms and Step Scaling Policies.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * import software.amazon.awscdk.services.cloudwatch.*;
 * import software.amazon.awscdk.core.*;
 * AutoScalingGroup autoScalingGroup;
 * Metric metric;
 * StepScalingPolicy stepScalingPolicy = StepScalingPolicy.Builder.create(this, "MyStepScalingPolicy")
 *         .autoScalingGroup(autoScalingGroup)
 *         .metric(metric)
 *         .scalingSteps(List.of(ScalingInterval.builder()
 *                 .change(123)
 *                 // the properties below are optional
 *                 .lower(123)
 *                 .upper(123)
 *                 .build()))
 *         // the properties below are optional
 *         .adjustmentType(AdjustmentType.CHANGE_IN_CAPACITY)
 *         .cooldown(Duration.minutes(30))
 *         .estimatedInstanceWarmup(Duration.minutes(30))
 *         .evaluationPeriods(123)
 *         .metricAggregationType(MetricAggregationType.AVERAGE)
 *         .minAdjustmentMagnitude(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.84.0 (build 5404dcf)", date = "2023-06-19T16:30:45.418Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscaling.$Module.class, fqn = "@aws-cdk/aws-autoscaling.StepScalingPolicy")
public class StepScalingPolicy extends software.amazon.awscdk.core.Construct {

    protected StepScalingPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StepScalingPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public StepScalingPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.StepScalingPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.StepScalingAction getLowerAction() {
        return software.amazon.jsii.Kernel.get(this, "lowerAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.StepScalingAction.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.Alarm getLowerAlarm() {
        return software.amazon.jsii.Kernel.get(this, "lowerAlarm", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Alarm.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.StepScalingAction getUpperAction() {
        return software.amazon.jsii.Kernel.get(this, "upperAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.StepScalingAction.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.Alarm getUpperAlarm() {
        return software.amazon.jsii.Kernel.get(this, "upperAlarm", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Alarm.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.autoscaling.StepScalingPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.autoscaling.StepScalingPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.autoscaling.StepScalingPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.autoscaling.StepScalingPolicyProps.Builder();
        }

        /**
         * Metric to scale on.
         * <p>
         * @return {@code this}
         * @param metric Metric to scale on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metric(final software.amazon.awscdk.services.cloudwatch.IMetric metric) {
            this.props.metric(metric);
            return this;
        }

        /**
         * The intervals for scaling.
         * <p>
         * Maps a range of metric values to a particular scaling behavior.
         * <p>
         * @return {@code this}
         * @param scalingSteps The intervals for scaling. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingSteps(final java.util.List<? extends software.amazon.awscdk.services.autoscaling.ScalingInterval> scalingSteps) {
            this.props.scalingSteps(scalingSteps);
            return this;
        }

        /**
         * How the adjustment numbers inside 'intervals' are interpreted.
         * <p>
         * Default: ChangeInCapacity
         * <p>
         * @return {@code this}
         * @param adjustmentType How the adjustment numbers inside 'intervals' are interpreted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adjustmentType(final software.amazon.awscdk.services.autoscaling.AdjustmentType adjustmentType) {
            this.props.adjustmentType(adjustmentType);
            return this;
        }

        /**
         * Grace period after scaling activity.
         * <p>
         * Default: Default cooldown period on your AutoScalingGroup
         * <p>
         * @return {@code this}
         * @param cooldown Grace period after scaling activity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldown(final software.amazon.awscdk.core.Duration cooldown) {
            this.props.cooldown(cooldown);
            return this;
        }

        /**
         * Estimated time until a newly launched instance can send metrics to CloudWatch.
         * <p>
         * Default: Same as the cooldown
         * <p>
         * @return {@code this}
         * @param estimatedInstanceWarmup Estimated time until a newly launched instance can send metrics to CloudWatch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder estimatedInstanceWarmup(final software.amazon.awscdk.core.Duration estimatedInstanceWarmup) {
            this.props.estimatedInstanceWarmup(estimatedInstanceWarmup);
            return this;
        }

        /**
         * How many evaluation periods of the metric to wait before triggering a scaling action.
         * <p>
         * Raising this value can be used to smooth out the metric, at the expense
         * of slower response times.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param evaluationPeriods How many evaluation periods of the metric to wait before triggering a scaling action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationPeriods(final java.lang.Number evaluationPeriods) {
            this.props.evaluationPeriods(evaluationPeriods);
            return this;
        }

        /**
         * Aggregation to apply to all data points over the evaluation periods.
         * <p>
         * Only has meaning if <code>evaluationPeriods != 1</code>.
         * <p>
         * Default: - The statistic from the metric if applicable (MIN, MAX, AVERAGE), otherwise AVERAGE.
         * <p>
         * @return {@code this}
         * @param metricAggregationType Aggregation to apply to all data points over the evaluation periods. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricAggregationType(final software.amazon.awscdk.services.autoscaling.MetricAggregationType metricAggregationType) {
            this.props.metricAggregationType(metricAggregationType);
            return this;
        }

        /**
         * Minimum absolute number to adjust capacity with as result of percentage scaling.
         * <p>
         * Only when using AdjustmentType = PercentChangeInCapacity, this number controls
         * the minimum absolute effect size.
         * <p>
         * Default: No minimum scaling effect
         * <p>
         * @return {@code this}
         * @param minAdjustmentMagnitude Minimum absolute number to adjust capacity with as result of percentage scaling. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minAdjustmentMagnitude(final java.lang.Number minAdjustmentMagnitude) {
            this.props.minAdjustmentMagnitude(minAdjustmentMagnitude);
            return this;
        }

        /**
         * The auto scaling group.
         * <p>
         * @return {@code this}
         * @param autoScalingGroup The auto scaling group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroup(final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup) {
            this.props.autoScalingGroup(autoScalingGroup);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.autoscaling.StepScalingPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.autoscaling.StepScalingPolicy build() {
            return new software.amazon.awscdk.services.autoscaling.StepScalingPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
