/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appmesh;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.appmesh.IMesh;
import software.amazon.awscdk.services.appmesh.IRoute;
import software.amazon.awscdk.services.appmesh.IVirtualRouter;
import software.amazon.awscdk.services.appmesh.RouteAttributes;
import software.amazon.awscdk.services.appmesh.RouteProps;
import software.amazon.awscdk.services.appmesh.RouteSpec;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_appmesh.Route")
public class Route
extends Resource
implements IRoute {
    protected Route(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Route(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Route(@NotNull Construct scope, @NotNull String id, @NotNull RouteProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IRoute fromRouteArn(@NotNull Construct scope, @NotNull String id, @NotNull String routeArn) {
        return (IRoute)JsiiObject.jsiiStaticCall(Route.class, (String)"fromRouteArn", (NativeType)NativeType.forClass(IRoute.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(routeArn, "routeArn is required")});
    }

    @NotNull
    public static IRoute fromRouteAttributes(@NotNull Construct scope, @NotNull String id, @NotNull RouteAttributes attrs) {
        return (IRoute)JsiiObject.jsiiStaticCall(Route.class, (String)"fromRouteAttributes", (NativeType)NativeType.forClass(IRoute.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public String getRouteArn() {
        return (String)Kernel.get((Object)this, (String)"routeArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getRouteName() {
        return (String)Kernel.get((Object)this, (String)"routeName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public IVirtualRouter getVirtualRouter() {
        return (IVirtualRouter)Kernel.get((Object)this, (String)"virtualRouter", (NativeType)NativeType.forClass(IVirtualRouter.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Route> {
        private final Construct scope;
        private final String id;
        private final RouteProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new RouteProps.Builder();
        }

        public Builder routeName(String routeName) {
            this.props.routeName(routeName);
            return this;
        }

        public Builder routeSpec(RouteSpec routeSpec) {
            this.props.routeSpec(routeSpec);
            return this;
        }

        public Builder mesh(IMesh mesh) {
            this.props.mesh(mesh);
            return this;
        }

        public Builder virtualRouter(IVirtualRouter virtualRouter) {
            this.props.virtualRouter(virtualRouter);
            return this;
        }

        public Route build() {
            return new Route(this.scope, this.id, this.props.build());
        }
    }
}

