/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codecommit;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.codecommit.CfnRepository;
import software.amazon.awscdk.services.codecommit.CfnRepositoryProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codecommit.CfnRepository")
public class CfnRepository
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnRepository.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnRepository(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRepository(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnRepository(@NotNull Construct scope, @NotNull String id, @NotNull CfnRepositoryProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCloneUrlHttp() {
        return (String)Kernel.get((Object)this, (String)"attrCloneUrlHttp", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCloneUrlSsh() {
        return (String)Kernel.get((Object)this, (String)"attrCloneUrlSsh", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrName() {
        return (String)Kernel.get((Object)this, (String)"attrName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Nullable
    public Object getCode() {
        return Kernel.get((Object)this, (String)"code", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCode(@Nullable CodeProperty value) {
        Kernel.set((Object)this, (String)"code", (Object)value);
    }

    public void setCode(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"code", (Object)value);
    }

    @Nullable
    public String getRepositoryDescription() {
        return (String)Kernel.get((Object)this, (String)"repositoryDescription", (NativeType)NativeType.forClass(String.class));
    }

    public void setRepositoryDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"repositoryDescription", (Object)value);
    }

    @NotNull
    public String getRepositoryName() {
        return (String)Kernel.get((Object)this, (String)"repositoryName", (NativeType)NativeType.forClass(String.class));
    }

    public void setRepositoryName(@NotNull String value) {
        Kernel.set((Object)this, (String)"repositoryName", (Object)Objects.requireNonNull(value, "repositoryName is required"));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Nullable
    public Object getTriggers() {
        return Kernel.get((Object)this, (String)"triggers", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTriggers(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"triggers", (Object)value);
    }

    public void setTriggers(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"triggers", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnRepository> {
        private final Construct scope;
        private final String id;
        private final CfnRepositoryProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnRepositoryProps.Builder();
        }

        public Builder code(CodeProperty code) {
            this.props.code(code);
            return this;
        }

        public Builder code(IResolvable code) {
            this.props.code(code);
            return this;
        }

        public Builder repositoryDescription(String repositoryDescription) {
            this.props.repositoryDescription(repositoryDescription);
            return this;
        }

        public Builder repositoryName(String repositoryName) {
            this.props.repositoryName(repositoryName);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder triggers(IResolvable triggers) {
            this.props.triggers(triggers);
            return this;
        }

        public Builder triggers(List<? extends Object> triggers) {
            this.props.triggers(triggers);
            return this;
        }

        public CfnRepository build() {
            return new CfnRepository(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codecommit.CfnRepository.S3Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3Property
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public String getKey();

        @Nullable
        default public String getObjectVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3Property> {
            String bucket;
            String key;
            String objectVersion;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder objectVersion(String objectVersion) {
                this.objectVersion = objectVersion;
                return this;
            }

            public S3Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codecommit.CfnRepository.RepositoryTriggerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RepositoryTriggerProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getBranches() {
            return null;
        }

        @Nullable
        default public String getCustomData() {
            return null;
        }

        @NotNull
        public String getDestinationArn();

        @NotNull
        public List<String> getEvents();

        @NotNull
        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RepositoryTriggerProperty> {
            List<String> branches;
            String customData;
            String destinationArn;
            List<String> events;
            String name;

            public Builder branches(List<String> branches) {
                this.branches = branches;
                return this;
            }

            public Builder customData(String customData) {
                this.customData = customData;
                return this;
            }

            public Builder destinationArn(String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            public Builder events(List<String> events) {
                this.events = events;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public RepositoryTriggerProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codecommit.CfnRepository.CodeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CodeProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBranchName() {
            return null;
        }

        @NotNull
        public Object getS3();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CodeProperty> {
            String branchName;
            Object s3;

            public Builder branchName(String branchName) {
                this.branchName = branchName;
                return this;
            }

            public Builder s3(S3Property s3) {
                this.s3 = s3;
                return this;
            }

            public Builder s3(IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            public CodeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

