/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.glue;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.glue.CfnMLTransform;
import software.amazon.awscdk.services.glue.CfnMLTransformProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_glue.CfnMLTransform")
public class CfnMLTransform
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnMLTransform.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnMLTransform(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMLTransform(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnMLTransform(@NotNull Construct scope, @NotNull String id, @NotNull CfnMLTransformProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public String getGlueVersion() {
        return (String)Kernel.get((Object)this, (String)"glueVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setGlueVersion(@Nullable String value) {
        Kernel.set((Object)this, (String)"glueVersion", (Object)value);
    }

    @NotNull
    public Object getInputRecordTables() {
        return Kernel.get((Object)this, (String)"inputRecordTables", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInputRecordTables(@NotNull InputRecordTablesProperty value) {
        Kernel.set((Object)this, (String)"inputRecordTables", (Object)Objects.requireNonNull(value, "inputRecordTables is required"));
    }

    public void setInputRecordTables(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"inputRecordTables", (Object)Objects.requireNonNull(value, "inputRecordTables is required"));
    }

    @Nullable
    public Number getMaxCapacity() {
        return (Number)Kernel.get((Object)this, (String)"maxCapacity", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaxCapacity(@Nullable Number value) {
        Kernel.set((Object)this, (String)"maxCapacity", (Object)value);
    }

    @Nullable
    public Number getMaxRetries() {
        return (Number)Kernel.get((Object)this, (String)"maxRetries", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaxRetries(@Nullable Number value) {
        Kernel.set((Object)this, (String)"maxRetries", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    @Nullable
    public Number getNumberOfWorkers() {
        return (Number)Kernel.get((Object)this, (String)"numberOfWorkers", (NativeType)NativeType.forClass(Number.class));
    }

    public void setNumberOfWorkers(@Nullable Number value) {
        Kernel.set((Object)this, (String)"numberOfWorkers", (Object)value);
    }

    @NotNull
    public String getRole() {
        return (String)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(String.class));
    }

    public void setRole(@NotNull String value) {
        Kernel.set((Object)this, (String)"role", (Object)Objects.requireNonNull(value, "role is required"));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Nullable
    public Number getTimeout() {
        return (Number)Kernel.get((Object)this, (String)"timeout", (NativeType)NativeType.forClass(Number.class));
    }

    public void setTimeout(@Nullable Number value) {
        Kernel.set((Object)this, (String)"timeout", (Object)value);
    }

    @Nullable
    public Object getTransformEncryption() {
        return Kernel.get((Object)this, (String)"transformEncryption", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTransformEncryption(@Nullable TransformEncryptionProperty value) {
        Kernel.set((Object)this, (String)"transformEncryption", (Object)value);
    }

    public void setTransformEncryption(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"transformEncryption", (Object)value);
    }

    @NotNull
    public Object getTransformParameters() {
        return Kernel.get((Object)this, (String)"transformParameters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTransformParameters(@NotNull TransformParametersProperty value) {
        Kernel.set((Object)this, (String)"transformParameters", (Object)Objects.requireNonNull(value, "transformParameters is required"));
    }

    public void setTransformParameters(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"transformParameters", (Object)Objects.requireNonNull(value, "transformParameters is required"));
    }

    @Nullable
    public String getWorkerType() {
        return (String)Kernel.get((Object)this, (String)"workerType", (NativeType)NativeType.forClass(String.class));
    }

    public void setWorkerType(@Nullable String value) {
        Kernel.set((Object)this, (String)"workerType", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnMLTransform> {
        private final Construct scope;
        private final String id;
        private final CfnMLTransformProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnMLTransformProps.Builder();
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder glueVersion(String glueVersion) {
            this.props.glueVersion(glueVersion);
            return this;
        }

        public Builder inputRecordTables(InputRecordTablesProperty inputRecordTables) {
            this.props.inputRecordTables(inputRecordTables);
            return this;
        }

        public Builder inputRecordTables(IResolvable inputRecordTables) {
            this.props.inputRecordTables(inputRecordTables);
            return this;
        }

        public Builder maxCapacity(Number maxCapacity) {
            this.props.maxCapacity(maxCapacity);
            return this;
        }

        public Builder maxRetries(Number maxRetries) {
            this.props.maxRetries(maxRetries);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder numberOfWorkers(Number numberOfWorkers) {
            this.props.numberOfWorkers(numberOfWorkers);
            return this;
        }

        public Builder role(String role) {
            this.props.role(role);
            return this;
        }

        public Builder tags(Object tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder timeout(Number timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder transformEncryption(TransformEncryptionProperty transformEncryption) {
            this.props.transformEncryption(transformEncryption);
            return this;
        }

        public Builder transformEncryption(IResolvable transformEncryption) {
            this.props.transformEncryption(transformEncryption);
            return this;
        }

        public Builder transformParameters(TransformParametersProperty transformParameters) {
            this.props.transformParameters(transformParameters);
            return this;
        }

        public Builder transformParameters(IResolvable transformParameters) {
            this.props.transformParameters(transformParameters);
            return this;
        }

        public Builder workerType(String workerType) {
            this.props.workerType(workerType);
            return this;
        }

        public CfnMLTransform build() {
            return new CfnMLTransform(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_glue.CfnMLTransform.TransformParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TransformParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFindMatchesParameters() {
            return null;
        }

        @NotNull
        public String getTransformType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TransformParametersProperty> {
            Object findMatchesParameters;
            String transformType;

            public Builder findMatchesParameters(FindMatchesParametersProperty findMatchesParameters) {
                this.findMatchesParameters = findMatchesParameters;
                return this;
            }

            public Builder findMatchesParameters(IResolvable findMatchesParameters) {
                this.findMatchesParameters = findMatchesParameters;
                return this;
            }

            public Builder transformType(String transformType) {
                this.transformType = transformType;
                return this;
            }

            public TransformParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_glue.CfnMLTransform.TransformEncryptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TransformEncryptionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getMlUserDataEncryption() {
            return null;
        }

        @Nullable
        default public String getTaskRunSecurityConfigurationName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TransformEncryptionProperty> {
            Object mlUserDataEncryption;
            String taskRunSecurityConfigurationName;

            public Builder mlUserDataEncryption(MLUserDataEncryptionProperty mlUserDataEncryption) {
                this.mlUserDataEncryption = mlUserDataEncryption;
                return this;
            }

            public Builder mlUserDataEncryption(IResolvable mlUserDataEncryption) {
                this.mlUserDataEncryption = mlUserDataEncryption;
                return this;
            }

            public Builder taskRunSecurityConfigurationName(String taskRunSecurityConfigurationName) {
                this.taskRunSecurityConfigurationName = taskRunSecurityConfigurationName;
                return this;
            }

            public TransformEncryptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_glue.CfnMLTransform.MLUserDataEncryptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MLUserDataEncryptionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKmsKeyId() {
            return null;
        }

        @NotNull
        public String getMlUserDataEncryptionMode();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MLUserDataEncryptionProperty> {
            String kmsKeyId;
            String mlUserDataEncryptionMode;

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public Builder mlUserDataEncryptionMode(String mlUserDataEncryptionMode) {
                this.mlUserDataEncryptionMode = mlUserDataEncryptionMode;
                return this;
            }

            public MLUserDataEncryptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_glue.CfnMLTransform.InputRecordTablesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputRecordTablesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getGlueTables() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputRecordTablesProperty> {
            Object glueTables;

            public Builder glueTables(IResolvable glueTables) {
                this.glueTables = glueTables;
                return this;
            }

            public Builder glueTables(List<? extends Object> glueTables) {
                this.glueTables = glueTables;
                return this;
            }

            public InputRecordTablesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_glue.CfnMLTransform.GlueTablesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GlueTablesProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCatalogId() {
            return null;
        }

        @Nullable
        default public String getConnectionName() {
            return null;
        }

        @NotNull
        public String getDatabaseName();

        @NotNull
        public String getTableName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GlueTablesProperty> {
            String catalogId;
            String connectionName;
            String databaseName;
            String tableName;

            public Builder catalogId(String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            public Builder connectionName(String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public GlueTablesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_glue.CfnMLTransform.FindMatchesParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FindMatchesParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getAccuracyCostTradeoff() {
            return null;
        }

        @Nullable
        default public Object getEnforceProvidedLabels() {
            return null;
        }

        @Nullable
        default public Number getPrecisionRecallTradeoff() {
            return null;
        }

        @NotNull
        public String getPrimaryKeyColumnName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FindMatchesParametersProperty> {
            Number accuracyCostTradeoff;
            Object enforceProvidedLabels;
            Number precisionRecallTradeoff;
            String primaryKeyColumnName;

            public Builder accuracyCostTradeoff(Number accuracyCostTradeoff) {
                this.accuracyCostTradeoff = accuracyCostTradeoff;
                return this;
            }

            public Builder enforceProvidedLabels(Boolean enforceProvidedLabels) {
                this.enforceProvidedLabels = enforceProvidedLabels;
                return this;
            }

            public Builder enforceProvidedLabels(IResolvable enforceProvidedLabels) {
                this.enforceProvidedLabels = enforceProvidedLabels;
                return this;
            }

            public Builder precisionRecallTradeoff(Number precisionRecallTradeoff) {
                this.precisionRecallTradeoff = precisionRecallTradeoff;
                return this;
            }

            public Builder primaryKeyColumnName(String primaryKeyColumnName) {
                this.primaryKeyColumnName = primaryKeyColumnName;
                return this;
            }

            public FindMatchesParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

