/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ses;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.ses.IReceiptRule;
import software.amazon.awscdk.services.ses.IReceiptRuleAction;
import software.amazon.awscdk.services.ses.IReceiptRuleSet;
import software.amazon.awscdk.services.ses.ReceiptRuleProps;
import software.amazon.awscdk.services.ses.TlsPolicy;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ses.ReceiptRule")
public class ReceiptRule
extends Resource
implements IReceiptRule {
    protected ReceiptRule(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ReceiptRule(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ReceiptRule(@NotNull Construct scope, @NotNull String id, @NotNull ReceiptRuleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void addAction(@NotNull IReceiptRuleAction action) {
        Kernel.call((Object)this, (String)"addAction", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(action, "action is required")});
    }

    @NotNull
    public static IReceiptRule fromReceiptRuleName(@NotNull Construct scope, @NotNull String id, @NotNull String receiptRuleName) {
        return (IReceiptRule)JsiiObject.jsiiStaticCall(ReceiptRule.class, (String)"fromReceiptRuleName", (NativeType)NativeType.forClass(IReceiptRule.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(receiptRuleName, "receiptRuleName is required")});
    }

    @Override
    @NotNull
    public String getReceiptRuleName() {
        return (String)Kernel.get((Object)this, (String)"receiptRuleName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ReceiptRule> {
        private final Construct scope;
        private final String id;
        private final ReceiptRuleProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ReceiptRuleProps.Builder();
        }

        public Builder actions(List<? extends IReceiptRuleAction> actions) {
            this.props.actions(actions);
            return this;
        }

        public Builder after(IReceiptRule after) {
            this.props.after(after);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        public Builder receiptRuleName(String receiptRuleName) {
            this.props.receiptRuleName(receiptRuleName);
            return this;
        }

        public Builder recipients(List<String> recipients) {
            this.props.recipients(recipients);
            return this;
        }

        public Builder scanEnabled(Boolean scanEnabled) {
            this.props.scanEnabled(scanEnabled);
            return this;
        }

        public Builder tlsPolicy(TlsPolicy tlsPolicy) {
            this.props.tlsPolicy(tlsPolicy);
            return this;
        }

        public Builder ruleSet(IReceiptRuleSet ruleSet) {
            this.props.ruleSet(ruleSet);
            return this;
        }

        public ReceiptRule build() {
            return new ReceiptRule(this.scope, this.id, this.props.build());
        }
    }
}

