/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.ecs.CfnTaskDefinition;
import software.amazon.awscdk.services.ecs.ContainerDefinition;
import software.amazon.awscdk.services.ecs.ContainerImage;
import software.amazon.awscdk.services.ecs.EnvironmentFile;
import software.amazon.awscdk.services.ecs.FirelensConfig;
import software.amazon.awscdk.services.ecs.FirelensLogRouterProps;
import software.amazon.awscdk.services.ecs.HealthCheck;
import software.amazon.awscdk.services.ecs.LinuxParameters;
import software.amazon.awscdk.services.ecs.LogDriver;
import software.amazon.awscdk.services.ecs.PortMapping;
import software.amazon.awscdk.services.ecs.Secret;
import software.amazon.awscdk.services.ecs.SystemControl;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.awscdk.services.ecs.Ulimit;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.FirelensLogRouter")
public class FirelensLogRouter
extends ContainerDefinition {
    protected FirelensLogRouter(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FirelensLogRouter(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public FirelensLogRouter(@NotNull Construct scope, @NotNull String id, @NotNull FirelensLogRouterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public CfnTaskDefinition.ContainerDefinitionProperty renderContainerDefinition(@Nullable TaskDefinition _taskDefinition) {
        return (CfnTaskDefinition.ContainerDefinitionProperty)Kernel.call((Object)((Object)this), (String)"renderContainerDefinition", (NativeType)NativeType.forClass(CfnTaskDefinition.ContainerDefinitionProperty.class), (Object[])new Object[]{_taskDefinition});
    }

    @Override
    @NotNull
    public CfnTaskDefinition.ContainerDefinitionProperty renderContainerDefinition() {
        return (CfnTaskDefinition.ContainerDefinitionProperty)Kernel.call((Object)((Object)this), (String)"renderContainerDefinition", (NativeType)NativeType.forClass(CfnTaskDefinition.ContainerDefinitionProperty.class), (Object[])new Object[0]);
    }

    @NotNull
    public FirelensConfig getFirelensConfig() {
        return (FirelensConfig)Kernel.get((Object)((Object)this), (String)"firelensConfig", (NativeType)NativeType.forClass(FirelensConfig.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<FirelensLogRouter> {
        private final Construct scope;
        private final String id;
        private final FirelensLogRouterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new FirelensLogRouterProps.Builder();
        }

        public Builder image(ContainerImage image) {
            this.props.image(image);
            return this;
        }

        public Builder command(List<String> command) {
            this.props.command(command);
            return this;
        }

        public Builder containerName(String containerName) {
            this.props.containerName(containerName);
            return this;
        }

        public Builder cpu(Number cpu) {
            this.props.cpu(cpu);
            return this;
        }

        public Builder disableNetworking(Boolean disableNetworking) {
            this.props.disableNetworking(disableNetworking);
            return this;
        }

        public Builder dnsSearchDomains(List<String> dnsSearchDomains) {
            this.props.dnsSearchDomains(dnsSearchDomains);
            return this;
        }

        public Builder dnsServers(List<String> dnsServers) {
            this.props.dnsServers(dnsServers);
            return this;
        }

        public Builder dockerLabels(Map<String, String> dockerLabels) {
            this.props.dockerLabels(dockerLabels);
            return this;
        }

        public Builder dockerSecurityOptions(List<String> dockerSecurityOptions) {
            this.props.dockerSecurityOptions(dockerSecurityOptions);
            return this;
        }

        public Builder entryPoint(List<String> entryPoint) {
            this.props.entryPoint(entryPoint);
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder environmentFiles(List<? extends EnvironmentFile> environmentFiles) {
            this.props.environmentFiles(environmentFiles);
            return this;
        }

        public Builder essential(Boolean essential) {
            this.props.essential(essential);
            return this;
        }

        public Builder extraHosts(Map<String, String> extraHosts) {
            this.props.extraHosts(extraHosts);
            return this;
        }

        public Builder gpuCount(Number gpuCount) {
            this.props.gpuCount(gpuCount);
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        public Builder hostname(String hostname) {
            this.props.hostname(hostname);
            return this;
        }

        public Builder inferenceAcceleratorResources(List<String> inferenceAcceleratorResources) {
            this.props.inferenceAcceleratorResources(inferenceAcceleratorResources);
            return this;
        }

        public Builder linuxParameters(LinuxParameters linuxParameters) {
            this.props.linuxParameters(linuxParameters);
            return this;
        }

        public Builder logging(LogDriver logging) {
            this.props.logging(logging);
            return this;
        }

        public Builder memoryLimitMiB(Number memoryLimitMiB) {
            this.props.memoryLimitMiB(memoryLimitMiB);
            return this;
        }

        public Builder memoryReservationMiB(Number memoryReservationMiB) {
            this.props.memoryReservationMiB(memoryReservationMiB);
            return this;
        }

        public Builder portMappings(List<? extends PortMapping> portMappings) {
            this.props.portMappings(portMappings);
            return this;
        }

        public Builder privileged(Boolean privileged) {
            this.props.privileged(privileged);
            return this;
        }

        public Builder pseudoTerminal(Boolean pseudoTerminal) {
            this.props.pseudoTerminal(pseudoTerminal);
            return this;
        }

        public Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.props.readonlyRootFilesystem(readonlyRootFilesystem);
            return this;
        }

        public Builder secrets(Map<String, ? extends Secret> secrets) {
            this.props.secrets(secrets);
            return this;
        }

        public Builder startTimeout(Duration startTimeout) {
            this.props.startTimeout(startTimeout);
            return this;
        }

        public Builder stopTimeout(Duration stopTimeout) {
            this.props.stopTimeout(stopTimeout);
            return this;
        }

        public Builder systemControls(List<? extends SystemControl> systemControls) {
            this.props.systemControls(systemControls);
            return this;
        }

        public Builder ulimits(List<? extends Ulimit> ulimits) {
            this.props.ulimits(ulimits);
            return this;
        }

        public Builder user(String user) {
            this.props.user(user);
            return this;
        }

        public Builder workingDirectory(String workingDirectory) {
            this.props.workingDirectory(workingDirectory);
            return this;
        }

        public Builder taskDefinition(TaskDefinition taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        public Builder firelensConfig(FirelensConfig firelensConfig) {
            this.props.firelensConfig(firelensConfig);
            return this;
        }

        public FirelensLogRouter build() {
            return new FirelensLogRouter(this.scope, this.id, this.props.build());
        }
    }
}

