/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Size;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.stepfunctions.Credentials;
import software.amazon.awscdk.services.stepfunctions.IntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig;
import software.amazon.awscdk.services.stepfunctions.TaskStateBase;
import software.amazon.awscdk.services.stepfunctions.Timeout;
import software.amazon.awscdk.services.stepfunctions.tasks.BatchStrategy;
import software.amazon.awscdk.services.stepfunctions.tasks.ModelClientOptions;
import software.amazon.awscdk.services.stepfunctions.tasks.SageMakerCreateTransformJobProps;
import software.amazon.awscdk.services.stepfunctions.tasks.TransformInput;
import software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput;
import software.amazon.awscdk.services.stepfunctions.tasks.TransformResources;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.SageMakerCreateTransformJob")
public class SageMakerCreateTransformJob
extends TaskStateBase {
    protected SageMakerCreateTransformJob(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SageMakerCreateTransformJob(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public SageMakerCreateTransformJob(@NotNull Construct scope, @NotNull String id, @NotNull SageMakerCreateTransformJobProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public IRole getRole() {
        return (IRole)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(IRole.class));
    }

    @Override
    @Nullable
    protected TaskMetricsConfig getTaskMetrics() {
        return (TaskMetricsConfig)Kernel.get((Object)this, (String)"taskMetrics", (NativeType)NativeType.forClass(TaskMetricsConfig.class));
    }

    @Override
    @Nullable
    protected List<PolicyStatement> getTaskPolicies() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"taskPolicies", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(PolicyStatement.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<SageMakerCreateTransformJob> {
        private final Construct scope;
        private final String id;
        private final SageMakerCreateTransformJobProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new SageMakerCreateTransformJobProps.Builder();
        }

        public Builder comment(String comment) {
            this.props.comment(comment);
            return this;
        }

        public Builder credentials(Credentials credentials) {
            this.props.credentials(credentials);
            return this;
        }

        @Deprecated
        public Builder heartbeat(Duration heartbeat) {
            this.props.heartbeat(heartbeat);
            return this;
        }

        public Builder heartbeatTimeout(Timeout heartbeatTimeout) {
            this.props.heartbeatTimeout(heartbeatTimeout);
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.props.inputPath(inputPath);
            return this;
        }

        public Builder integrationPattern(IntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.props.outputPath(outputPath);
            return this;
        }

        public Builder resultPath(String resultPath) {
            this.props.resultPath(resultPath);
            return this;
        }

        public Builder resultSelector(Map<String, ? extends Object> resultSelector) {
            this.props.resultSelector(resultSelector);
            return this;
        }

        public Builder stateName(String stateName) {
            this.props.stateName(stateName);
            return this;
        }

        public Builder taskTimeout(Timeout taskTimeout) {
            this.props.taskTimeout(taskTimeout);
            return this;
        }

        @Deprecated
        public Builder timeout(Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder modelName(String modelName) {
            this.props.modelName(modelName);
            return this;
        }

        public Builder transformInput(TransformInput transformInput) {
            this.props.transformInput(transformInput);
            return this;
        }

        public Builder transformJobName(String transformJobName) {
            this.props.transformJobName(transformJobName);
            return this;
        }

        public Builder transformOutput(TransformOutput transformOutput) {
            this.props.transformOutput(transformOutput);
            return this;
        }

        public Builder batchStrategy(BatchStrategy batchStrategy) {
            this.props.batchStrategy(batchStrategy);
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder maxConcurrentTransforms(Number maxConcurrentTransforms) {
            this.props.maxConcurrentTransforms(maxConcurrentTransforms);
            return this;
        }

        public Builder maxPayload(Size maxPayload) {
            this.props.maxPayload(maxPayload);
            return this;
        }

        public Builder modelClientOptions(ModelClientOptions modelClientOptions) {
            this.props.modelClientOptions(modelClientOptions);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder transformResources(TransformResources transformResources) {
            this.props.transformResources(transformResources);
            return this;
        }

        public SageMakerCreateTransformJob build() {
            return new SageMakerCreateTransformJob(this.scope, this.id, this.props.build());
        }
    }
}

