/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.autoscaling;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroup;
import software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroupProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup")
public class CfnAutoScalingGroup
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnAutoScalingGroup.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnAutoScalingGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAutoScalingGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnAutoScalingGroup(@NotNull Construct scope, @NotNull String id, @NotNull CfnAutoScalingGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getMaxSize() {
        return (String)Kernel.get((Object)this, (String)"maxSize", (NativeType)NativeType.forClass(String.class));
    }

    public void setMaxSize(@NotNull String value) {
        Kernel.set((Object)this, (String)"maxSize", (Object)Objects.requireNonNull(value, "maxSize is required"));
    }

    @NotNull
    public String getMinSize() {
        return (String)Kernel.get((Object)this, (String)"minSize", (NativeType)NativeType.forClass(String.class));
    }

    public void setMinSize(@NotNull String value) {
        Kernel.set((Object)this, (String)"minSize", (Object)Objects.requireNonNull(value, "minSize is required"));
    }

    @Nullable
    public String getAutoScalingGroupName() {
        return (String)Kernel.get((Object)this, (String)"autoScalingGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setAutoScalingGroupName(@Nullable String value) {
        Kernel.set((Object)this, (String)"autoScalingGroupName", (Object)value);
    }

    @Nullable
    public List<String> getAvailabilityZones() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"availabilityZones", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setAvailabilityZones(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"availabilityZones", value);
    }

    @Nullable
    public Object getCapacityRebalance() {
        return Kernel.get((Object)this, (String)"capacityRebalance", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCapacityRebalance(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"capacityRebalance", (Object)value);
    }

    public void setCapacityRebalance(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"capacityRebalance", (Object)value);
    }

    @Nullable
    public String getContext() {
        return (String)Kernel.get((Object)this, (String)"context", (NativeType)NativeType.forClass(String.class));
    }

    public void setContext(@Nullable String value) {
        Kernel.set((Object)this, (String)"context", (Object)value);
    }

    @Nullable
    public String getCooldown() {
        return (String)Kernel.get((Object)this, (String)"cooldown", (NativeType)NativeType.forClass(String.class));
    }

    public void setCooldown(@Nullable String value) {
        Kernel.set((Object)this, (String)"cooldown", (Object)value);
    }

    @Nullable
    public Number getDefaultInstanceWarmup() {
        return (Number)Kernel.get((Object)this, (String)"defaultInstanceWarmup", (NativeType)NativeType.forClass(Number.class));
    }

    public void setDefaultInstanceWarmup(@Nullable Number value) {
        Kernel.set((Object)this, (String)"defaultInstanceWarmup", (Object)value);
    }

    @Nullable
    public String getDesiredCapacity() {
        return (String)Kernel.get((Object)this, (String)"desiredCapacity", (NativeType)NativeType.forClass(String.class));
    }

    public void setDesiredCapacity(@Nullable String value) {
        Kernel.set((Object)this, (String)"desiredCapacity", (Object)value);
    }

    @Nullable
    public String getDesiredCapacityType() {
        return (String)Kernel.get((Object)this, (String)"desiredCapacityType", (NativeType)NativeType.forClass(String.class));
    }

    public void setDesiredCapacityType(@Nullable String value) {
        Kernel.set((Object)this, (String)"desiredCapacityType", (Object)value);
    }

    @Nullable
    public Number getHealthCheckGracePeriod() {
        return (Number)Kernel.get((Object)this, (String)"healthCheckGracePeriod", (NativeType)NativeType.forClass(Number.class));
    }

    public void setHealthCheckGracePeriod(@Nullable Number value) {
        Kernel.set((Object)this, (String)"healthCheckGracePeriod", (Object)value);
    }

    @Nullable
    public String getHealthCheckType() {
        return (String)Kernel.get((Object)this, (String)"healthCheckType", (NativeType)NativeType.forClass(String.class));
    }

    public void setHealthCheckType(@Nullable String value) {
        Kernel.set((Object)this, (String)"healthCheckType", (Object)value);
    }

    @Nullable
    public String getInstanceId() {
        return (String)Kernel.get((Object)this, (String)"instanceId", (NativeType)NativeType.forClass(String.class));
    }

    public void setInstanceId(@Nullable String value) {
        Kernel.set((Object)this, (String)"instanceId", (Object)value);
    }

    @Nullable
    public String getLaunchConfigurationName() {
        return (String)Kernel.get((Object)this, (String)"launchConfigurationName", (NativeType)NativeType.forClass(String.class));
    }

    public void setLaunchConfigurationName(@Nullable String value) {
        Kernel.set((Object)this, (String)"launchConfigurationName", (Object)value);
    }

    @Nullable
    public Object getLaunchTemplate() {
        return Kernel.get((Object)this, (String)"launchTemplate", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLaunchTemplate(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"launchTemplate", (Object)value);
    }

    public void setLaunchTemplate(@Nullable LaunchTemplateSpecificationProperty value) {
        Kernel.set((Object)this, (String)"launchTemplate", (Object)value);
    }

    @Nullable
    public Object getLifecycleHookSpecificationList() {
        return Kernel.get((Object)this, (String)"lifecycleHookSpecificationList", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLifecycleHookSpecificationList(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"lifecycleHookSpecificationList", (Object)value);
    }

    public void setLifecycleHookSpecificationList(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof LifecycleHookSpecificationProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroup.LifecycleHookSpecificationProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"lifecycleHookSpecificationList", value);
    }

    @Nullable
    public List<String> getLoadBalancerNames() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"loadBalancerNames", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setLoadBalancerNames(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"loadBalancerNames", value);
    }

    @Nullable
    public Number getMaxInstanceLifetime() {
        return (Number)Kernel.get((Object)this, (String)"maxInstanceLifetime", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaxInstanceLifetime(@Nullable Number value) {
        Kernel.set((Object)this, (String)"maxInstanceLifetime", (Object)value);
    }

    @Nullable
    public Object getMetricsCollection() {
        return Kernel.get((Object)this, (String)"metricsCollection", (NativeType)NativeType.forClass(Object.class));
    }

    public void setMetricsCollection(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"metricsCollection", (Object)value);
    }

    public void setMetricsCollection(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof MetricsCollectionProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroup.MetricsCollectionProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"metricsCollection", value);
    }

    @Nullable
    public Object getMixedInstancesPolicy() {
        return Kernel.get((Object)this, (String)"mixedInstancesPolicy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setMixedInstancesPolicy(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"mixedInstancesPolicy", (Object)value);
    }

    public void setMixedInstancesPolicy(@Nullable MixedInstancesPolicyProperty value) {
        Kernel.set((Object)this, (String)"mixedInstancesPolicy", (Object)value);
    }

    @Nullable
    public Object getNewInstancesProtectedFromScaleIn() {
        return Kernel.get((Object)this, (String)"newInstancesProtectedFromScaleIn", (NativeType)NativeType.forClass(Object.class));
    }

    public void setNewInstancesProtectedFromScaleIn(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"newInstancesProtectedFromScaleIn", (Object)value);
    }

    public void setNewInstancesProtectedFromScaleIn(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"newInstancesProtectedFromScaleIn", (Object)value);
    }

    @Deprecated
    @Nullable
    public Object getNotificationConfiguration() {
        return Kernel.get((Object)this, (String)"notificationConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    @Deprecated
    public void setNotificationConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"notificationConfiguration", (Object)value);
    }

    @Deprecated
    public void setNotificationConfiguration(@Nullable NotificationConfigurationProperty value) {
        Kernel.set((Object)this, (String)"notificationConfiguration", (Object)value);
    }

    @Nullable
    public Object getNotificationConfigurations() {
        return Kernel.get((Object)this, (String)"notificationConfigurations", (NativeType)NativeType.forClass(Object.class));
    }

    public void setNotificationConfigurations(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"notificationConfigurations", (Object)value);
    }

    public void setNotificationConfigurations(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof NotificationConfigurationProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroup.NotificationConfigurationProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"notificationConfigurations", value);
    }

    @Nullable
    public String getPlacementGroup() {
        return (String)Kernel.get((Object)this, (String)"placementGroup", (NativeType)NativeType.forClass(String.class));
    }

    public void setPlacementGroup(@Nullable String value) {
        Kernel.set((Object)this, (String)"placementGroup", (Object)value);
    }

    @Nullable
    public String getServiceLinkedRoleArn() {
        return (String)Kernel.get((Object)this, (String)"serviceLinkedRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setServiceLinkedRoleArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"serviceLinkedRoleArn", (Object)value);
    }

    @Nullable
    public List<TagPropertyProperty> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(TagPropertyProperty.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<TagPropertyProperty> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Nullable
    public List<String> getTargetGroupArns() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"targetGroupArns", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTargetGroupArns(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"targetGroupArns", value);
    }

    @Nullable
    public List<String> getTerminationPolicies() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"terminationPolicies", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTerminationPolicies(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"terminationPolicies", value);
    }

    @Nullable
    public List<String> getVpcZoneIdentifier() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"vpcZoneIdentifier", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setVpcZoneIdentifier(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"vpcZoneIdentifier", value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.LifecycleHookSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LifecycleHookSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getLifecycleHookName();

        @NotNull
        public String getLifecycleTransition();

        @Nullable
        default public String getDefaultResult() {
            return null;
        }

        @Nullable
        default public Number getHeartbeatTimeout() {
            return null;
        }

        @Nullable
        default public String getNotificationMetadata() {
            return null;
        }

        @Nullable
        default public String getNotificationTargetArn() {
            return null;
        }

        @Nullable
        default public String getRoleArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LifecycleHookSpecificationProperty> {
            String lifecycleHookName;
            String lifecycleTransition;
            String defaultResult;
            Number heartbeatTimeout;
            String notificationMetadata;
            String notificationTargetArn;
            String roleArn;

            public Builder lifecycleHookName(String lifecycleHookName) {
                this.lifecycleHookName = lifecycleHookName;
                return this;
            }

            public Builder lifecycleTransition(String lifecycleTransition) {
                this.lifecycleTransition = lifecycleTransition;
                return this;
            }

            public Builder defaultResult(String defaultResult) {
                this.defaultResult = defaultResult;
                return this;
            }

            public Builder heartbeatTimeout(Number heartbeatTimeout) {
                this.heartbeatTimeout = heartbeatTimeout;
                return this;
            }

            public Builder notificationMetadata(String notificationMetadata) {
                this.notificationMetadata = notificationMetadata;
                return this;
            }

            public Builder notificationTargetArn(String notificationTargetArn) {
                this.notificationTargetArn = notificationTargetArn;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public LifecycleHookSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.MetricsCollectionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricsCollectionProperty
    extends JsiiSerializable {
        @NotNull
        public String getGranularity();

        @Nullable
        default public List<String> getMetrics() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricsCollectionProperty> {
            String granularity;
            List<String> metrics;

            public Builder granularity(String granularity) {
                this.granularity = granularity;
                return this;
            }

            public Builder metrics(List<String> metrics) {
                this.metrics = metrics;
                return this;
            }

            public MetricsCollectionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.NotificationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NotificationConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getTopicArn();

        @Nullable
        default public List<String> getNotificationTypes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NotificationConfigurationProperty> {
            String topicArn;
            List<String> notificationTypes;

            public Builder topicArn(String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            public Builder notificationTypes(List<String> notificationTypes) {
                this.notificationTypes = notificationTypes;
                return this;
            }

            public NotificationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.TagPropertyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagPropertyProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public Object getPropagateAtLaunch();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TagPropertyProperty> {
            String key;
            Object propagateAtLaunch;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder propagateAtLaunch(Boolean propagateAtLaunch) {
                this.propagateAtLaunch = propagateAtLaunch;
                return this;
            }

            public Builder propagateAtLaunch(IResolvable propagateAtLaunch) {
                this.propagateAtLaunch = propagateAtLaunch;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TagPropertyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnAutoScalingGroup> {
        private final Construct scope;
        private final String id;
        private final CfnAutoScalingGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAutoScalingGroupProps.Builder();
        }

        public Builder maxSize(String maxSize) {
            this.props.maxSize(maxSize);
            return this;
        }

        public Builder minSize(String minSize) {
            this.props.minSize(minSize);
            return this;
        }

        public Builder autoScalingGroupName(String autoScalingGroupName) {
            this.props.autoScalingGroupName(autoScalingGroupName);
            return this;
        }

        public Builder availabilityZones(List<String> availabilityZones) {
            this.props.availabilityZones(availabilityZones);
            return this;
        }

        public Builder capacityRebalance(Boolean capacityRebalance) {
            this.props.capacityRebalance(capacityRebalance);
            return this;
        }

        public Builder capacityRebalance(IResolvable capacityRebalance) {
            this.props.capacityRebalance(capacityRebalance);
            return this;
        }

        public Builder context(String context) {
            this.props.context(context);
            return this;
        }

        public Builder cooldown(String cooldown) {
            this.props.cooldown(cooldown);
            return this;
        }

        public Builder defaultInstanceWarmup(Number defaultInstanceWarmup) {
            this.props.defaultInstanceWarmup(defaultInstanceWarmup);
            return this;
        }

        public Builder desiredCapacity(String desiredCapacity) {
            this.props.desiredCapacity(desiredCapacity);
            return this;
        }

        public Builder desiredCapacityType(String desiredCapacityType) {
            this.props.desiredCapacityType(desiredCapacityType);
            return this;
        }

        public Builder healthCheckGracePeriod(Number healthCheckGracePeriod) {
            this.props.healthCheckGracePeriod(healthCheckGracePeriod);
            return this;
        }

        public Builder healthCheckType(String healthCheckType) {
            this.props.healthCheckType(healthCheckType);
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.props.instanceId(instanceId);
            return this;
        }

        public Builder launchConfigurationName(String launchConfigurationName) {
            this.props.launchConfigurationName(launchConfigurationName);
            return this;
        }

        public Builder launchTemplate(IResolvable launchTemplate) {
            this.props.launchTemplate(launchTemplate);
            return this;
        }

        public Builder launchTemplate(LaunchTemplateSpecificationProperty launchTemplate) {
            this.props.launchTemplate(launchTemplate);
            return this;
        }

        public Builder lifecycleHookSpecificationList(IResolvable lifecycleHookSpecificationList) {
            this.props.lifecycleHookSpecificationList(lifecycleHookSpecificationList);
            return this;
        }

        public Builder lifecycleHookSpecificationList(List<? extends Object> lifecycleHookSpecificationList) {
            this.props.lifecycleHookSpecificationList(lifecycleHookSpecificationList);
            return this;
        }

        public Builder loadBalancerNames(List<String> loadBalancerNames) {
            this.props.loadBalancerNames(loadBalancerNames);
            return this;
        }

        public Builder maxInstanceLifetime(Number maxInstanceLifetime) {
            this.props.maxInstanceLifetime(maxInstanceLifetime);
            return this;
        }

        public Builder metricsCollection(IResolvable metricsCollection) {
            this.props.metricsCollection(metricsCollection);
            return this;
        }

        public Builder metricsCollection(List<? extends Object> metricsCollection) {
            this.props.metricsCollection(metricsCollection);
            return this;
        }

        public Builder mixedInstancesPolicy(IResolvable mixedInstancesPolicy) {
            this.props.mixedInstancesPolicy(mixedInstancesPolicy);
            return this;
        }

        public Builder mixedInstancesPolicy(MixedInstancesPolicyProperty mixedInstancesPolicy) {
            this.props.mixedInstancesPolicy(mixedInstancesPolicy);
            return this;
        }

        public Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.props.newInstancesProtectedFromScaleIn(newInstancesProtectedFromScaleIn);
            return this;
        }

        public Builder newInstancesProtectedFromScaleIn(IResolvable newInstancesProtectedFromScaleIn) {
            this.props.newInstancesProtectedFromScaleIn(newInstancesProtectedFromScaleIn);
            return this;
        }

        @Deprecated
        public Builder notificationConfiguration(IResolvable notificationConfiguration) {
            this.props.notificationConfiguration(notificationConfiguration);
            return this;
        }

        @Deprecated
        public Builder notificationConfiguration(NotificationConfigurationProperty notificationConfiguration) {
            this.props.notificationConfiguration(notificationConfiguration);
            return this;
        }

        public Builder notificationConfigurations(IResolvable notificationConfigurations) {
            this.props.notificationConfigurations(notificationConfigurations);
            return this;
        }

        public Builder notificationConfigurations(List<? extends Object> notificationConfigurations) {
            this.props.notificationConfigurations(notificationConfigurations);
            return this;
        }

        public Builder placementGroup(String placementGroup) {
            this.props.placementGroup(placementGroup);
            return this;
        }

        public Builder serviceLinkedRoleArn(String serviceLinkedRoleArn) {
            this.props.serviceLinkedRoleArn(serviceLinkedRoleArn);
            return this;
        }

        public Builder tags(List<? extends TagPropertyProperty> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder targetGroupArns(List<String> targetGroupArns) {
            this.props.targetGroupArns(targetGroupArns);
            return this;
        }

        public Builder terminationPolicies(List<String> terminationPolicies) {
            this.props.terminationPolicies(terminationPolicies);
            return this;
        }

        public Builder vpcZoneIdentifier(List<String> vpcZoneIdentifier) {
            this.props.vpcZoneIdentifier(vpcZoneIdentifier);
            return this;
        }

        public CfnAutoScalingGroup build() {
            return new CfnAutoScalingGroup(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.VCpuCountRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VCpuCountRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VCpuCountRequestProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public VCpuCountRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.TotalLocalStorageGBRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TotalLocalStorageGBRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TotalLocalStorageGBRequestProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public TotalLocalStorageGBRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.NetworkInterfaceCountRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkInterfaceCountRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkInterfaceCountRequestProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public NetworkInterfaceCountRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.NetworkBandwidthGbpsRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkBandwidthGbpsRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkBandwidthGbpsRequestProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public NetworkBandwidthGbpsRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.MixedInstancesPolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MixedInstancesPolicyProperty
    extends JsiiSerializable {
        @NotNull
        public Object getLaunchTemplate();

        @Nullable
        default public Object getInstancesDistribution() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MixedInstancesPolicyProperty> {
            Object launchTemplate;
            Object instancesDistribution;

            public Builder launchTemplate(IResolvable launchTemplate) {
                this.launchTemplate = launchTemplate;
                return this;
            }

            public Builder launchTemplate(LaunchTemplateProperty launchTemplate) {
                this.launchTemplate = launchTemplate;
                return this;
            }

            public Builder instancesDistribution(IResolvable instancesDistribution) {
                this.instancesDistribution = instancesDistribution;
                return this;
            }

            public Builder instancesDistribution(InstancesDistributionProperty instancesDistribution) {
                this.instancesDistribution = instancesDistribution;
                return this;
            }

            public MixedInstancesPolicyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.MemoryMiBRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MemoryMiBRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MemoryMiBRequestProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public MemoryMiBRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.MemoryGiBPerVCpuRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MemoryGiBPerVCpuRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MemoryGiBPerVCpuRequestProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public MemoryGiBPerVCpuRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.LaunchTemplateSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getVersion();

        @Nullable
        default public String getLaunchTemplateId() {
            return null;
        }

        @Nullable
        default public String getLaunchTemplateName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchTemplateSpecificationProperty> {
            String version;
            String launchTemplateId;
            String launchTemplateName;

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public Builder launchTemplateId(String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            public Builder launchTemplateName(String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            public LaunchTemplateSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.LaunchTemplateProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateProperty
    extends JsiiSerializable {
        @NotNull
        public Object getLaunchTemplateSpecification();

        @Nullable
        default public Object getOverrides() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchTemplateProperty> {
            Object launchTemplateSpecification;
            Object overrides;

            public Builder launchTemplateSpecification(IResolvable launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            public Builder launchTemplateSpecification(LaunchTemplateSpecificationProperty launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            public Builder overrides(IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            public Builder overrides(List<? extends Object> overrides) {
                this.overrides = overrides;
                return this;
            }

            public LaunchTemplateProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.LaunchTemplateOverridesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateOverridesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getInstanceRequirements() {
            return null;
        }

        @Nullable
        default public String getInstanceType() {
            return null;
        }

        @Nullable
        default public Object getLaunchTemplateSpecification() {
            return null;
        }

        @Nullable
        default public String getWeightedCapacity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchTemplateOverridesProperty> {
            Object instanceRequirements;
            String instanceType;
            Object launchTemplateSpecification;
            String weightedCapacity;

            public Builder instanceRequirements(IResolvable instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            public Builder instanceRequirements(InstanceRequirementsProperty instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder launchTemplateSpecification(IResolvable launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            public Builder launchTemplateSpecification(LaunchTemplateSpecificationProperty launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            public Builder weightedCapacity(String weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            public LaunchTemplateOverridesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.InstancesDistributionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstancesDistributionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getOnDemandAllocationStrategy() {
            return null;
        }

        @Nullable
        default public Number getOnDemandBaseCapacity() {
            return null;
        }

        @Nullable
        default public Number getOnDemandPercentageAboveBaseCapacity() {
            return null;
        }

        @Nullable
        default public String getSpotAllocationStrategy() {
            return null;
        }

        @Nullable
        default public Number getSpotInstancePools() {
            return null;
        }

        @Nullable
        default public String getSpotMaxPrice() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstancesDistributionProperty> {
            String onDemandAllocationStrategy;
            Number onDemandBaseCapacity;
            Number onDemandPercentageAboveBaseCapacity;
            String spotAllocationStrategy;
            Number spotInstancePools;
            String spotMaxPrice;

            public Builder onDemandAllocationStrategy(String onDemandAllocationStrategy) {
                this.onDemandAllocationStrategy = onDemandAllocationStrategy;
                return this;
            }

            public Builder onDemandBaseCapacity(Number onDemandBaseCapacity) {
                this.onDemandBaseCapacity = onDemandBaseCapacity;
                return this;
            }

            public Builder onDemandPercentageAboveBaseCapacity(Number onDemandPercentageAboveBaseCapacity) {
                this.onDemandPercentageAboveBaseCapacity = onDemandPercentageAboveBaseCapacity;
                return this;
            }

            public Builder spotAllocationStrategy(String spotAllocationStrategy) {
                this.spotAllocationStrategy = spotAllocationStrategy;
                return this;
            }

            public Builder spotInstancePools(Number spotInstancePools) {
                this.spotInstancePools = spotInstancePools;
                return this;
            }

            public Builder spotMaxPrice(String spotMaxPrice) {
                this.spotMaxPrice = spotMaxPrice;
                return this;
            }

            public InstancesDistributionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.InstanceRequirementsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceRequirementsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAcceleratorCount() {
            return null;
        }

        @Nullable
        default public List<String> getAcceleratorManufacturers() {
            return null;
        }

        @Nullable
        default public List<String> getAcceleratorNames() {
            return null;
        }

        @Nullable
        default public Object getAcceleratorTotalMemoryMiB() {
            return null;
        }

        @Nullable
        default public List<String> getAcceleratorTypes() {
            return null;
        }

        @Nullable
        default public List<String> getAllowedInstanceTypes() {
            return null;
        }

        @Nullable
        default public String getBareMetal() {
            return null;
        }

        @Nullable
        default public Object getBaselineEbsBandwidthMbps() {
            return null;
        }

        @Nullable
        default public String getBurstablePerformance() {
            return null;
        }

        @Nullable
        default public List<String> getCpuManufacturers() {
            return null;
        }

        @Nullable
        default public List<String> getExcludedInstanceTypes() {
            return null;
        }

        @Nullable
        default public List<String> getInstanceGenerations() {
            return null;
        }

        @Nullable
        default public String getLocalStorage() {
            return null;
        }

        @Nullable
        default public List<String> getLocalStorageTypes() {
            return null;
        }

        @Nullable
        default public Object getMemoryGiBPerVCpu() {
            return null;
        }

        @Nullable
        default public Object getMemoryMiB() {
            return null;
        }

        @Nullable
        default public Object getNetworkBandwidthGbps() {
            return null;
        }

        @Nullable
        default public Object getNetworkInterfaceCount() {
            return null;
        }

        @Nullable
        default public Number getOnDemandMaxPricePercentageOverLowestPrice() {
            return null;
        }

        @Nullable
        default public Object getRequireHibernateSupport() {
            return null;
        }

        @Nullable
        default public Number getSpotMaxPricePercentageOverLowestPrice() {
            return null;
        }

        @Nullable
        default public Object getTotalLocalStorageGb() {
            return null;
        }

        @Nullable
        default public Object getVCpuCount() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceRequirementsProperty> {
            Object acceleratorCount;
            List<String> acceleratorManufacturers;
            List<String> acceleratorNames;
            Object acceleratorTotalMemoryMiB;
            List<String> acceleratorTypes;
            List<String> allowedInstanceTypes;
            String bareMetal;
            Object baselineEbsBandwidthMbps;
            String burstablePerformance;
            List<String> cpuManufacturers;
            List<String> excludedInstanceTypes;
            List<String> instanceGenerations;
            String localStorage;
            List<String> localStorageTypes;
            Object memoryGiBPerVCpu;
            Object memoryMiB;
            Object networkBandwidthGbps;
            Object networkInterfaceCount;
            Number onDemandMaxPricePercentageOverLowestPrice;
            Object requireHibernateSupport;
            Number spotMaxPricePercentageOverLowestPrice;
            Object totalLocalStorageGb;
            Object vCpuCount;

            public Builder acceleratorCount(IResolvable acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            public Builder acceleratorCount(AcceleratorCountRequestProperty acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            public Builder acceleratorManufacturers(List<String> acceleratorManufacturers) {
                this.acceleratorManufacturers = acceleratorManufacturers;
                return this;
            }

            public Builder acceleratorNames(List<String> acceleratorNames) {
                this.acceleratorNames = acceleratorNames;
                return this;
            }

            public Builder acceleratorTotalMemoryMiB(IResolvable acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            public Builder acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            public Builder acceleratorTypes(List<String> acceleratorTypes) {
                this.acceleratorTypes = acceleratorTypes;
                return this;
            }

            public Builder allowedInstanceTypes(List<String> allowedInstanceTypes) {
                this.allowedInstanceTypes = allowedInstanceTypes;
                return this;
            }

            public Builder bareMetal(String bareMetal) {
                this.bareMetal = bareMetal;
                return this;
            }

            public Builder baselineEbsBandwidthMbps(IResolvable baselineEbsBandwidthMbps) {
                this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
                return this;
            }

            public Builder baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty baselineEbsBandwidthMbps) {
                this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
                return this;
            }

            public Builder burstablePerformance(String burstablePerformance) {
                this.burstablePerformance = burstablePerformance;
                return this;
            }

            public Builder cpuManufacturers(List<String> cpuManufacturers) {
                this.cpuManufacturers = cpuManufacturers;
                return this;
            }

            public Builder excludedInstanceTypes(List<String> excludedInstanceTypes) {
                this.excludedInstanceTypes = excludedInstanceTypes;
                return this;
            }

            public Builder instanceGenerations(List<String> instanceGenerations) {
                this.instanceGenerations = instanceGenerations;
                return this;
            }

            public Builder localStorage(String localStorage) {
                this.localStorage = localStorage;
                return this;
            }

            public Builder localStorageTypes(List<String> localStorageTypes) {
                this.localStorageTypes = localStorageTypes;
                return this;
            }

            public Builder memoryGiBPerVCpu(IResolvable memoryGiBPerVCpu) {
                this.memoryGiBPerVCpu = memoryGiBPerVCpu;
                return this;
            }

            public Builder memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty memoryGiBPerVCpu) {
                this.memoryGiBPerVCpu = memoryGiBPerVCpu;
                return this;
            }

            public Builder memoryMiB(IResolvable memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            public Builder memoryMiB(MemoryMiBRequestProperty memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            public Builder networkBandwidthGbps(IResolvable networkBandwidthGbps) {
                this.networkBandwidthGbps = networkBandwidthGbps;
                return this;
            }

            public Builder networkBandwidthGbps(NetworkBandwidthGbpsRequestProperty networkBandwidthGbps) {
                this.networkBandwidthGbps = networkBandwidthGbps;
                return this;
            }

            public Builder networkInterfaceCount(IResolvable networkInterfaceCount) {
                this.networkInterfaceCount = networkInterfaceCount;
                return this;
            }

            public Builder networkInterfaceCount(NetworkInterfaceCountRequestProperty networkInterfaceCount) {
                this.networkInterfaceCount = networkInterfaceCount;
                return this;
            }

            public Builder onDemandMaxPricePercentageOverLowestPrice(Number onDemandMaxPricePercentageOverLowestPrice) {
                this.onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice;
                return this;
            }

            public Builder requireHibernateSupport(Boolean requireHibernateSupport) {
                this.requireHibernateSupport = requireHibernateSupport;
                return this;
            }

            public Builder requireHibernateSupport(IResolvable requireHibernateSupport) {
                this.requireHibernateSupport = requireHibernateSupport;
                return this;
            }

            public Builder spotMaxPricePercentageOverLowestPrice(Number spotMaxPricePercentageOverLowestPrice) {
                this.spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice;
                return this;
            }

            public Builder totalLocalStorageGb(IResolvable totalLocalStorageGb) {
                this.totalLocalStorageGb = totalLocalStorageGb;
                return this;
            }

            public Builder totalLocalStorageGb(TotalLocalStorageGBRequestProperty totalLocalStorageGb) {
                this.totalLocalStorageGb = totalLocalStorageGb;
                return this;
            }

            public Builder vCpuCount(IResolvable vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            public Builder vCpuCount(VCpuCountRequestProperty vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            public InstanceRequirementsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.BaselineEbsBandwidthMbpsRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BaselineEbsBandwidthMbpsRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BaselineEbsBandwidthMbpsRequestProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public BaselineEbsBandwidthMbpsRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.AcceleratorTotalMemoryMiBRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AcceleratorTotalMemoryMiBRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AcceleratorTotalMemoryMiBRequestProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public AcceleratorTotalMemoryMiBRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroup.AcceleratorCountRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AcceleratorCountRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AcceleratorCountRequestProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public AcceleratorCountRequestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

