/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.internetmonitor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.internetmonitor.CfnMonitor;
import software.amazon.awscdk.services.internetmonitor.CfnMonitorProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_internetmonitor.CfnMonitor")
public class CfnMonitor
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnMonitor.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnMonitor(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMonitor(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnMonitor(@NotNull Construct scope, @NotNull String id, @NotNull CfnMonitorProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCreatedAt() {
        return (String)Kernel.get((Object)this, (String)"attrCreatedAt", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrModifiedAt() {
        return (String)Kernel.get((Object)this, (String)"attrModifiedAt", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrMonitorArn() {
        return (String)Kernel.get((Object)this, (String)"attrMonitorArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrProcessingStatus() {
        return (String)Kernel.get((Object)this, (String)"attrProcessingStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrProcessingStatusInfo() {
        return (String)Kernel.get((Object)this, (String)"attrProcessingStatusInfo", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getMonitorName() {
        return (String)Kernel.get((Object)this, (String)"monitorName", (NativeType)NativeType.forClass(String.class));
    }

    public void setMonitorName(@NotNull String value) {
        Kernel.set((Object)this, (String)"monitorName", (Object)Objects.requireNonNull(value, "monitorName is required"));
    }

    @Nullable
    public Object getHealthEventsConfig() {
        return Kernel.get((Object)this, (String)"healthEventsConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setHealthEventsConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"healthEventsConfig", (Object)value);
    }

    public void setHealthEventsConfig(@Nullable HealthEventsConfigProperty value) {
        Kernel.set((Object)this, (String)"healthEventsConfig", (Object)value);
    }

    @Nullable
    public Object getInternetMeasurementsLogDelivery() {
        return Kernel.get((Object)this, (String)"internetMeasurementsLogDelivery", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInternetMeasurementsLogDelivery(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"internetMeasurementsLogDelivery", (Object)value);
    }

    public void setInternetMeasurementsLogDelivery(@Nullable InternetMeasurementsLogDeliveryProperty value) {
        Kernel.set((Object)this, (String)"internetMeasurementsLogDelivery", (Object)value);
    }

    @Nullable
    public Number getMaxCityNetworksToMonitor() {
        return (Number)Kernel.get((Object)this, (String)"maxCityNetworksToMonitor", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaxCityNetworksToMonitor(@Nullable Number value) {
        Kernel.set((Object)this, (String)"maxCityNetworksToMonitor", (Object)value);
    }

    @Nullable
    public List<String> getResources() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"resources", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setResources(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"resources", value);
    }

    @Nullable
    public List<String> getResourcesToAdd() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"resourcesToAdd", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setResourcesToAdd(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"resourcesToAdd", value);
    }

    @Nullable
    public List<String> getResourcesToRemove() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"resourcesToRemove", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setResourcesToRemove(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"resourcesToRemove", value);
    }

    @Nullable
    public String getStatus() {
        return (String)Kernel.get((Object)this, (String)"status", (NativeType)NativeType.forClass(String.class));
    }

    public void setStatus(@Nullable String value) {
        Kernel.set((Object)this, (String)"status", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Nullable
    public Number getTrafficPercentageToMonitor() {
        return (Number)Kernel.get((Object)this, (String)"trafficPercentageToMonitor", (NativeType)NativeType.forClass(Number.class));
    }

    public void setTrafficPercentageToMonitor(@Nullable Number value) {
        Kernel.set((Object)this, (String)"trafficPercentageToMonitor", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnMonitor> {
        private final Construct scope;
        private final String id;
        private final CfnMonitorProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnMonitorProps.Builder();
        }

        public Builder monitorName(String monitorName) {
            this.props.monitorName(monitorName);
            return this;
        }

        public Builder healthEventsConfig(IResolvable healthEventsConfig) {
            this.props.healthEventsConfig(healthEventsConfig);
            return this;
        }

        public Builder healthEventsConfig(HealthEventsConfigProperty healthEventsConfig) {
            this.props.healthEventsConfig(healthEventsConfig);
            return this;
        }

        public Builder internetMeasurementsLogDelivery(IResolvable internetMeasurementsLogDelivery) {
            this.props.internetMeasurementsLogDelivery(internetMeasurementsLogDelivery);
            return this;
        }

        public Builder internetMeasurementsLogDelivery(InternetMeasurementsLogDeliveryProperty internetMeasurementsLogDelivery) {
            this.props.internetMeasurementsLogDelivery(internetMeasurementsLogDelivery);
            return this;
        }

        public Builder maxCityNetworksToMonitor(Number maxCityNetworksToMonitor) {
            this.props.maxCityNetworksToMonitor(maxCityNetworksToMonitor);
            return this;
        }

        public Builder resources(List<String> resources) {
            this.props.resources(resources);
            return this;
        }

        public Builder resourcesToAdd(List<String> resourcesToAdd) {
            this.props.resourcesToAdd(resourcesToAdd);
            return this;
        }

        public Builder resourcesToRemove(List<String> resourcesToRemove) {
            this.props.resourcesToRemove(resourcesToRemove);
            return this;
        }

        public Builder status(String status) {
            this.props.status(status);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder trafficPercentageToMonitor(Number trafficPercentageToMonitor) {
            this.props.trafficPercentageToMonitor(trafficPercentageToMonitor);
            return this;
        }

        public CfnMonitor build() {
            return new CfnMonitor(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_internetmonitor.CfnMonitor.S3ConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3ConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBucketName() {
            return null;
        }

        @Nullable
        default public String getBucketPrefix() {
            return null;
        }

        @Nullable
        default public String getLogDeliveryStatus() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3ConfigProperty> {
            String bucketName;
            String bucketPrefix;
            String logDeliveryStatus;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public Builder bucketPrefix(String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            public Builder logDeliveryStatus(String logDeliveryStatus) {
                this.logDeliveryStatus = logDeliveryStatus;
                return this;
            }

            public S3ConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_internetmonitor.CfnMonitor.LocalHealthEventsConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LocalHealthEventsConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getHealthScoreThreshold() {
            return null;
        }

        @Nullable
        default public Number getMinTrafficImpact() {
            return null;
        }

        @Nullable
        default public String getStatus() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LocalHealthEventsConfigProperty> {
            Number healthScoreThreshold;
            Number minTrafficImpact;
            String status;

            public Builder healthScoreThreshold(Number healthScoreThreshold) {
                this.healthScoreThreshold = healthScoreThreshold;
                return this;
            }

            public Builder minTrafficImpact(Number minTrafficImpact) {
                this.minTrafficImpact = minTrafficImpact;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public LocalHealthEventsConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_internetmonitor.CfnMonitor.InternetMeasurementsLogDeliveryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InternetMeasurementsLogDeliveryProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getS3Config() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InternetMeasurementsLogDeliveryProperty> {
            Object s3Config;

            public Builder s3Config(IResolvable s3Config) {
                this.s3Config = s3Config;
                return this;
            }

            public Builder s3Config(S3ConfigProperty s3Config) {
                this.s3Config = s3Config;
                return this;
            }

            public InternetMeasurementsLogDeliveryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_internetmonitor.CfnMonitor.HealthEventsConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HealthEventsConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAvailabilityLocalHealthEventsConfig() {
            return null;
        }

        @Nullable
        default public Number getAvailabilityScoreThreshold() {
            return null;
        }

        @Nullable
        default public Object getPerformanceLocalHealthEventsConfig() {
            return null;
        }

        @Nullable
        default public Number getPerformanceScoreThreshold() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HealthEventsConfigProperty> {
            Object availabilityLocalHealthEventsConfig;
            Number availabilityScoreThreshold;
            Object performanceLocalHealthEventsConfig;
            Number performanceScoreThreshold;

            public Builder availabilityLocalHealthEventsConfig(IResolvable availabilityLocalHealthEventsConfig) {
                this.availabilityLocalHealthEventsConfig = availabilityLocalHealthEventsConfig;
                return this;
            }

            public Builder availabilityLocalHealthEventsConfig(LocalHealthEventsConfigProperty availabilityLocalHealthEventsConfig) {
                this.availabilityLocalHealthEventsConfig = availabilityLocalHealthEventsConfig;
                return this;
            }

            public Builder availabilityScoreThreshold(Number availabilityScoreThreshold) {
                this.availabilityScoreThreshold = availabilityScoreThreshold;
                return this;
            }

            public Builder performanceLocalHealthEventsConfig(IResolvable performanceLocalHealthEventsConfig) {
                this.performanceLocalHealthEventsConfig = performanceLocalHealthEventsConfig;
                return this;
            }

            public Builder performanceLocalHealthEventsConfig(LocalHealthEventsConfigProperty performanceLocalHealthEventsConfig) {
                this.performanceLocalHealthEventsConfig = performanceLocalHealthEventsConfig;
                return this;
            }

            public Builder performanceScoreThreshold(Number performanceScoreThreshold) {
                this.performanceScoreThreshold = performanceScoreThreshold;
                return this;
            }

            public HealthEventsConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

