/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.lambda.CfnFunction;
import software.amazon.awscdk.services.lambda.CfnFunctionProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_lambda.CfnFunction")
public class CfnFunction
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFunction.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnFunction(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFunction(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFunction(@NotNull Construct scope, @NotNull String id, @NotNull CfnFunctionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResolvable getAttrSnapStartResponse() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrSnapStartResponse", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public String getAttrSnapStartResponseApplyOn() {
        return (String)Kernel.get((Object)this, (String)"attrSnapStartResponseApplyOn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrSnapStartResponseOptimizationStatus() {
        return (String)Kernel.get((Object)this, (String)"attrSnapStartResponseOptimizationStatus", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getCode() {
        return Kernel.get((Object)this, (String)"code", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCode(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"code", (Object)Objects.requireNonNull(value, "code is required"));
    }

    public void setCode(@NotNull CodeProperty value) {
        Kernel.set((Object)this, (String)"code", (Object)Objects.requireNonNull(value, "code is required"));
    }

    @NotNull
    public String getRole() {
        return (String)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(String.class));
    }

    public void setRole(@NotNull String value) {
        Kernel.set((Object)this, (String)"role", (Object)Objects.requireNonNull(value, "role is required"));
    }

    @Nullable
    public List<String> getArchitectures() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"architectures", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setArchitectures(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"architectures", value);
    }

    @Nullable
    public String getCodeSigningConfigArn() {
        return (String)Kernel.get((Object)this, (String)"codeSigningConfigArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setCodeSigningConfigArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"codeSigningConfigArn", (Object)value);
    }

    @Nullable
    public Object getDeadLetterConfig() {
        return Kernel.get((Object)this, (String)"deadLetterConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDeadLetterConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"deadLetterConfig", (Object)value);
    }

    public void setDeadLetterConfig(@Nullable DeadLetterConfigProperty value) {
        Kernel.set((Object)this, (String)"deadLetterConfig", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getEnvironment() {
        return Kernel.get((Object)this, (String)"environment", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnvironment(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"environment", (Object)value);
    }

    public void setEnvironment(@Nullable EnvironmentProperty value) {
        Kernel.set((Object)this, (String)"environment", (Object)value);
    }

    @Nullable
    public Object getEphemeralStorage() {
        return Kernel.get((Object)this, (String)"ephemeralStorage", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEphemeralStorage(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"ephemeralStorage", (Object)value);
    }

    public void setEphemeralStorage(@Nullable EphemeralStorageProperty value) {
        Kernel.set((Object)this, (String)"ephemeralStorage", (Object)value);
    }

    @Nullable
    public Object getFileSystemConfigs() {
        return Kernel.get((Object)this, (String)"fileSystemConfigs", (NativeType)NativeType.forClass(Object.class));
    }

    public void setFileSystemConfigs(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"fileSystemConfigs", (Object)value);
    }

    public void setFileSystemConfigs(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof FileSystemConfigProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.lambda.CfnFunction.FileSystemConfigProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"fileSystemConfigs", value);
    }

    @Nullable
    public String getFunctionName() {
        return (String)Kernel.get((Object)this, (String)"functionName", (NativeType)NativeType.forClass(String.class));
    }

    public void setFunctionName(@Nullable String value) {
        Kernel.set((Object)this, (String)"functionName", (Object)value);
    }

    @Nullable
    public String getHandler() {
        return (String)Kernel.get((Object)this, (String)"handler", (NativeType)NativeType.forClass(String.class));
    }

    public void setHandler(@Nullable String value) {
        Kernel.set((Object)this, (String)"handler", (Object)value);
    }

    @Nullable
    public Object getImageConfig() {
        return Kernel.get((Object)this, (String)"imageConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setImageConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"imageConfig", (Object)value);
    }

    public void setImageConfig(@Nullable ImageConfigProperty value) {
        Kernel.set((Object)this, (String)"imageConfig", (Object)value);
    }

    @Nullable
    public String getKmsKeyArn() {
        return (String)Kernel.get((Object)this, (String)"kmsKeyArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsKeyArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"kmsKeyArn", (Object)value);
    }

    @Nullable
    public List<String> getLayers() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"layers", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setLayers(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"layers", value);
    }

    @Nullable
    public Number getMemorySize() {
        return (Number)Kernel.get((Object)this, (String)"memorySize", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMemorySize(@Nullable Number value) {
        Kernel.set((Object)this, (String)"memorySize", (Object)value);
    }

    @Nullable
    public String getPackageType() {
        return (String)Kernel.get((Object)this, (String)"packageType", (NativeType)NativeType.forClass(String.class));
    }

    public void setPackageType(@Nullable String value) {
        Kernel.set((Object)this, (String)"packageType", (Object)value);
    }

    @Nullable
    public Object getPolicy() {
        return Kernel.get((Object)this, (String)"policy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPolicy(@Nullable Object value) {
        Kernel.set((Object)this, (String)"policy", (Object)value);
    }

    @Nullable
    public Number getReservedConcurrentExecutions() {
        return (Number)Kernel.get((Object)this, (String)"reservedConcurrentExecutions", (NativeType)NativeType.forClass(Number.class));
    }

    public void setReservedConcurrentExecutions(@Nullable Number value) {
        Kernel.set((Object)this, (String)"reservedConcurrentExecutions", (Object)value);
    }

    @Nullable
    public String getRuntime() {
        return (String)Kernel.get((Object)this, (String)"runtime", (NativeType)NativeType.forClass(String.class));
    }

    public void setRuntime(@Nullable String value) {
        Kernel.set((Object)this, (String)"runtime", (Object)value);
    }

    @Nullable
    public Object getRuntimeManagementConfig() {
        return Kernel.get((Object)this, (String)"runtimeManagementConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRuntimeManagementConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"runtimeManagementConfig", (Object)value);
    }

    public void setRuntimeManagementConfig(@Nullable RuntimeManagementConfigProperty value) {
        Kernel.set((Object)this, (String)"runtimeManagementConfig", (Object)value);
    }

    @Nullable
    public Object getSnapStart() {
        return Kernel.get((Object)this, (String)"snapStart", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSnapStart(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"snapStart", (Object)value);
    }

    public void setSnapStart(@Nullable SnapStartProperty value) {
        Kernel.set((Object)this, (String)"snapStart", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Nullable
    public Number getTimeout() {
        return (Number)Kernel.get((Object)this, (String)"timeout", (NativeType)NativeType.forClass(Number.class));
    }

    public void setTimeout(@Nullable Number value) {
        Kernel.set((Object)this, (String)"timeout", (Object)value);
    }

    @Nullable
    public Object getTracingConfig() {
        return Kernel.get((Object)this, (String)"tracingConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTracingConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"tracingConfig", (Object)value);
    }

    public void setTracingConfig(@Nullable TracingConfigProperty value) {
        Kernel.set((Object)this, (String)"tracingConfig", (Object)value);
    }

    @Nullable
    public Object getVpcConfig() {
        return Kernel.get((Object)this, (String)"vpcConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVpcConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"vpcConfig", (Object)value);
    }

    public void setVpcConfig(@Nullable VpcConfigProperty value) {
        Kernel.set((Object)this, (String)"vpcConfig", (Object)value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_lambda.CfnFunction.FileSystemConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FileSystemConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getArn();

        @NotNull
        public String getLocalMountPath();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FileSystemConfigProperty> {
            String arn;
            String localMountPath;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder localMountPath(String localMountPath) {
                this.localMountPath = localMountPath;
                return this;
            }

            public FileSystemConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFunction> {
        private final Construct scope;
        private final String id;
        private final CfnFunctionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnFunctionProps.Builder();
        }

        public Builder code(IResolvable code) {
            this.props.code(code);
            return this;
        }

        public Builder code(CodeProperty code) {
            this.props.code(code);
            return this;
        }

        public Builder role(String role) {
            this.props.role(role);
            return this;
        }

        public Builder architectures(List<String> architectures) {
            this.props.architectures(architectures);
            return this;
        }

        public Builder codeSigningConfigArn(String codeSigningConfigArn) {
            this.props.codeSigningConfigArn(codeSigningConfigArn);
            return this;
        }

        public Builder deadLetterConfig(IResolvable deadLetterConfig) {
            this.props.deadLetterConfig(deadLetterConfig);
            return this;
        }

        public Builder deadLetterConfig(DeadLetterConfigProperty deadLetterConfig) {
            this.props.deadLetterConfig(deadLetterConfig);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder environment(IResolvable environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder environment(EnvironmentProperty environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder ephemeralStorage(IResolvable ephemeralStorage) {
            this.props.ephemeralStorage(ephemeralStorage);
            return this;
        }

        public Builder ephemeralStorage(EphemeralStorageProperty ephemeralStorage) {
            this.props.ephemeralStorage(ephemeralStorage);
            return this;
        }

        public Builder fileSystemConfigs(IResolvable fileSystemConfigs) {
            this.props.fileSystemConfigs(fileSystemConfigs);
            return this;
        }

        public Builder fileSystemConfigs(List<? extends Object> fileSystemConfigs) {
            this.props.fileSystemConfigs(fileSystemConfigs);
            return this;
        }

        public Builder functionName(String functionName) {
            this.props.functionName(functionName);
            return this;
        }

        public Builder handler(String handler) {
            this.props.handler(handler);
            return this;
        }

        public Builder imageConfig(IResolvable imageConfig) {
            this.props.imageConfig(imageConfig);
            return this;
        }

        public Builder imageConfig(ImageConfigProperty imageConfig) {
            this.props.imageConfig(imageConfig);
            return this;
        }

        public Builder kmsKeyArn(String kmsKeyArn) {
            this.props.kmsKeyArn(kmsKeyArn);
            return this;
        }

        public Builder layers(List<String> layers) {
            this.props.layers(layers);
            return this;
        }

        public Builder memorySize(Number memorySize) {
            this.props.memorySize(memorySize);
            return this;
        }

        public Builder packageType(String packageType) {
            this.props.packageType(packageType);
            return this;
        }

        public Builder policy(Object policy) {
            this.props.policy(policy);
            return this;
        }

        public Builder reservedConcurrentExecutions(Number reservedConcurrentExecutions) {
            this.props.reservedConcurrentExecutions(reservedConcurrentExecutions);
            return this;
        }

        public Builder runtime(String runtime) {
            this.props.runtime(runtime);
            return this;
        }

        public Builder runtimeManagementConfig(IResolvable runtimeManagementConfig) {
            this.props.runtimeManagementConfig(runtimeManagementConfig);
            return this;
        }

        public Builder runtimeManagementConfig(RuntimeManagementConfigProperty runtimeManagementConfig) {
            this.props.runtimeManagementConfig(runtimeManagementConfig);
            return this;
        }

        public Builder snapStart(IResolvable snapStart) {
            this.props.snapStart(snapStart);
            return this;
        }

        public Builder snapStart(SnapStartProperty snapStart) {
            this.props.snapStart(snapStart);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder timeout(Number timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder tracingConfig(IResolvable tracingConfig) {
            this.props.tracingConfig(tracingConfig);
            return this;
        }

        public Builder tracingConfig(TracingConfigProperty tracingConfig) {
            this.props.tracingConfig(tracingConfig);
            return this;
        }

        public Builder vpcConfig(IResolvable vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public Builder vpcConfig(VpcConfigProperty vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public CfnFunction build() {
            return new CfnFunction(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_lambda.CfnFunction.VpcConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getIpv6AllowedForDualStack() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroupIds() {
            return null;
        }

        @Nullable
        default public List<String> getSubnetIds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcConfigProperty> {
            Object ipv6AllowedForDualStack;
            List<String> securityGroupIds;
            List<String> subnetIds;

            public Builder ipv6AllowedForDualStack(Boolean ipv6AllowedForDualStack) {
                this.ipv6AllowedForDualStack = ipv6AllowedForDualStack;
                return this;
            }

            public Builder ipv6AllowedForDualStack(IResolvable ipv6AllowedForDualStack) {
                this.ipv6AllowedForDualStack = ipv6AllowedForDualStack;
                return this;
            }

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public VpcConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_lambda.CfnFunction.TracingConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TracingConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TracingConfigProperty> {
            String mode;

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public TracingConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_lambda.CfnFunction.SnapStartResponseProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SnapStartResponseProperty
    extends JsiiSerializable {
        @Nullable
        default public String getApplyOn() {
            return null;
        }

        @Nullable
        default public String getOptimizationStatus() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SnapStartResponseProperty> {
            String applyOn;
            String optimizationStatus;

            public Builder applyOn(String applyOn) {
                this.applyOn = applyOn;
                return this;
            }

            public Builder optimizationStatus(String optimizationStatus) {
                this.optimizationStatus = optimizationStatus;
                return this;
            }

            public SnapStartResponseProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_lambda.CfnFunction.SnapStartProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SnapStartProperty
    extends JsiiSerializable {
        @NotNull
        public String getApplyOn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SnapStartProperty> {
            String applyOn;

            public Builder applyOn(String applyOn) {
                this.applyOn = applyOn;
                return this;
            }

            public SnapStartProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_lambda.CfnFunction.RuntimeManagementConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RuntimeManagementConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getUpdateRuntimeOn();

        @Nullable
        default public String getRuntimeVersionArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RuntimeManagementConfigProperty> {
            String updateRuntimeOn;
            String runtimeVersionArn;

            public Builder updateRuntimeOn(String updateRuntimeOn) {
                this.updateRuntimeOn = updateRuntimeOn;
                return this;
            }

            public Builder runtimeVersionArn(String runtimeVersionArn) {
                this.runtimeVersionArn = runtimeVersionArn;
                return this;
            }

            public RuntimeManagementConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_lambda.CfnFunction.ImageConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ImageConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getCommand() {
            return null;
        }

        @Nullable
        default public List<String> getEntryPoint() {
            return null;
        }

        @Nullable
        default public String getWorkingDirectory() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ImageConfigProperty> {
            List<String> command;
            List<String> entryPoint;
            String workingDirectory;

            public Builder command(List<String> command) {
                this.command = command;
                return this;
            }

            public Builder entryPoint(List<String> entryPoint) {
                this.entryPoint = entryPoint;
                return this;
            }

            public Builder workingDirectory(String workingDirectory) {
                this.workingDirectory = workingDirectory;
                return this;
            }

            public ImageConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_lambda.CfnFunction.EphemeralStorageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EphemeralStorageProperty
    extends JsiiSerializable {
        @NotNull
        public Number getSize();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EphemeralStorageProperty> {
            Number size;

            public Builder size(Number size) {
                this.size = size;
                return this;
            }

            public EphemeralStorageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_lambda.CfnFunction.EnvironmentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnvironmentProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getVariables() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnvironmentProperty> {
            Object variables;

            public Builder variables(IResolvable variables) {
                this.variables = variables;
                return this;
            }

            public Builder variables(Map<String, String> variables) {
                this.variables = variables;
                return this;
            }

            public EnvironmentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_lambda.CfnFunction.DeadLetterConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeadLetterConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getTargetArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeadLetterConfigProperty> {
            String targetArn;

            public Builder targetArn(String targetArn) {
                this.targetArn = targetArn;
                return this;
            }

            public DeadLetterConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_lambda.CfnFunction.CodeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CodeProperty
    extends JsiiSerializable {
        @Nullable
        default public String getImageUri() {
            return null;
        }

        @Nullable
        default public String getS3Bucket() {
            return null;
        }

        @Nullable
        default public String getS3Key() {
            return null;
        }

        @Nullable
        default public String getS3ObjectVersion() {
            return null;
        }

        @Nullable
        default public String getZipFile() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CodeProperty> {
            String imageUri;
            String s3Bucket;
            String s3Key;
            String s3ObjectVersion;
            String zipFile;

            public Builder imageUri(String imageUri) {
                this.imageUri = imageUri;
                return this;
            }

            public Builder s3Bucket(String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            public Builder s3Key(String s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            public Builder s3ObjectVersion(String s3ObjectVersion) {
                this.s3ObjectVersion = s3ObjectVersion;
                return this;
            }

            public Builder zipFile(String zipFile) {
                this.zipFile = zipFile;
                return this;
            }

            public CodeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

