/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.codepipeline.CfnPipeline;
import software.amazon.awscdk.services.codepipeline.CfnPipelineProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codepipeline.CfnPipeline")
public class CfnPipeline
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnPipeline.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnPipeline(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPipeline(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnPipeline(@NotNull Construct scope, @NotNull String id, @NotNull CfnPipelineProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrVersion() {
        return (String)Kernel.get((Object)this, (String)"attrVersion", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getRoleArn() {
        return (String)Kernel.get((Object)this, (String)"roleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setRoleArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"roleArn", (Object)Objects.requireNonNull(value, "roleArn is required"));
    }

    @NotNull
    public Object getStages() {
        return Kernel.get((Object)this, (String)"stages", (NativeType)NativeType.forClass(Object.class));
    }

    public void setStages(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"stages", (Object)Objects.requireNonNull(value, "stages is required"));
    }

    public void setStages(@NotNull List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof StageDeclarationProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.codepipeline.CfnPipeline.StageDeclarationProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"stages", Objects.requireNonNull(value, "stages is required"));
    }

    @Nullable
    public Object getArtifactStore() {
        return Kernel.get((Object)this, (String)"artifactStore", (NativeType)NativeType.forClass(Object.class));
    }

    public void setArtifactStore(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"artifactStore", (Object)value);
    }

    public void setArtifactStore(@Nullable ArtifactStoreProperty value) {
        Kernel.set((Object)this, (String)"artifactStore", (Object)value);
    }

    @Nullable
    public Object getArtifactStores() {
        return Kernel.get((Object)this, (String)"artifactStores", (NativeType)NativeType.forClass(Object.class));
    }

    public void setArtifactStores(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"artifactStores", (Object)value);
    }

    public void setArtifactStores(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof ArtifactStoreMapProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.codepipeline.CfnPipeline.ArtifactStoreMapProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"artifactStores", value);
    }

    @Nullable
    public Object getDisableInboundStageTransitions() {
        return Kernel.get((Object)this, (String)"disableInboundStageTransitions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDisableInboundStageTransitions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"disableInboundStageTransitions", (Object)value);
    }

    public void setDisableInboundStageTransitions(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof StageTransitionProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.codepipeline.CfnPipeline.StageTransitionProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"disableInboundStageTransitions", value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    @Nullable
    public String getPipelineType() {
        return (String)Kernel.get((Object)this, (String)"pipelineType", (NativeType)NativeType.forClass(String.class));
    }

    public void setPipelineType(@Nullable String value) {
        Kernel.set((Object)this, (String)"pipelineType", (Object)value);
    }

    @Nullable
    public Object getRestartExecutionOnUpdate() {
        return Kernel.get((Object)this, (String)"restartExecutionOnUpdate", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRestartExecutionOnUpdate(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"restartExecutionOnUpdate", (Object)value);
    }

    public void setRestartExecutionOnUpdate(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"restartExecutionOnUpdate", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Nullable
    public Object getTriggers() {
        return Kernel.get((Object)this, (String)"triggers", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTriggers(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"triggers", (Object)value);
    }

    public void setTriggers(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof PipelineTriggerDeclarationProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.codepipeline.CfnPipeline.PipelineTriggerDeclarationProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"triggers", value);
    }

    @Nullable
    public Object getVariables() {
        return Kernel.get((Object)this, (String)"variables", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVariables(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"variables", (Object)value);
    }

    public void setVariables(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof VariableDeclarationProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.codepipeline.CfnPipeline.VariableDeclarationProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"variables", value);
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codepipeline.CfnPipeline.StageDeclarationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StageDeclarationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getActions();

        @NotNull
        public String getName();

        @Nullable
        default public Object getBlockers() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StageDeclarationProperty> {
            Object actions;
            String name;
            Object blockers;

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder blockers(IResolvable blockers) {
                this.blockers = blockers;
                return this;
            }

            public Builder blockers(List<? extends Object> blockers) {
                this.blockers = blockers;
                return this;
            }

            public StageDeclarationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codepipeline.CfnPipeline.ArtifactStoreMapProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ArtifactStoreMapProperty
    extends JsiiSerializable {
        @NotNull
        public Object getArtifactStore();

        @NotNull
        public String getRegion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ArtifactStoreMapProperty> {
            Object artifactStore;
            String region;

            public Builder artifactStore(IResolvable artifactStore) {
                this.artifactStore = artifactStore;
                return this;
            }

            public Builder artifactStore(ArtifactStoreProperty artifactStore) {
                this.artifactStore = artifactStore;
                return this;
            }

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public ArtifactStoreMapProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codepipeline.CfnPipeline.StageTransitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StageTransitionProperty
    extends JsiiSerializable {
        @NotNull
        public String getReason();

        @NotNull
        public String getStageName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StageTransitionProperty> {
            String reason;
            String stageName;

            public Builder reason(String reason) {
                this.reason = reason;
                return this;
            }

            public Builder stageName(String stageName) {
                this.stageName = stageName;
                return this;
            }

            public StageTransitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codepipeline.CfnPipeline.PipelineTriggerDeclarationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipelineTriggerDeclarationProperty
    extends JsiiSerializable {
        @NotNull
        public String getProviderType();

        @Nullable
        default public Object getGitConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipelineTriggerDeclarationProperty> {
            String providerType;
            Object gitConfiguration;

            public Builder providerType(String providerType) {
                this.providerType = providerType;
                return this;
            }

            public Builder gitConfiguration(IResolvable gitConfiguration) {
                this.gitConfiguration = gitConfiguration;
                return this;
            }

            public Builder gitConfiguration(GitConfigurationProperty gitConfiguration) {
                this.gitConfiguration = gitConfiguration;
                return this;
            }

            public PipelineTriggerDeclarationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codepipeline.CfnPipeline.VariableDeclarationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VariableDeclarationProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @Nullable
        default public String getDefaultValue() {
            return null;
        }

        @Nullable
        default public String getDescription() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VariableDeclarationProperty> {
            String name;
            String defaultValue;
            String description;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder defaultValue(String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public VariableDeclarationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnPipeline> {
        private final Construct scope;
        private final String id;
        private final CfnPipelineProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnPipelineProps.Builder();
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder stages(IResolvable stages) {
            this.props.stages(stages);
            return this;
        }

        public Builder stages(List<? extends Object> stages) {
            this.props.stages(stages);
            return this;
        }

        public Builder artifactStore(IResolvable artifactStore) {
            this.props.artifactStore(artifactStore);
            return this;
        }

        public Builder artifactStore(ArtifactStoreProperty artifactStore) {
            this.props.artifactStore(artifactStore);
            return this;
        }

        public Builder artifactStores(IResolvable artifactStores) {
            this.props.artifactStores(artifactStores);
            return this;
        }

        public Builder artifactStores(List<? extends Object> artifactStores) {
            this.props.artifactStores(artifactStores);
            return this;
        }

        public Builder disableInboundStageTransitions(IResolvable disableInboundStageTransitions) {
            this.props.disableInboundStageTransitions(disableInboundStageTransitions);
            return this;
        }

        public Builder disableInboundStageTransitions(List<? extends Object> disableInboundStageTransitions) {
            this.props.disableInboundStageTransitions(disableInboundStageTransitions);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder pipelineType(String pipelineType) {
            this.props.pipelineType(pipelineType);
            return this;
        }

        public Builder restartExecutionOnUpdate(Boolean restartExecutionOnUpdate) {
            this.props.restartExecutionOnUpdate(restartExecutionOnUpdate);
            return this;
        }

        public Builder restartExecutionOnUpdate(IResolvable restartExecutionOnUpdate) {
            this.props.restartExecutionOnUpdate(restartExecutionOnUpdate);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder triggers(IResolvable triggers) {
            this.props.triggers(triggers);
            return this;
        }

        public Builder triggers(List<? extends Object> triggers) {
            this.props.triggers(triggers);
            return this;
        }

        public Builder variables(IResolvable variables) {
            this.props.variables(variables);
            return this;
        }

        public Builder variables(List<? extends Object> variables) {
            this.props.variables(variables);
            return this;
        }

        public CfnPipeline build() {
            return new CfnPipeline(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codepipeline.CfnPipeline.OutputArtifactProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OutputArtifactProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OutputArtifactProperty> {
            String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public OutputArtifactProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codepipeline.CfnPipeline.InputArtifactProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputArtifactProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputArtifactProperty> {
            String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public InputArtifactProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codepipeline.CfnPipeline.GitTagFilterCriteriaProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GitTagFilterCriteriaProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getExcludes() {
            return null;
        }

        @Nullable
        default public List<String> getIncludes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GitTagFilterCriteriaProperty> {
            List<String> excludes;
            List<String> includes;

            public Builder excludes(List<String> excludes) {
                this.excludes = excludes;
                return this;
            }

            public Builder includes(List<String> includes) {
                this.includes = includes;
                return this;
            }

            public GitTagFilterCriteriaProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codepipeline.CfnPipeline.GitPushFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GitPushFilterProperty
    extends JsiiSerializable {
        @Nullable
        default public GitTagFilterCriteriaProperty getTags() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GitPushFilterProperty> {
            GitTagFilterCriteriaProperty tags;

            public Builder tags(GitTagFilterCriteriaProperty tags) {
                this.tags = tags;
                return this;
            }

            public GitPushFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codepipeline.CfnPipeline.GitConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GitConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getSourceActionName();

        @Nullable
        default public Object getPush() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GitConfigurationProperty> {
            String sourceActionName;
            Object push;

            public Builder sourceActionName(String sourceActionName) {
                this.sourceActionName = sourceActionName;
                return this;
            }

            public Builder push(IResolvable push) {
                this.push = push;
                return this;
            }

            public Builder push(List<? extends Object> push) {
                this.push = push;
                return this;
            }

            public GitConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codepipeline.CfnPipeline.EncryptionKeyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionKeyProperty
    extends JsiiSerializable {
        @NotNull
        public String getId();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncryptionKeyProperty> {
            String id;
            String type;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public EncryptionKeyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codepipeline.CfnPipeline.BlockerDeclarationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BlockerDeclarationProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BlockerDeclarationProperty> {
            String name;
            String type;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public BlockerDeclarationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codepipeline.CfnPipeline.ArtifactStoreProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ArtifactStoreProperty
    extends JsiiSerializable {
        @NotNull
        public String getLocation();

        @NotNull
        public String getType();

        @Nullable
        default public Object getEncryptionKey() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ArtifactStoreProperty> {
            String location;
            String type;
            Object encryptionKey;

            public Builder location(String location) {
                this.location = location;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder encryptionKey(IResolvable encryptionKey) {
                this.encryptionKey = encryptionKey;
                return this;
            }

            public Builder encryptionKey(EncryptionKeyProperty encryptionKey) {
                this.encryptionKey = encryptionKey;
                return this;
            }

            public ArtifactStoreProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codepipeline.CfnPipeline.ActionTypeIdProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ActionTypeIdProperty
    extends JsiiSerializable {
        @NotNull
        public String getCategory();

        @NotNull
        public String getOwner();

        @NotNull
        public String getProvider();

        @NotNull
        public String getVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ActionTypeIdProperty> {
            String category;
            String owner;
            String provider;
            String version;

            public Builder category(String category) {
                this.category = category;
                return this;
            }

            public Builder owner(String owner) {
                this.owner = owner;
                return this;
            }

            public Builder provider(String provider) {
                this.provider = provider;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public ActionTypeIdProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codepipeline.CfnPipeline.ActionDeclarationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ActionDeclarationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getActionTypeId();

        @NotNull
        public String getName();

        @Nullable
        default public Object getConfiguration() {
            return null;
        }

        @Nullable
        default public Object getInputArtifacts() {
            return null;
        }

        @Nullable
        default public String getNamespace() {
            return null;
        }

        @Nullable
        default public Object getOutputArtifacts() {
            return null;
        }

        @Nullable
        default public String getRegion() {
            return null;
        }

        @Nullable
        default public String getRoleArn() {
            return null;
        }

        @Nullable
        default public Number getRunOrder() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ActionDeclarationProperty> {
            Object actionTypeId;
            String name;
            Object configuration;
            Object inputArtifacts;
            String namespace;
            Object outputArtifacts;
            String region;
            String roleArn;
            Number runOrder;

            public Builder actionTypeId(IResolvable actionTypeId) {
                this.actionTypeId = actionTypeId;
                return this;
            }

            public Builder actionTypeId(ActionTypeIdProperty actionTypeId) {
                this.actionTypeId = actionTypeId;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder configuration(Object configuration) {
                this.configuration = configuration;
                return this;
            }

            public Builder inputArtifacts(IResolvable inputArtifacts) {
                this.inputArtifacts = inputArtifacts;
                return this;
            }

            public Builder inputArtifacts(List<? extends Object> inputArtifacts) {
                this.inputArtifacts = inputArtifacts;
                return this;
            }

            public Builder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public Builder outputArtifacts(IResolvable outputArtifacts) {
                this.outputArtifacts = outputArtifacts;
                return this;
            }

            public Builder outputArtifacts(List<? extends Object> outputArtifacts) {
                this.outputArtifacts = outputArtifacts;
                return this;
            }

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder runOrder(Number runOrder) {
                this.runOrder = runOrder;
                return this;
            }

            public ActionDeclarationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

