/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs.patterns;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.applicationautoscaling.ScalingInterval;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.CapacityProviderStrategy;
import software.amazon.awscdk.services.ecs.ContainerImage;
import software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker;
import software.amazon.awscdk.services.ecs.DeploymentController;
import software.amazon.awscdk.services.ecs.FargatePlatformVersion;
import software.amazon.awscdk.services.ecs.FargateService;
import software.amazon.awscdk.services.ecs.FargateTaskDefinition;
import software.amazon.awscdk.services.ecs.HealthCheck;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.LogDriver;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.RuntimePlatform;
import software.amazon.awscdk.services.ecs.Secret;
import software.amazon.awscdk.services.ecs.patterns.QueueProcessingFargateServiceProps;
import software.amazon.awscdk.services.ecs.patterns.QueueProcessingServiceBase;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ecs_patterns.QueueProcessingFargateService")
public class QueueProcessingFargateService
extends QueueProcessingServiceBase {
    protected QueueProcessingFargateService(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected QueueProcessingFargateService(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public QueueProcessingFargateService(@NotNull Construct scope, @NotNull String id, @Nullable QueueProcessingFargateServiceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public QueueProcessingFargateService(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public FargateService getService() {
        return (FargateService)Kernel.get((Object)((Object)this), (String)"service", (NativeType)NativeType.forClass(FargateService.class));
    }

    @NotNull
    public FargateTaskDefinition getTaskDefinition() {
        return (FargateTaskDefinition)Kernel.get((Object)((Object)this), (String)"taskDefinition", (NativeType)NativeType.forClass(FargateTaskDefinition.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<QueueProcessingFargateService> {
        private final Construct scope;
        private final String id;
        private QueueProcessingFargateServiceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder capacityProviderStrategies(List<? extends CapacityProviderStrategy> capacityProviderStrategies) {
            this.props().capacityProviderStrategies(capacityProviderStrategies);
            return this;
        }

        public Builder circuitBreaker(DeploymentCircuitBreaker circuitBreaker) {
            this.props().circuitBreaker(circuitBreaker);
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.props().cluster(cluster);
            return this;
        }

        public Builder command(List<String> command) {
            this.props().command(command);
            return this;
        }

        public Builder cooldown(Duration cooldown) {
            this.props().cooldown(cooldown);
            return this;
        }

        public Builder cpuTargetUtilizationPercent(Number cpuTargetUtilizationPercent) {
            this.props().cpuTargetUtilizationPercent(cpuTargetUtilizationPercent);
            return this;
        }

        public Builder deploymentController(DeploymentController deploymentController) {
            this.props().deploymentController(deploymentController);
            return this;
        }

        public Builder disableCpuBasedScaling(Boolean disableCpuBasedScaling) {
            this.props().disableCpuBasedScaling(disableCpuBasedScaling);
            return this;
        }

        public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.props().enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        public Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.props().enableExecuteCommand(enableExecuteCommand);
            return this;
        }

        public Builder enableLogging(Boolean enableLogging) {
            this.props().enableLogging(enableLogging);
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.props().environment(environment);
            return this;
        }

        public Builder family(String family) {
            this.props().family(family);
            return this;
        }

        public Builder image(ContainerImage image) {
            this.props().image(image);
            return this;
        }

        public Builder logDriver(LogDriver logDriver) {
            this.props().logDriver(logDriver);
            return this;
        }

        public Builder maxHealthyPercent(Number maxHealthyPercent) {
            this.props().maxHealthyPercent(maxHealthyPercent);
            return this;
        }

        public Builder maxReceiveCount(Number maxReceiveCount) {
            this.props().maxReceiveCount(maxReceiveCount);
            return this;
        }

        public Builder maxScalingCapacity(Number maxScalingCapacity) {
            this.props().maxScalingCapacity(maxScalingCapacity);
            return this;
        }

        public Builder minHealthyPercent(Number minHealthyPercent) {
            this.props().minHealthyPercent(minHealthyPercent);
            return this;
        }

        public Builder minScalingCapacity(Number minScalingCapacity) {
            this.props().minScalingCapacity(minScalingCapacity);
            return this;
        }

        public Builder propagateTags(PropagatedTagSource propagateTags) {
            this.props().propagateTags(propagateTags);
            return this;
        }

        public Builder queue(IQueue queue) {
            this.props().queue(queue);
            return this;
        }

        public Builder retentionPeriod(Duration retentionPeriod) {
            this.props().retentionPeriod(retentionPeriod);
            return this;
        }

        public Builder scalingSteps(List<? extends ScalingInterval> scalingSteps) {
            this.props().scalingSteps(scalingSteps);
            return this;
        }

        public Builder secrets(Map<String, ? extends Secret> secrets) {
            this.props().secrets(secrets);
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.props().serviceName(serviceName);
            return this;
        }

        public Builder visibilityTimeout(Duration visibilityTimeout) {
            this.props().visibilityTimeout(visibilityTimeout);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props().vpc(vpc);
            return this;
        }

        public Builder cpu(Number cpu) {
            this.props().cpu(cpu);
            return this;
        }

        public Builder memoryLimitMiB(Number memoryLimitMiB) {
            this.props().memoryLimitMiB(memoryLimitMiB);
            return this;
        }

        public Builder platformVersion(FargatePlatformVersion platformVersion) {
            this.props().platformVersion(platformVersion);
            return this;
        }

        public Builder runtimePlatform(RuntimePlatform runtimePlatform) {
            this.props().runtimePlatform(runtimePlatform);
            return this;
        }

        public Builder taskDefinition(FargateTaskDefinition taskDefinition) {
            this.props().taskDefinition(taskDefinition);
            return this;
        }

        public Builder assignPublicIp(Boolean assignPublicIp) {
            this.props().assignPublicIp(assignPublicIp);
            return this;
        }

        public Builder containerName(String containerName) {
            this.props().containerName(containerName);
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.props().healthCheck(healthCheck);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props().securityGroups(securityGroups);
            return this;
        }

        public Builder taskSubnets(SubnetSelection taskSubnets) {
            this.props().taskSubnets(taskSubnets);
            return this;
        }

        public QueueProcessingFargateService build() {
            return new QueueProcessingFargateService(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private QueueProcessingFargateServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new QueueProcessingFargateServiceProps.Builder();
            }
            return this.props;
        }
    }
}

