/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticache;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.elasticache.CfnServerlessCache;
import software.amazon.awscdk.services.elasticache.CfnServerlessCacheProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_elasticache.CfnServerlessCache")
public class CfnServerlessCache
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnServerlessCache.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnServerlessCache(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnServerlessCache(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnServerlessCache(@NotNull Construct scope, @NotNull String id, @NotNull CfnServerlessCacheProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCreateTime() {
        return (String)Kernel.get((Object)this, (String)"attrCreateTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrEndpointAddress() {
        return (String)Kernel.get((Object)this, (String)"attrEndpointAddress", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Number getAttrEndpointPort() {
        return (Number)Kernel.get((Object)this, (String)"attrEndpointPort", (NativeType)NativeType.forClass(Number.class));
    }

    @NotNull
    public String getAttrFullEngineVersion() {
        return (String)Kernel.get((Object)this, (String)"attrFullEngineVersion", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrReaderEndpointAddress() {
        return (String)Kernel.get((Object)this, (String)"attrReaderEndpointAddress", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Number getAttrReaderEndpointPort() {
        return (Number)Kernel.get((Object)this, (String)"attrReaderEndpointPort", (NativeType)NativeType.forClass(Number.class));
    }

    @NotNull
    public String getAttrStatus() {
        return (String)Kernel.get((Object)this, (String)"attrStatus", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getEngine() {
        return (String)Kernel.get((Object)this, (String)"engine", (NativeType)NativeType.forClass(String.class));
    }

    public void setEngine(@NotNull String value) {
        Kernel.set((Object)this, (String)"engine", (Object)Objects.requireNonNull(value, "engine is required"));
    }

    @NotNull
    public String getServerlessCacheName() {
        return (String)Kernel.get((Object)this, (String)"serverlessCacheName", (NativeType)NativeType.forClass(String.class));
    }

    public void setServerlessCacheName(@NotNull String value) {
        Kernel.set((Object)this, (String)"serverlessCacheName", (Object)Objects.requireNonNull(value, "serverlessCacheName is required"));
    }

    @Nullable
    public Object getCacheUsageLimits() {
        return Kernel.get((Object)this, (String)"cacheUsageLimits", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCacheUsageLimits(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"cacheUsageLimits", (Object)value);
    }

    public void setCacheUsageLimits(@Nullable CacheUsageLimitsProperty value) {
        Kernel.set((Object)this, (String)"cacheUsageLimits", (Object)value);
    }

    @Nullable
    public String getDailySnapshotTime() {
        return (String)Kernel.get((Object)this, (String)"dailySnapshotTime", (NativeType)NativeType.forClass(String.class));
    }

    public void setDailySnapshotTime(@Nullable String value) {
        Kernel.set((Object)this, (String)"dailySnapshotTime", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getEndpoint() {
        return Kernel.get((Object)this, (String)"endpoint", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEndpoint(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"endpoint", (Object)value);
    }

    public void setEndpoint(@Nullable EndpointProperty value) {
        Kernel.set((Object)this, (String)"endpoint", (Object)value);
    }

    @Nullable
    public String getFinalSnapshotName() {
        return (String)Kernel.get((Object)this, (String)"finalSnapshotName", (NativeType)NativeType.forClass(String.class));
    }

    public void setFinalSnapshotName(@Nullable String value) {
        Kernel.set((Object)this, (String)"finalSnapshotName", (Object)value);
    }

    @Nullable
    public String getKmsKeyId() {
        return (String)Kernel.get((Object)this, (String)"kmsKeyId", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsKeyId(@Nullable String value) {
        Kernel.set((Object)this, (String)"kmsKeyId", (Object)value);
    }

    @Nullable
    public String getMajorEngineVersion() {
        return (String)Kernel.get((Object)this, (String)"majorEngineVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setMajorEngineVersion(@Nullable String value) {
        Kernel.set((Object)this, (String)"majorEngineVersion", (Object)value);
    }

    @Nullable
    public Object getReaderEndpoint() {
        return Kernel.get((Object)this, (String)"readerEndpoint", (NativeType)NativeType.forClass(Object.class));
    }

    public void setReaderEndpoint(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"readerEndpoint", (Object)value);
    }

    public void setReaderEndpoint(@Nullable EndpointProperty value) {
        Kernel.set((Object)this, (String)"readerEndpoint", (Object)value);
    }

    @Nullable
    public List<String> getSecurityGroupIds() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"securityGroupIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSecurityGroupIds(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"securityGroupIds", value);
    }

    @Nullable
    public List<String> getSnapshotArnsToRestore() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"snapshotArnsToRestore", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSnapshotArnsToRestore(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"snapshotArnsToRestore", value);
    }

    @Nullable
    public Number getSnapshotRetentionLimit() {
        return (Number)Kernel.get((Object)this, (String)"snapshotRetentionLimit", (NativeType)NativeType.forClass(Number.class));
    }

    public void setSnapshotRetentionLimit(@Nullable Number value) {
        Kernel.set((Object)this, (String)"snapshotRetentionLimit", (Object)value);
    }

    @Nullable
    public List<String> getSubnetIds() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"subnetIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSubnetIds(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"subnetIds", value);
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    @Nullable
    public String getUserGroupId() {
        return (String)Kernel.get((Object)this, (String)"userGroupId", (NativeType)NativeType.forClass(String.class));
    }

    public void setUserGroupId(@Nullable String value) {
        Kernel.set((Object)this, (String)"userGroupId", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnServerlessCache> {
        private final Construct scope;
        private final String id;
        private final CfnServerlessCacheProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnServerlessCacheProps.Builder();
        }

        public Builder engine(String engine) {
            this.props.engine(engine);
            return this;
        }

        public Builder serverlessCacheName(String serverlessCacheName) {
            this.props.serverlessCacheName(serverlessCacheName);
            return this;
        }

        public Builder cacheUsageLimits(IResolvable cacheUsageLimits) {
            this.props.cacheUsageLimits(cacheUsageLimits);
            return this;
        }

        public Builder cacheUsageLimits(CacheUsageLimitsProperty cacheUsageLimits) {
            this.props.cacheUsageLimits(cacheUsageLimits);
            return this;
        }

        public Builder dailySnapshotTime(String dailySnapshotTime) {
            this.props.dailySnapshotTime(dailySnapshotTime);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder endpoint(IResolvable endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }

        public Builder endpoint(EndpointProperty endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }

        public Builder finalSnapshotName(String finalSnapshotName) {
            this.props.finalSnapshotName(finalSnapshotName);
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        public Builder majorEngineVersion(String majorEngineVersion) {
            this.props.majorEngineVersion(majorEngineVersion);
            return this;
        }

        public Builder readerEndpoint(IResolvable readerEndpoint) {
            this.props.readerEndpoint(readerEndpoint);
            return this;
        }

        public Builder readerEndpoint(EndpointProperty readerEndpoint) {
            this.props.readerEndpoint(readerEndpoint);
            return this;
        }

        public Builder securityGroupIds(List<String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        public Builder snapshotArnsToRestore(List<String> snapshotArnsToRestore) {
            this.props.snapshotArnsToRestore(snapshotArnsToRestore);
            return this;
        }

        public Builder snapshotRetentionLimit(Number snapshotRetentionLimit) {
            this.props.snapshotRetentionLimit(snapshotRetentionLimit);
            return this;
        }

        public Builder subnetIds(List<String> subnetIds) {
            this.props.subnetIds(subnetIds);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder userGroupId(String userGroupId) {
            this.props.userGroupId(userGroupId);
            return this;
        }

        public CfnServerlessCache build() {
            return new CfnServerlessCache(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_elasticache.CfnServerlessCache.EndpointProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EndpointProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAddress() {
            return null;
        }

        @Nullable
        default public Number getPort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EndpointProperty> {
            String address;
            Number port;

            public Builder address(String address) {
                this.address = address;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public EndpointProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_elasticache.CfnServerlessCache.ECPUPerSecondProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ECPUPerSecondProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaximum();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ECPUPerSecondProperty> {
            Number maximum;

            public Builder maximum(Number maximum) {
                this.maximum = maximum;
                return this;
            }

            public ECPUPerSecondProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_elasticache.CfnServerlessCache.DataStorageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataStorageProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaximum();

        @NotNull
        public String getUnit();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataStorageProperty> {
            Number maximum;
            String unit;

            public Builder maximum(Number maximum) {
                this.maximum = maximum;
                return this;
            }

            public Builder unit(String unit) {
                this.unit = unit;
                return this;
            }

            public DataStorageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_elasticache.CfnServerlessCache.CacheUsageLimitsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CacheUsageLimitsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDataStorage() {
            return null;
        }

        @Nullable
        default public Object getEcpuPerSecond() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CacheUsageLimitsProperty> {
            Object dataStorage;
            Object ecpuPerSecond;

            public Builder dataStorage(IResolvable dataStorage) {
                this.dataStorage = dataStorage;
                return this;
            }

            public Builder dataStorage(DataStorageProperty dataStorage) {
                this.dataStorage = dataStorage;
                return this;
            }

            public Builder ecpuPerSecond(IResolvable ecpuPerSecond) {
                this.ecpuPerSecond = ecpuPerSecond;
                return this;
            }

            public Builder ecpuPerSecond(ECPUPerSecondProperty ecpuPerSecond) {
                this.ecpuPerSecond = ecpuPerSecond;
                return this;
            }

            public CacheUsageLimitsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

