/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sagemaker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.sagemaker.CfnFeatureGroup;
import software.amazon.awscdk.services.sagemaker.CfnFeatureGroupProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup")
public class CfnFeatureGroup
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFeatureGroup.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnFeatureGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFeatureGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFeatureGroup(@NotNull Construct scope, @NotNull String id, @NotNull CfnFeatureGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCreationTime() {
        return (String)Kernel.get((Object)this, (String)"attrCreationTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrFeatureGroupStatus() {
        return (String)Kernel.get((Object)this, (String)"attrFeatureGroupStatus", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getEventTimeFeatureName() {
        return (String)Kernel.get((Object)this, (String)"eventTimeFeatureName", (NativeType)NativeType.forClass(String.class));
    }

    public void setEventTimeFeatureName(@NotNull String value) {
        Kernel.set((Object)this, (String)"eventTimeFeatureName", (Object)Objects.requireNonNull(value, "eventTimeFeatureName is required"));
    }

    @NotNull
    public Object getFeatureDefinitions() {
        return Kernel.get((Object)this, (String)"featureDefinitions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setFeatureDefinitions(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"featureDefinitions", (Object)Objects.requireNonNull(value, "featureDefinitions is required"));
    }

    public void setFeatureDefinitions(@NotNull List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof FeatureDefinitionProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.sagemaker.CfnFeatureGroup.FeatureDefinitionProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"featureDefinitions", Objects.requireNonNull(value, "featureDefinitions is required"));
    }

    @NotNull
    public String getFeatureGroupName() {
        return (String)Kernel.get((Object)this, (String)"featureGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setFeatureGroupName(@NotNull String value) {
        Kernel.set((Object)this, (String)"featureGroupName", (Object)Objects.requireNonNull(value, "featureGroupName is required"));
    }

    @NotNull
    public String getRecordIdentifierFeatureName() {
        return (String)Kernel.get((Object)this, (String)"recordIdentifierFeatureName", (NativeType)NativeType.forClass(String.class));
    }

    public void setRecordIdentifierFeatureName(@NotNull String value) {
        Kernel.set((Object)this, (String)"recordIdentifierFeatureName", (Object)Objects.requireNonNull(value, "recordIdentifierFeatureName is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getOfflineStoreConfig() {
        return Kernel.get((Object)this, (String)"offlineStoreConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOfflineStoreConfig(@Nullable Object value) {
        Kernel.set((Object)this, (String)"offlineStoreConfig", (Object)value);
    }

    @Nullable
    public Object getOnlineStoreConfig() {
        return Kernel.get((Object)this, (String)"onlineStoreConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOnlineStoreConfig(@Nullable Object value) {
        Kernel.set((Object)this, (String)"onlineStoreConfig", (Object)value);
    }

    @Nullable
    public String getRoleArn() {
        return (String)Kernel.get((Object)this, (String)"roleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setRoleArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"roleArn", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Nullable
    public Object getThroughputConfig() {
        return Kernel.get((Object)this, (String)"throughputConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setThroughputConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"throughputConfig", (Object)value);
    }

    public void setThroughputConfig(@Nullable ThroughputConfigProperty value) {
        Kernel.set((Object)this, (String)"throughputConfig", (Object)value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.FeatureDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FeatureDefinitionProperty
    extends JsiiSerializable {
        @NotNull
        public String getFeatureName();

        @NotNull
        public String getFeatureType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FeatureDefinitionProperty> {
            String featureName;
            String featureType;

            public Builder featureName(String featureName) {
                this.featureName = featureName;
                return this;
            }

            public Builder featureType(String featureType) {
                this.featureType = featureType;
                return this;
            }

            public FeatureDefinitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFeatureGroup> {
        private final Construct scope;
        private final String id;
        private final CfnFeatureGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnFeatureGroupProps.Builder();
        }

        public Builder eventTimeFeatureName(String eventTimeFeatureName) {
            this.props.eventTimeFeatureName(eventTimeFeatureName);
            return this;
        }

        public Builder featureDefinitions(IResolvable featureDefinitions) {
            this.props.featureDefinitions(featureDefinitions);
            return this;
        }

        public Builder featureDefinitions(List<? extends Object> featureDefinitions) {
            this.props.featureDefinitions(featureDefinitions);
            return this;
        }

        public Builder featureGroupName(String featureGroupName) {
            this.props.featureGroupName(featureGroupName);
            return this;
        }

        public Builder recordIdentifierFeatureName(String recordIdentifierFeatureName) {
            this.props.recordIdentifierFeatureName(recordIdentifierFeatureName);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder offlineStoreConfig(Object offlineStoreConfig) {
            this.props.offlineStoreConfig(offlineStoreConfig);
            return this;
        }

        public Builder onlineStoreConfig(Object onlineStoreConfig) {
            this.props.onlineStoreConfig(onlineStoreConfig);
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder throughputConfig(IResolvable throughputConfig) {
            this.props.throughputConfig(throughputConfig);
            return this;
        }

        public Builder throughputConfig(ThroughputConfigProperty throughputConfig) {
            this.props.throughputConfig(throughputConfig);
            return this;
        }

        public CfnFeatureGroup build() {
            return new CfnFeatureGroup(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.ThroughputConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ThroughputConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getThroughputMode();

        @Nullable
        default public Number getProvisionedReadCapacityUnits() {
            return null;
        }

        @Nullable
        default public Number getProvisionedWriteCapacityUnits() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ThroughputConfigProperty> {
            String throughputMode;
            Number provisionedReadCapacityUnits;
            Number provisionedWriteCapacityUnits;

            public Builder throughputMode(String throughputMode) {
                this.throughputMode = throughputMode;
                return this;
            }

            public Builder provisionedReadCapacityUnits(Number provisionedReadCapacityUnits) {
                this.provisionedReadCapacityUnits = provisionedReadCapacityUnits;
                return this;
            }

            public Builder provisionedWriteCapacityUnits(Number provisionedWriteCapacityUnits) {
                this.provisionedWriteCapacityUnits = provisionedWriteCapacityUnits;
                return this;
            }

            public ThroughputConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.S3StorageConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3StorageConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getS3Uri();

        @Nullable
        default public String getKmsKeyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3StorageConfigProperty> {
            String s3Uri;
            String kmsKeyId;

            public Builder s3Uri(String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public S3StorageConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.OnlineStoreSecurityConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OnlineStoreSecurityConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKmsKeyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OnlineStoreSecurityConfigProperty> {
            String kmsKeyId;

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public OnlineStoreSecurityConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.OnlineStoreConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OnlineStoreConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnableOnlineStore() {
            return null;
        }

        @Nullable
        default public Object getSecurityConfig() {
            return null;
        }

        @Nullable
        default public String getStorageType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OnlineStoreConfigProperty> {
            Object enableOnlineStore;
            Object securityConfig;
            String storageType;

            public Builder enableOnlineStore(Boolean enableOnlineStore) {
                this.enableOnlineStore = enableOnlineStore;
                return this;
            }

            public Builder enableOnlineStore(IResolvable enableOnlineStore) {
                this.enableOnlineStore = enableOnlineStore;
                return this;
            }

            public Builder securityConfig(IResolvable securityConfig) {
                this.securityConfig = securityConfig;
                return this;
            }

            public Builder securityConfig(OnlineStoreSecurityConfigProperty securityConfig) {
                this.securityConfig = securityConfig;
                return this;
            }

            public Builder storageType(String storageType) {
                this.storageType = storageType;
                return this;
            }

            public OnlineStoreConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.OfflineStoreConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OfflineStoreConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getS3StorageConfig();

        @Nullable
        default public Object getDataCatalogConfig() {
            return null;
        }

        @Nullable
        default public Object getDisableGlueTableCreation() {
            return null;
        }

        @Nullable
        default public String getTableFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OfflineStoreConfigProperty> {
            Object s3StorageConfig;
            Object dataCatalogConfig;
            Object disableGlueTableCreation;
            String tableFormat;

            public Builder s3StorageConfig(IResolvable s3StorageConfig) {
                this.s3StorageConfig = s3StorageConfig;
                return this;
            }

            public Builder s3StorageConfig(S3StorageConfigProperty s3StorageConfig) {
                this.s3StorageConfig = s3StorageConfig;
                return this;
            }

            public Builder dataCatalogConfig(IResolvable dataCatalogConfig) {
                this.dataCatalogConfig = dataCatalogConfig;
                return this;
            }

            public Builder dataCatalogConfig(DataCatalogConfigProperty dataCatalogConfig) {
                this.dataCatalogConfig = dataCatalogConfig;
                return this;
            }

            public Builder disableGlueTableCreation(Boolean disableGlueTableCreation) {
                this.disableGlueTableCreation = disableGlueTableCreation;
                return this;
            }

            public Builder disableGlueTableCreation(IResolvable disableGlueTableCreation) {
                this.disableGlueTableCreation = disableGlueTableCreation;
                return this;
            }

            public Builder tableFormat(String tableFormat) {
                this.tableFormat = tableFormat;
                return this;
            }

            public OfflineStoreConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.DataCatalogConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataCatalogConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getCatalog();

        @NotNull
        public String getDatabase();

        @NotNull
        public String getTableName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataCatalogConfigProperty> {
            String catalog;
            String database;
            String tableName;

            public Builder catalog(String catalog) {
                this.catalog = catalog;
                return this;
            }

            public Builder database(String database) {
                this.database = database;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public DataCatalogConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

